/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.snippets.internal;

import org.eclipse.core.expressions.EvaluationContext;
import org.eclipse.core.expressions.EvaluationResult;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.ExpressionConverter;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.wst.common.snippets.core.ISnippetProvider;
import org.eclipse.wst.common.snippets.internal.Logger;

public class SnippetContributor {
    public static final String ID_EXTENSION_POINT_PROVIDER = "org.eclipse.wst.common.snippets.SnippetProvider";
    public static final String CLASS = "class";
    public static final String PRIORITY = "priority";
    public static final String ENABLEMENT = "enablement";
    private ISnippetProvider provider;
    private IConfigurationElement extPointElement;
    private byte priority = (byte)100;
    private boolean initExecuted = false;

    public SnippetContributor(IConfigurationElement extPointElement) {
        this.extPointElement = extPointElement;
        this.initPriority();
    }

    private void initPriority() {
        if (this.extPointElement.getAttribute(PRIORITY) != null) {
            try {
                this.priority = (byte)Integer.parseInt(this.extPointElement.getAttribute(PRIORITY));
                if (this.priority < 0 || this.priority > 100) {
                    this.priority = (byte)100;
                }
            }
            catch (NumberFormatException e) {
                this.priority = (byte)100;
                Logger.logException(e);
            }
        }
    }

    private void initProvider() {
        this.initExecuted = true;
        try {
            this.provider = (ISnippetProvider)this.extPointElement.createExecutableExtension(CLASS);
        }
        catch (CoreException e) {
            Logger.logException(e);
        }
    }

    public boolean isApplicable(Object o) {
        IConfigurationElement[] configurationElements = this.extPointElement.getChildren(ENABLEMENT);
        boolean enabled = false;
        int i = 0;
        while (i < configurationElements.length) {
            try {
                enabled |= this.testEnablement(configurationElements[i], o);
            }
            catch (CoreException coreException) {
                return false;
            }
            ++i;
        }
        return enabled;
    }

    private boolean testEnablement(IConfigurationElement enable, Object o) throws CoreException {
        Expression exp = ExpressionConverter.getDefault().perform(enable);
        EvaluationContext context = new EvaluationContext(null, o);
        context.setAllowPluginActivation(true);
        return EvaluationResult.TRUE == exp.evaluate((IEvaluationContext)context);
    }

    public ISnippetProvider getProvider() {
        if (!this.initExecuted) {
            this.initProvider();
        }
        return this.provider;
    }

    public byte getPriority() {
        return this.priority;
    }

    public String toString() {
        return String.valueOf(super.toString()) + ":" + this.extPointElement.getAttribute(CLASS);
    }
}

