/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.catalog;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.HashSet;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.info.ProductVersionHolder;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derby.iapi.sql.dictionary.CatalogRowFactory;
import org.apache.derby.iapi.sql.dictionary.ConglomerateDescriptor;
import org.apache.derby.iapi.sql.dictionary.SchemaDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.store.access.TransactionController;
import org.apache.derby.iapi.util.IdUtil;
import org.apache.derby.impl.sql.catalog.DataDictionaryImpl;
import org.apache.derby.impl.sql.catalog.TabInfoImpl;

public class DD_Version
implements Formatable {
    private transient DataDictionaryImpl bootingDictionary;
    int majorVersionNumber;
    private int minorVersionNumber;

    public DD_Version() {
    }

    DD_Version(DataDictionaryImpl dataDictionaryImpl, int n) {
        this.majorVersionNumber = n;
        this.minorVersionNumber = this.getJBMSMinorVersionNumber();
        this.bootingDictionary = dataDictionaryImpl;
    }

    public String toString() {
        return DD_Version.majorToString(this.majorVersionNumber);
    }

    private static String majorToString(int n) {
        switch (n) {
            case 80: {
                return "5.0";
            }
            case 90: {
                return "5.1";
            }
            case 100: {
                return "5.2";
            }
            case 110: {
                return "8.1";
            }
            case 120: {
                return "10.0";
            }
            case 130: {
                return "10.1";
            }
            case 140: {
                return "10.2";
            }
            case 150: {
                return "10.3";
            }
            case 160: {
                return "10.4";
            }
            case 170: {
                return "10.5";
            }
            case 180: {
                return "10.6";
            }
            case 190: {
                return "10.7";
            }
            case 200: {
                return "10.8";
            }
            case 210: {
                return "10.9";
            }
            case 220: {
                return "10.10";
            }
            case 230: {
                return "10.11";
            }
        }
        return null;
    }

    void upgradeIfNeeded(DD_Version dD_Version, TransactionController transactionController, Properties properties) throws StandardException {
        Object object;
        if (dD_Version.majorVersionNumber > this.majorVersionNumber) {
            throw StandardException.newException("XCL20.S", dD_Version, this);
        }
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = this.bootingDictionary.af.isReadOnly();
        if (dD_Version.majorVersionNumber == this.majorVersionNumber) {
            if (dD_Version.minorVersionNumber == this.minorVersionNumber) {
                return;
            }
            bl = true;
        } else if (Monitor.isFullUpgrade(properties, dD_Version.toString())) {
            bl2 = true;
        } else {
            bl3 = true;
        }
        transactionController.commit();
        if (bl2) {
            object = IdUtil.getUserNameFromURLProps(properties);
            this.doFullUpgrade(transactionController, dD_Version.majorVersionNumber, IdUtil.getUserAuthorizationId((String)object));
            this.bootingDictionary.af.createReadMeFiles();
        }
        if (!bl && !bl4) {
            object = (DD_Version)transactionController.getProperty("derby.softDataDictionaryVersion");
            int n = 0;
            if (object != null) {
                n = ((DD_Version)object).majorVersionNumber;
            }
            if (n < this.majorVersionNumber) {
                this.applySafeChanges(transactionController, dD_Version.majorVersionNumber, n);
            }
        }
        this.handleMinorRevisionChange(transactionController, dD_Version, bl3);
        transactionController.commit();
    }

    private void applySafeChanges(TransactionController transactionController, int n, int n2) throws StandardException {
        if (n2 <= 140 && n <= 140) {
            this.modifySysTableNullability(transactionController, 11);
            this.modifySysTableNullability(transactionController, 8);
        }
        transactionController.setProperty("derby.softDataDictionaryVersion", this, true);
    }

    private void doFullUpgrade(TransactionController transactionController, int n, String string) throws StandardException {
        if (n < 120) {
            throw StandardException.newException("XCW00.D", DD_Version.majorToString(n), this);
        }
        this.bootingDictionary.updateMetadataSPSes(transactionController);
        HashSet<String> hashSet = new HashSet<String>();
        if (n <= 150) {
            this.bootingDictionary.upgradeMakeCatalog(transactionController, 19);
        }
        if (n <= 130) {
            this.bootingDictionary.upgradeMakeCatalog(transactionController, 16);
            this.bootingDictionary.upgradeMakeCatalog(transactionController, 17);
            this.bootingDictionary.upgradeMakeCatalog(transactionController, 18);
        }
        if (n == 120) {
            this.bootingDictionary.create_10_1_system_procedures(transactionController, hashSet, this.bootingDictionary.getSystemUtilSchemaDescriptor().getUUID());
        }
        if (n <= 170) {
            this.bootingDictionary.create_10_6_system_procedures(transactionController, hashSet);
            this.bootingDictionary.upgradeMakeCatalog(transactionController, 20);
            this.bootingDictionary.upgradeMakeCatalog(transactionController, 21);
        }
        if (n <= 130) {
            this.bootingDictionary.create_10_2_system_procedures(transactionController, hashSet, this.bootingDictionary.getSystemUtilSchemaDescriptor().getUUID());
            this.bootingDictionary.updateSystemSchemaAuthorization(string, transactionController);
            hashSet.add("SYSCS_INPLACE_COMPRESS_TABLE");
            hashSet.add("SYSCS_GET_RUNTIMESTATISTICS");
            hashSet.add("SYSCS_SET_RUNTIMESTATISTICS");
            hashSet.add("SYSCS_COMPRESS_TABLE");
            hashSet.add("SYSCS_SET_STATISTICS_TIMING");
        }
        if (n <= 140) {
            this.bootingDictionary.create_10_3_system_procedures(transactionController, hashSet);
        }
        if (n <= 160) {
            this.bootingDictionary.create_10_5_system_procedures(transactionController, hashSet);
        }
        if (n > 140 && n < 180) {
            this.bootingDictionary.upgradeCLOBGETSUBSTRING_10_6(transactionController);
        }
        if (n > 130 && n < 180) {
            this.bootingDictionary.upgradeSYSROUTINEPERMS_10_6(transactionController);
        }
        if (n <= 200) {
            this.bootingDictionary.create_10_9_system_procedures(transactionController, hashSet);
            this.bootingDictionary.upgradeMakeCatalog(transactionController, 22);
            this.bootingDictionary.upgradeJarStorage(transactionController);
        }
        if (n <= 210) {
            this.bootingDictionary.create_10_10_system_procedures(transactionController, hashSet);
        }
        if (n <= 220) {
            this.bootingDictionary.upgrade_addColumns(this.bootingDictionary.getNonCoreTIByNumber(13).getCatalogRowFactory(), new int[]{18}, transactionController);
            this.bootingDictionary.create_10_11_system_procedures(transactionController, hashSet);
            this.bootingDictionary.createIdentitySequences(transactionController);
        }
        this.bootingDictionary.grantPublicAccessToSystemRoutines(hashSet, transactionController, string);
    }

    private void handleMinorRevisionChange(TransactionController transactionController, DD_Version dD_Version, boolean bl) throws StandardException {
        boolean bl2 = this.bootingDictionary.af.isReadOnly();
        if (!bl2) {
            this.bootingDictionary.clearSPSPlans();
            if (dD_Version.majorVersionNumber >= 170) {
                this.bootingDictionary.updateMetadataSPSes(transactionController);
            }
            if (bl) {
                dD_Version.minorVersionNumber = 1;
                DD_Version dD_Version2 = dD_Version;
            } else {
                DD_Version dD_Version3 = this;
                dD_Version.majorVersionNumber = this.majorVersionNumber;
                dD_Version.minorVersionNumber = this.minorVersionNumber;
            }
            transactionController.setProperty("DataDictionaryVersion", dD_Version, true);
        } else {
            this.bootingDictionary.setReadOnlyUpgrade();
        }
        this.bootingDictionary.clearCaches();
    }

    protected void dropSystemCatalogDescription(TransactionController transactionController, TableDescriptor tableDescriptor) throws StandardException {
        this.bootingDictionary.dropAllColumnDescriptors(tableDescriptor.getUUID(), transactionController);
        this.bootingDictionary.dropAllConglomerateDescriptors(tableDescriptor, transactionController);
        this.bootingDictionary.dropTableDescriptor(tableDescriptor, tableDescriptor.getSchemaDescriptor(), transactionController);
        this.bootingDictionary.clearCaches();
    }

    protected void dropSystemCatalog(TransactionController transactionController, CatalogRowFactory catalogRowFactory) throws StandardException {
        SchemaDescriptor schemaDescriptor = this.bootingDictionary.getSystemSchemaDescriptor();
        TableDescriptor tableDescriptor = this.bootingDictionary.getTableDescriptor(catalogRowFactory.getCatalogName(), schemaDescriptor, transactionController);
        ConglomerateDescriptor[] conglomerateDescriptorArray = tableDescriptor.getConglomerateDescriptors();
        for (int i = 0; i < conglomerateDescriptorArray.length; ++i) {
            transactionController.dropConglomerate(conglomerateDescriptorArray[i].getConglomerateNumber());
        }
        this.dropSystemCatalogDescription(transactionController, tableDescriptor);
    }

    @Override
    public int getTypeFormatId() {
        return this.majorVersionNumber == 90 ? 402 : 401;
    }

    @Override
    public final void readExternal(ObjectInput objectInput) throws IOException {
        this.majorVersionNumber = objectInput.readInt();
        this.minorVersionNumber = objectInput.readInt();
    }

    @Override
    public final void writeExternal(ObjectOutput objectOutput) throws IOException {
        objectOutput.writeInt(this.majorVersionNumber);
        objectOutput.writeInt(this.minorVersionNumber);
    }

    private int getJBMSMinorVersionNumber() {
        ProductVersionHolder productVersionHolder = Monitor.getMonitor().getEngineVersion();
        return productVersionHolder.getMinorVersion() * 100 + productVersionHolder.getMaintVersion() + (productVersionHolder.isBeta() ? 0 : 1) + 2;
    }

    private void modifySysTableNullability(TransactionController transactionController, int n) throws StandardException {
        TabInfoImpl tabInfoImpl = this.bootingDictionary.getNonCoreTIByNumber(n);
        CatalogRowFactory catalogRowFactory = tabInfoImpl.getCatalogRowFactory();
        if (n == 11) {
            this.bootingDictionary.upgradeFixSystemColumnDefinition(catalogRowFactory, 8, transactionController);
        } else if (n == 8) {
            this.bootingDictionary.upgradeFixSystemColumnDefinition(catalogRowFactory, 4, transactionController);
        }
    }

    boolean checkVersion(int n, String string) throws StandardException {
        if (this.majorVersionNumber < n) {
            if (string != null) {
                throw StandardException.newException("XCL47.S", string, DD_Version.majorToString(this.majorVersionNumber), DD_Version.majorToString(n));
            }
            return false;
        }
        return true;
    }
}

