/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.login;

import de.rcenvironment.core.authentication.AuthenticationException;
import de.rcenvironment.core.authentication.AuthenticationService;
import de.rcenvironment.core.authentication.Session;
import de.rcenvironment.core.authentication.User;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.login.LoginConfiguration;
import de.rcenvironment.core.login.LoginInput;
import de.rcenvironment.core.login.internal.Messages;
import de.rcenvironment.core.login.internal.ServiceHandler;
import de.rcenvironment.core.notification.DistributedNotificationService;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractLogin {
    public static final String LOGIN_NOTIFICATION_ID = "de.rcenvironment.rce.login.success";
    protected static final Log LOGGER = LogFactory.getLog(AbstractLogin.class);
    private static final String LOGIN_FAILED_1_9 = "Authentication failed due to an invalid certificate or private key";
    private static final String LOGIN_FAILED_1_2 = "Authentication failed due to an missing password";
    private static final String LOGIN_FAILED_1_3 = "Authentication failed due to an incorrect password";
    private static final String LOGIN_FAILED_1_4 = "Authentication failed due to an not matching caertificate - key file";
    private static final String LOGIN_FAILED_1_5 = "Authentication failed cause certificate not signed by trusted certificate authority (CA).";
    private static final String LOGIN_FAILED_1_6 = "Authentication failed cause certificate is revoked by its certificate authority (CA).";
    private static final String LOGIN_FAILED_1_7 = "Authentication failed due to an unknown reason.";
    private static final String LOGIN_FAILED_2_1 = "Authentication failed due to an invalid password.";
    private static final String LOGIN_FAILED_2_2 = "Authentication failed due to an incorrect password or username.";
    private static final String LOGIN_SUCCESFULL = "Authentication successful. Session created.";
    protected AuthenticationService authenticationService = ServiceHandler.getAuthenticationService();
    protected DistributedNotificationService notificationService = ServiceHandler.getNotificationService();
    protected ConfigurationService configurationService = ServiceHandler.getConfigurationService();
    protected LoginConfiguration loginConfiguration = new LoginConfiguration();

    public AbstractLogin() {
        this.loginConfiguration.setCertificateFile(this.configurationService.resolveBundleConfigurationPath(ServiceHandler.getBundleSymbolicName(), this.loginConfiguration.getCertificateFile()));
        this.loginConfiguration.setKeyFile(this.configurationService.resolveBundleConfigurationPath(ServiceHandler.getBundleSymbolicName(), this.loginConfiguration.getKeyFile()));
    }

    public final boolean login() {
        try {
            boolean loginSuccess = false;
            while (!loginSuccess) {
                LoginInput loginInput = this.getLoginInput();
                loginSuccess = this.singleUserLogin();
                if (loginInput == null) break;
                if (loginInput.getType() == User.Type.single) {
                    this.notificationService.send(LOGIN_NOTIFICATION_ID, (Serializable)((Object)"Anonymouslogin"));
                    LOGGER.debug((Object)"Using anonymous/default login");
                    continue;
                }
                if (loginInput.getType() != User.Type.ldap) continue;
                loginSuccess = this.ldapLogin(loginInput.getUsernameLDAP(), loginInput.getPassword());
            }
            if (loginSuccess) {
                this.notificationService.send(LOGIN_NOTIFICATION_ID, (Serializable)((Object)"Login successful."));
                return true;
            }
        }
        catch (AuthenticationException e) {
            this.informUserAboutError(String.valueOf(Messages.authenticationFailed) + " " + Messages.certOrKeyIncorrect, e);
            LOGGER.error((Object)LOGIN_FAILED_1_9, (Throwable)e);
        }
        return false;
    }

    private boolean singleUserLogin() {
        Session.create((User)this.authenticationService.createUser(this.loginConfiguration.getValidityInDays()));
        return true;
    }

    private boolean ldapLogin(String userID, String password) {
        boolean isLoginSuccessful = false;
        AuthenticationService.LDAPAuthenticationResult authenticationResult = this.authenticationService.authenticate(userID, password);
        if (AuthenticationService.LDAPAuthenticationResult.AUTHENTICATED == authenticationResult) {
            isLoginSuccessful = true;
            Session.create((String)userID, (int)this.loginConfiguration.getValidityInDays());
            LOGGER.info((Object)LOGIN_SUCCESFULL);
        } else {
            String reasonForFailingEN;
            String reasonForFailing;
            isLoginSuccessful = false;
            switch (authenticationResult) {
                case PASSWORD__OR_USERNAME_INVALID: {
                    reasonForFailing = Messages.passwordInvalid;
                    reasonForFailingEN = LOGIN_FAILED_2_1;
                    break;
                }
                case PASSWORD_OR_USERNAME_INCORRECT: {
                    reasonForFailing = Messages.passwordOrUsernameIncorrect;
                    reasonForFailingEN = LOGIN_FAILED_2_2;
                    break;
                }
                default: {
                    reasonForFailing = Messages.unknownReason;
                    reasonForFailingEN = LOGIN_FAILED_1_7;
                }
            }
            this.informUserAboutError(String.valueOf(Messages.authenticationFailed) + " " + reasonForFailing, null);
            LOGGER.error((Object)reasonForFailingEN);
        }
        return isLoginSuccessful;
    }

    public final void logout() {
        try {
            Session.getInstance().destroy();
        }
        catch (AuthenticationException authenticationException) {
            LOGGER.warn((Object)"Already logged out.");
        }
    }

    protected abstract void informUserAboutError(String var1, Throwable var2);

    protected abstract LoginInput getLoginInput() throws AuthenticationException;

    protected LoginInput createLoginInputLDAP(String usernameLDAP, String password) throws AuthenticationException {
        LoginInput loginInput = new LoginInput(usernameLDAP, password);
        return loginInput;
    }
}

