/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.cluster.view.internal;

import de.rcenvironment.core.gui.cluster.view.internal.ClusterJobInformationModel;
import de.rcenvironment.core.gui.cluster.view.internal.ClusterJobMonitorView;
import de.rcenvironment.core.utils.cluster.ClusterJobInformation;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;

public class ClusterJobInformationTableFilter
extends ViewerFilter
implements SelectionListener,
KeyListener {
    private boolean queuedSetup;
    private boolean runningSetup;
    private boolean othersSetup;
    private ClusterJobMonitorView clusterJobMonitoringView;
    private TableViewer tableViewer;

    public ClusterJobInformationTableFilter(ClusterJobMonitorView loggingView, TableViewer tableViewer) {
        this.clusterJobMonitoringView = loggingView;
        this.tableViewer = tableViewer;
        this.updateTableView();
        tableViewer.getTable().setFocus();
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        ClusterJobInformation logEntry;
        boolean returnValue = false;
        if (element instanceof ClusterJobInformation && this.isLevelSelected((logEntry = (ClusterJobInformation)element).getJobState())) {
            if (this.isSelectedBySearchTerm(logEntry.getJobId())) {
                returnValue = true;
            } else if (this.isSelectedBySearchTerm(logEntry.getJobName())) {
                returnValue = true;
            } else if (this.isSelectedBySearchTerm(logEntry.getUser())) {
                returnValue = true;
            } else if (this.isSelectedBySearchTerm(logEntry.getQueue())) {
                returnValue = true;
            } else if (this.isSelectedBySearchTerm(logEntry.getRemainingTime())) {
                returnValue = true;
            } else if (this.isSelectedBySearchTerm(logEntry.getStartTime())) {
                returnValue = true;
            } else if (this.isSelectedBySearchTerm(logEntry.getQueueTime())) {
                returnValue = true;
            } else if (this.isSelectedBySearchTerm(logEntry.getJobState().toString())) {
                returnValue = true;
            }
        }
        return returnValue;
    }

    public void widgetDefaultSelected(SelectionEvent e) {
        this.widgetSelected(e);
    }

    public void widgetSelected(SelectionEvent e) {
        this.updateTableView();
        this.tableViewer.getTable().setFocus();
    }

    public void keyPressed(KeyEvent arg0) {
    }

    public void keyReleased(KeyEvent arg0) {
        this.updateTableView();
    }

    private void updateTableView() {
        this.queuedSetup = this.clusterJobMonitoringView.getQueuedSelection();
        this.runningSetup = this.clusterJobMonitoringView.getRunningSelection();
        this.othersSetup = this.clusterJobMonitoringView.getOthersSelection();
        ClusterJobInformationModel.getInstance().setSelectedConnectedConfigurationName(this.clusterJobMonitoringView.getSelectedConnectedConfigurationName());
        this.tableViewer.refresh();
    }

    private boolean isLevelSelected(ClusterJobInformation.ClusterJobState jobState) {
        boolean returnValue = false;
        if (ClusterJobInformation.ClusterJobState.Queued == jobState && this.queuedSetup) {
            returnValue = true;
        } else if (ClusterJobInformation.ClusterJobState.Running == jobState && this.runningSetup) {
            returnValue = true;
        } else if (ClusterJobInformation.ClusterJobState.Completed != jobState && ClusterJobInformation.ClusterJobState.Queued != jobState && ClusterJobInformation.ClusterJobState.Running != jobState && this.othersSetup) {
            returnValue = true;
        }
        return returnValue;
    }

    private boolean isSelectedBySearchTerm(String entryText) {
        boolean returnValue = false;
        String searchTerm = this.clusterJobMonitoringView.getSearchText();
        if (searchTerm == null || searchTerm.length() == 0) {
            returnValue = true;
        } else if (this.textMatchesSearchTerm(searchTerm, entryText)) {
            returnValue = true;
        }
        return returnValue;
    }

    private boolean textMatchesSearchTerm(String searchTerm, String entryText) {
        return entryText.toLowerCase().contains(searchTerm.toLowerCase());
    }
}

