/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.datamanagement.export.objects;

import com.fasterxml.jackson.annotation.JsonProperty;
import de.rcenvironment.core.datamanagement.commons.ComponentInstance;
import de.rcenvironment.core.datamanagement.commons.ComponentRun;
import de.rcenvironment.core.datamanagement.export.matching.MatchResult;
import de.rcenvironment.core.datamanagement.export.matching.Matchable;
import de.rcenvironment.core.datamanagement.export.matching.Matcher;
import de.rcenvironment.core.datamanagement.export.objects.PlainComponentRun;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PlainComponentInstance
implements Comparable<PlainComponentInstance>,
Matchable<PlainComponentInstance> {
    @JsonProperty(value="component")
    private String id;
    @JsonProperty
    private String name;
    @JsonProperty(value="runs")
    private List<PlainComponentRun> plainComponentRuns;

    public PlainComponentInstance() {
    }

    public PlainComponentInstance(ComponentInstance instance, Set<ComponentRun> componentRuns, TypedDatumSerializer typedDatumSerializer) {
        this.id = instance.getComponentID();
        this.name = instance.getComponentInstanceName();
        this.plainComponentRuns = new LinkedList<PlainComponentRun>();
        for (ComponentRun componentRun : componentRuns) {
            this.plainComponentRuns.add(new PlainComponentRun(componentRun, typedDatumSerializer));
        }
        this.plainComponentRuns.sort(null);
    }

    @Override
    public int compareTo(PlainComponentInstance o) {
        return this.name.compareTo(o.name);
    }

    @Override
    public MatchResult matches(Map<DataType, Matcher> matchers, PlainComponentInstance expected) {
        MatchResult result = new MatchResult();
        if (!this.id.equals(expected.id)) {
            result.addFailureCause(StringUtils.format((String)"The id %s does not match %s", (Object[])new Object[]{this.id, expected.id}));
        }
        if (!this.name.equals(expected.name)) {
            result.addFailureCause(StringUtils.format((String)"The name %s does not match %s", (Object[])new Object[]{this.name, expected.name}));
        }
        if (this.plainComponentRuns.size() == expected.plainComponentRuns.size()) {
            int i = 0;
            while (i < this.plainComponentRuns.size()) {
                MatchResult nestedMatchResult = this.plainComponentRuns.get(i).matches(matchers, expected.plainComponentRuns.get(i));
                if (!nestedMatchResult.hasMatched()) {
                    result.addFailureCause(StringUtils.format((String)"Component run %d does not match", (Object[])new Object[]{i}), nestedMatchResult);
                }
                ++i;
            }
        } else {
            result.addFailureCause(StringUtils.format((String)"The number of runs %d does not match the expected number of runs %d", (Object[])new Object[]{this.plainComponentRuns.size(), expected.plainComponentRuns.size()}));
        }
        return result;
    }

    public String getName() {
        return this.name;
    }
}

