/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.component.api.BatchedConsoleRowsProcessor;
import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.execution.api.SingleConsoleRowsProcessor;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchAggregator;
import de.rcenvironment.toolkit.modules.concurrency.api.BatchProcessor;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class BatchingConsoleRowsForwarderImpl
implements SingleConsoleRowsProcessor {
    private static final int MAX_BATCH_SIZE = 500;
    private static final long MAX_BATCH_LATENCY_MSEC = 200L;
    private final BatchAggregator<ConsoleRow> batchAggregator;
    private final Log log = LogFactory.getLog(this.getClass());

    public BatchingConsoleRowsForwarderImpl(final BatchedConsoleRowsProcessor consoleRowsReceiver) {
        BatchProcessor<ConsoleRow> batchProcessor = new BatchProcessor<ConsoleRow>(){

            public void processBatch(List<ConsoleRow> batch) {
                ConsoleRow[] batchArray = batch.toArray(new ConsoleRow[batch.size()]);
                try {
                    consoleRowsReceiver.processConsoleRows(batchArray);
                }
                catch (UndeclaredThrowableException e) {
                    BatchingConsoleRowsForwarderImpl.this.log.error((Object)"Could not send console rows to caller.", (Throwable)e);
                }
            }
        };
        this.batchAggregator = ConcurrencyUtils.getFactory().createBatchAggregator(500, 200L, (BatchProcessor)batchProcessor);
    }

    @Override
    public void onConsoleRow(ConsoleRow consoleRow) {
        this.batchAggregator.enqueue((Object)consoleRow);
    }
}

