/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.workflow.execution.impl;

import de.rcenvironment.core.component.execution.api.ConsoleRow;
import de.rcenvironment.core.component.workflow.execution.api.GenericSubscriptionEventProcessor;
import de.rcenvironment.core.component.workflow.execution.internal.ConsoleRowProcessor;
import de.rcenvironment.core.notification.Notification;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallback;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedCallbackManager;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ConsoleSubscriptionEventProcessor
extends GenericSubscriptionEventProcessor {
    private static final long serialVersionUID = 5521705555312627039L;
    private final transient Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final transient AsyncOrderedCallbackManager<ConsoleRowProcessor> callbackManager = ConcurrencyUtils.getFactory().createAsyncOrderedCallbackManager(AsyncCallbackExceptionPolicy.LOG_AND_PROCEED);

    public ConsoleSubscriptionEventProcessor(ConsoleRowProcessor ... processors) {
        ConsoleRowProcessor[] consoleRowProcessorArray = processors;
        int n = processors.length;
        int n2 = 0;
        while (n2 < n) {
            ConsoleRowProcessor processor = consoleRowProcessorArray[n2];
            this.callbackManager.addListener((Object)processor);
            ++n2;
        }
    }

    @Override
    protected void processCollectedNotifications(List<Notification> notifications) {
        final ArrayList<ConsoleRow> consoleRows = new ArrayList<ConsoleRow>();
        for (Notification notification : notifications) {
            Serializable body = notification.getBody();
            if (body instanceof ConsoleRow) {
                ConsoleRow consoleRow = (ConsoleRow)notification.getBody();
                consoleRow.setIndex(notification.getHeader().getNumber());
                consoleRows.add(consoleRow);
                continue;
            }
            this.log.warn((Object)("Received unexpected notification of type " + body.getClass() + " for topic " + notification.getHeader().getNotificationIdentifier()));
        }
        this.callbackManager.enqueueCallback((AsyncCallback)new AsyncCallback<ConsoleRowProcessor>(){

            public void performCallback(ConsoleRowProcessor listener) {
                listener.processConsoleRows(consoleRows);
            }
        });
    }
}

