/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.uplinktoolaccess.internal;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.authorization.api.AuthorizationAccessGroup;
import de.rcenvironment.core.authorization.api.AuthorizationAccessGroupKeyData;
import de.rcenvironment.core.authorization.api.AuthorizationPermissionSet;
import de.rcenvironment.core.authorization.api.AuthorizationService;
import de.rcenvironment.core.authorization.cryptography.api.CryptographyOperationsProvider;
import de.rcenvironment.core.authorization.cryptography.api.SymmetricKey;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.NodeIdentifierUtils;
import de.rcenvironment.core.communication.uplink.client.session.api.ClientSideUplinkSession;
import de.rcenvironment.core.communication.uplink.client.session.api.DestinationIdUtils;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionListener;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionListenerAdapter;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionService;
import de.rcenvironment.core.communication.uplink.client.session.api.SshUplinkConnectionSetup;
import de.rcenvironment.core.communication.uplink.client.session.api.ToolDescriptor;
import de.rcenvironment.core.communication.uplink.client.session.api.ToolDescriptorListUpdate;
import de.rcenvironment.core.component.api.DistributedComponentKnowledge;
import de.rcenvironment.core.component.api.DistributedComponentKnowledgeService;
import de.rcenvironment.core.component.api.UserComponentIdMappingService;
import de.rcenvironment.core.component.management.api.DistributedComponentEntry;
import de.rcenvironment.core.component.management.utils.JsonDataEncryptionUtils;
import de.rcenvironment.core.component.management.utils.JsonDataWithOptionalEncryption;
import de.rcenvironment.core.component.model.api.ComponentInterface;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDefinition;
import de.rcenvironment.core.component.spi.DistributedComponentKnowledgeListener;
import de.rcenvironment.core.component.uplinktoolaccess.UplinkToolAnnouncementService;
import de.rcenvironment.core.component.uplinktoolaccess.internal.UplinkToolAccessComponentDescription;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class UplinkToolAnnouncementServiceImpl
implements UplinkToolAnnouncementService {
    private static final String AUTHORIZATION_GROUP_PREFIX = "external_";
    private static final String KEY_META_DATA = "metaData";
    private static final String KEY_DEFAULT_DATA_TYPE = "defaultDataType";
    private static final String KEY_DATA_TYPES = "dataTypes";
    private static final String KEY_INPUT_HANDLING_OPTIONS = "inputHandlingOptions";
    private static final String KEY_DEFAULT_INPUT_HANDLING = "defaultInputHandling";
    private static final String KEY_EXECUTION_CONSTRAINT_OPTIONS = "inputExecutionConstraintOptions";
    private static final String KEY_DEFAULT_EXECUTION_CONSTRAINT = "defaultInputExecutionConstraint";
    private static final String KEY_DEFAULT_VALUE = "defaultValue";
    private static final String KEY_POSSIBLE_VALUES = "possibleValues";
    private ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();
    private final Log log = LogFactory.getLog(this.getClass());
    private ServiceRegistryPublisherAccess serviceRegistryAccess;
    @Reference
    private SshUplinkConnectionService uplinkConnectionService;
    @Reference
    private DistributedComponentKnowledgeService componentKnowledgeService;
    @Reference
    private UserComponentIdMappingService userComponentIdMappingService;
    @Reference
    private PlatformService platformService;
    @Reference
    private AuthorizationService authorizationService;
    private Set<String> publishedDestinationIds;

    public void activate() {
        this.serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)this);
        this.publishedDestinationIds = new HashSet<String>();
        this.registerChangeListener();
    }

    private void registerChangeListener() {
        this.serviceRegistryAccess.registerService(DistributedComponentKnowledgeListener.class, (Object)new DistributedComponentKnowledgeListener(){

            public void onDistributedComponentKnowledgeChanged(DistributedComponentKnowledge newKnowledge) {
                UplinkToolAnnouncementServiceImpl.this.updateToolAnnouncements();
            }
        });
        this.uplinkConnectionService.addListener((SshUplinkConnectionListener)new SshUplinkConnectionListenerAdapter(){

            public void onConnected(SshUplinkConnectionSetup setup) {
                UplinkToolAnnouncementServiceImpl.this.updateToolAnnouncements();
            }
        });
    }

    private synchronized void updateToolAnnouncements() {
        HashMap toolsToAnnounceByDestinationId = new HashMap();
        for (String destinationId : this.publishedDestinationIds) {
            toolsToAnnounceByDestinationId.put(destinationId, new ArrayList());
        }
        this.publishedDestinationIds = new HashSet<String>();
        HashMap<String, String> destinationIdToDisplayName = new HashMap<String, String>();
        for (Map.Entry<DistributedComponentEntry, AuthorizationPermissionSet> entry : this.getMatchingPublishedToolsWithAuthGroups().entrySet()) {
            String userComponentId;
            DistributedComponentEntry componentEntry = entry.getKey();
            ComponentInterface compInterface = componentEntry.getComponentInterface();
            String destinationId = DestinationIdUtils.getInternalDestinationIdForLogicalNodeId((String)componentEntry.getNodeId());
            this.publishedDestinationIds.add(destinationId);
            String displayName = componentEntry.getComponentInstallation().getNodeIdObject().getAssociatedDisplayName();
            destinationIdToDisplayName.put(destinationId, displayName);
            try {
                userComponentId = this.userComponentIdMappingService.fromInternalToExternalId(compInterface.getIdentifier());
            }
            catch (OperationFailureException e1) {
                this.log.error((Object)("Component Id " + compInterface.getIdentifier() + " could not be converted. Cause: " + e1.getMessage()));
                continue;
            }
            try {
                JsonDataWithOptionalEncryption jsonData;
                Set<Map<String, Object>> nodeInputSet = this.generateNodeInputSet(componentEntry);
                Set<Map<String, Object>> nodeOutputSet = this.generateNodeOutputSet(componentEntry);
                List rawConfigurationValues = componentEntry.getComponentInterface().getConfigurationDefinition().getRawConfigurationDefinition();
                List rawConfigurationMetadata = componentEntry.getComponentInterface().getConfigurationDefinition().getRawConfigurationMetaDataDefinition();
                Map readOnlyconfig = componentEntry.getComponentInterface().getConfigurationDefinition().getReadOnlyConfiguration().getConfiguration();
                Map<String, String> readOnlyConfigToSend = this.generateReadOnlyConfigToSend(readOnlyconfig);
                UplinkToolAccessComponentDescription toolDescription = new UplinkToolAccessComponentDescription(userComponentId, compInterface.getDisplayName(), compInterface.getVersion(), nodeInputSet, nodeOutputSet, rawConfigurationValues, rawConfigurationMetadata, compInterface.getGroupName(), compInterface.getDocumentationHash(), readOnlyConfigToSend);
                String serializedToolData = this.mapper.writeValueAsString((Object)toolDescription);
                HashSet<String> authGroupIds = new HashSet<String>();
                if (entry.getValue().isPublic()) {
                    jsonData = JsonDataEncryptionUtils.asPublicData((String)serializedToolData);
                    authGroupIds.add(entry.getValue().getArbitraryGroup().getFullId());
                } else {
                    HashMap<String, SymmetricKey> keyData = new HashMap<String, SymmetricKey>();
                    for (AuthorizationAccessGroup group : entry.getValue().getAccessGroups()) {
                        AuthorizationAccessGroupKeyData keyDataForGroup = this.authorizationService.getKeyDataForGroup(group);
                        if (keyDataForGroup == null) {
                            this.log.warn((Object)("Found no key data for assigned access group " + group.getFullId()));
                            continue;
                        }
                        keyData.put(group.getFullId(), keyDataForGroup.getSymmetricKey());
                        authGroupIds.add(group.getFullId());
                    }
                    jsonData = JsonDataEncryptionUtils.encryptForKeys((String)serializedToolData, keyData, (CryptographyOperationsProvider)this.authorizationService.getCryptographyOperationsProvider());
                }
                if (toolsToAnnounceByDestinationId.get(destinationId) == null) {
                    toolsToAnnounceByDestinationId.put(destinationId, new ArrayList());
                }
                ((List)toolsToAnnounceByDestinationId.get(destinationId)).add(new ToolDescriptor(userComponentId, compInterface.getVersion(), authGroupIds, toolDescription.createHashString(), jsonData));
            }
            catch (IOException iOException) {
                this.log.error((Object)"An error occured while creating descriptions of the available tools.");
            }
            catch (OperationFailureException operationFailureException) {
                this.log.error((Object)"An error occured while encrypting json data.");
            }
        }
        String destinationIdForLocalInstance = DestinationIdUtils.getInternalDestinationIdForLogicalNodeId((String)this.platformService.getLocalDefaultLogicalNodeId().getLogicalNodeIdString());
        for (SshUplinkConnectionSetup setup : this.uplinkConnectionService.getAllActiveSshConnectionSetups().values()) {
            ClientSideUplinkSession session = setup.getSession();
            for (String destinationId : toolsToAnnounceByDestinationId.keySet()) {
                if (!setup.isGateway() && !destinationId.equals(destinationIdForLocalInstance)) continue;
                String qualifiedDestinationId = DestinationIdUtils.getQualifiedDestinationId((String)setup.getDestinationIdPrefix(), (String)destinationId);
                try {
                    session.publishToolDescriptorListUpdate(new ToolDescriptorListUpdate(qualifiedDestinationId, (String)destinationIdToDisplayName.get(destinationId), (List)toolsToAnnounceByDestinationId.get(destinationId)));
                }
                catch (IOException iOException) {
                    this.log.error((Object)("Failed to send a tool descriptor update to Uplink session " + qualifiedDestinationId));
                }
            }
        }
    }

    private Map<String, String> generateReadOnlyConfigToSend(Map<String, String> readOnlyconfig) {
        HashMap<String, String> readOnlyConfigToSend = new HashMap<String, String>();
        readOnlyConfigToSend.put("toolName", readOnlyconfig.get("toolName"));
        readOnlyConfigToSend.put("toolIntegratorName", readOnlyconfig.get("toolIntegratorName"));
        readOnlyConfigToSend.put("toolIntegratorE-Mail", readOnlyconfig.get("toolIntegratorE-Mail"));
        readOnlyConfigToSend.put("toolDescription", readOnlyconfig.get("toolDescription"));
        readOnlyConfigToSend.put("imitationModeSupported", readOnlyconfig.get("imitationModeSupported"));
        readOnlyConfigToSend.put("deleteWorkingDirectoriesNever", readOnlyconfig.get("deleteWorkingDirectoriesNever"));
        readOnlyConfigToSend.put("deleteWorkingDirectoriesAfterWorkflowExecution", readOnlyconfig.get("deleteWorkingDirectoriesAfterWorkflowExecution"));
        readOnlyConfigToSend.put("deleteWorkingDirectoriesAfterIteration", readOnlyconfig.get("deleteWorkingDirectoriesAfterIteration"));
        readOnlyConfigToSend.put("deleteWorkingDirectoriesKeepOnErrorIteration", readOnlyconfig.get("deleteWorkingDirectoriesKeepOnErrorIteration"));
        readOnlyConfigToSend.put("deleteWorkingDirectoriesKeepOnErrorOnce", readOnlyconfig.get("deleteWorkingDirectoriesKeepOnErrorOnce"));
        return readOnlyConfigToSend;
    }

    private Set<Map<String, Object>> generateNodeOutputSet(DistributedComponentEntry componentEntry) {
        HashMap<String, Object> rawEndpointData;
        HashSet<Map<String, Object>> nodeOutputSet = new HashSet<Map<String, Object>>();
        for (EndpointDefinition ed : componentEntry.getComponentInterface().getOutputDefinitionsProvider().getStaticEndpointDefinitions()) {
            rawEndpointData = new HashMap<String, Object>();
            rawEndpointData.put("name", ed.getName());
            rawEndpointData.put(KEY_DATA_TYPES, ed.getPossibleDataTypes());
            rawEndpointData.put(KEY_DEFAULT_DATA_TYPE, ed.getDefaultDataType());
            nodeOutputSet.add(rawEndpointData);
        }
        for (EndpointDefinition ed : componentEntry.getComponentInterface().getOutputDefinitionsProvider().getDynamicEndpointDefinitions()) {
            rawEndpointData = new HashMap();
            rawEndpointData.put("identifier", ed.getIdentifier());
            rawEndpointData.put(KEY_DATA_TYPES, ed.getPossibleDataTypes());
            rawEndpointData.put(KEY_DEFAULT_DATA_TYPE, ed.getDefaultDataType());
            Map<String, Map<String, Object>> rawMetadata = this.extractRawMetadata(ed);
            rawEndpointData.put(KEY_META_DATA, rawMetadata);
            nodeOutputSet.add(rawEndpointData);
        }
        return nodeOutputSet;
    }

    private Set<Map<String, Object>> generateNodeInputSet(DistributedComponentEntry componentEntry) {
        HashMap<String, Object> rawEndpointData;
        HashSet<Map<String, Object>> nodeInputSet = new HashSet<Map<String, Object>>();
        for (EndpointDefinition ed : componentEntry.getComponentInterface().getInputDefinitionsProvider().getStaticEndpointDefinitions()) {
            rawEndpointData = new HashMap<String, Object>();
            rawEndpointData.put("name", ed.getName());
            rawEndpointData.put(KEY_DATA_TYPES, ed.getPossibleDataTypes());
            rawEndpointData.put(KEY_DEFAULT_DATA_TYPE, ed.getDefaultDataType());
            rawEndpointData.put(KEY_INPUT_HANDLING_OPTIONS, ed.getInputDatumOptions());
            rawEndpointData.put(KEY_DEFAULT_INPUT_HANDLING, ed.getDefaultInputDatumHandling());
            rawEndpointData.put(KEY_EXECUTION_CONSTRAINT_OPTIONS, ed.getInputExecutionConstraintOptions());
            rawEndpointData.put(KEY_DEFAULT_EXECUTION_CONSTRAINT, ed.getDefaultInputExecutionConstraint());
            nodeInputSet.add(rawEndpointData);
        }
        for (EndpointDefinition ed : componentEntry.getComponentInterface().getInputDefinitionsProvider().getDynamicEndpointDefinitions()) {
            rawEndpointData = new HashMap();
            rawEndpointData.put("identifier", ed.getIdentifier());
            rawEndpointData.put(KEY_DATA_TYPES, ed.getPossibleDataTypes());
            rawEndpointData.put(KEY_DEFAULT_DATA_TYPE, ed.getDefaultDataType());
            rawEndpointData.put(KEY_INPUT_HANDLING_OPTIONS, ed.getInputDatumOptions());
            rawEndpointData.put(KEY_DEFAULT_INPUT_HANDLING, ed.getDefaultInputDatumHandling());
            rawEndpointData.put(KEY_EXECUTION_CONSTRAINT_OPTIONS, ed.getInputExecutionConstraintOptions());
            rawEndpointData.put(KEY_DEFAULT_EXECUTION_CONSTRAINT, ed.getDefaultInputExecutionConstraint());
            Map<String, Map<String, Object>> rawMetadata = this.extractRawMetadata(ed);
            rawEndpointData.put(KEY_META_DATA, rawMetadata);
            nodeInputSet.add(rawEndpointData);
        }
        return nodeInputSet;
    }

    private Map<String, Map<String, Object>> extractRawMetadata(EndpointDefinition ed) {
        HashMap<String, Map<String, Object>> rawMetadata = new HashMap<String, Map<String, Object>>();
        for (String key : ed.getMetaDataDefinition().getMetaDataKeys()) {
            HashMap<String, Object> metaDataForKey = new HashMap<String, Object>();
            metaDataForKey.put("guiName", ed.getMetaDataDefinition().getGuiName(key));
            metaDataForKey.put("guiPosition", Integer.toString(ed.getMetaDataDefinition().getGuiPosition(key)));
            metaDataForKey.put("guiGroup", ed.getMetaDataDefinition().getGuiGroup(key));
            metaDataForKey.put(KEY_POSSIBLE_VALUES, ed.getMetaDataDefinition().getPossibleValues(key));
            metaDataForKey.put(KEY_DEFAULT_VALUE, ed.getMetaDataDefinition().getDefaultValue(key));
            metaDataForKey.put("visibility", ed.getMetaDataDefinition().getVisibility(key));
            rawMetadata.put(key, metaDataForKey);
        }
        return rawMetadata;
    }

    private Map<DistributedComponentEntry, AuthorizationPermissionSet> getMatchingPublishedToolsWithAuthGroups() {
        HashMap<DistributedComponentEntry, AuthorizationPermissionSet> components = new HashMap<DistributedComponentEntry, AuthorizationPermissionSet>();
        DistributedComponentKnowledge compKnowledge = this.componentKnowledgeService.getCurrentSnapshot();
        for (DistributedComponentEntry entry : compKnowledge.getKnownSharedInstallations()) {
            ComponentInterface compInterf = entry.getComponentInterface();
            if (!compInterf.getIdentifierAndVersion().startsWith("de.rcenvironment.integration") || !NodeIdentifierUtils.parseArbitraryIdStringToLogicalNodeIdWithExceptionWrapping((String)entry.getNodeId()).getLogicalNodePart().equals("0")) continue;
            if (entry.getDeclaredPermissionSet().isPublic()) {
                components.put(entry, entry.getDeclaredPermissionSet());
                continue;
            }
            HashSet<AuthorizationAccessGroup> sshGroupsForTool = new HashSet<AuthorizationAccessGroup>();
            for (AuthorizationAccessGroup group : entry.getDeclaredPermissionSet().getAccessGroups()) {
                if (!this.authorizationService.isPublicAccessGroup(group) && !group.getName().toLowerCase().startsWith(AUTHORIZATION_GROUP_PREFIX)) continue;
                sshGroupsForTool.add(group);
            }
            if (sshGroupsForTool.isEmpty()) continue;
            components.put(entry, this.authorizationService.buildPermissionSet(sshGroupsForTool));
        }
        return components;
    }
}

