/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.uplink.client.session.impl;

import de.rcenvironment.core.communication.api.LogicalNodeManagementService;
import de.rcenvironment.core.communication.common.LogicalNodeId;
import de.rcenvironment.core.communication.uplink.client.session.api.UplinkLogicalNodeMappingService;
import de.rcenvironment.core.communication.uplink.network.internal.UplinkProtocolConstants;
import de.rcenvironment.core.utils.common.StringUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component(immediate=true)
public class UplinkLogicalNodeMappingServiceImpl
implements UplinkLogicalNodeMappingService {
    private final Map<String, LogicalNodeId> destinationIdToLogicalNodeMap = Collections.synchronizedMap(new HashMap());
    private final Map<String, String> destinationIdToAnnouncedNameMap = Collections.synchronizedMap(new HashMap());
    @Reference
    private LogicalNodeManagementService logicalNodeManagementService;

    @Override
    public LogicalNodeId createOrGetLocalLogicalNodeIdForDestinationId(String destinationId, String announcedDisplayName) {
        if (this.destinationIdToLogicalNodeMap.containsKey(destinationId)) {
            return this.destinationIdToLogicalNodeMap.get(destinationId);
        }
        String logicalNodeRecognitionPart = this.deriveLogicalNodeRecognitionPart(destinationId);
        String logicalNodeDisplayName = this.deriveLogicalNodeDisplayName(destinationId, announcedDisplayName);
        LogicalNodeId logicalNodeId = this.logicalNodeManagementService.createRecognizableLocalLogicalNodeId(logicalNodeRecognitionPart, logicalNodeDisplayName);
        this.destinationIdToLogicalNodeMap.put(destinationId, logicalNodeId);
        this.destinationIdToAnnouncedNameMap.put(destinationId, announcedDisplayName);
        return logicalNodeId;
    }

    private String deriveLogicalNodeDisplayName(String destinationId, String announcedDisplayName) {
        String loginName = org.apache.commons.lang3.StringUtils.removeEnd((String)destinationId.substring(0, 8), (String)UplinkProtocolConstants.DESTINATION_ID_PREFIX_PADDING_CHARACTER_AS_STRING);
        String sessionQualifier = org.apache.commons.lang3.StringUtils.removeEnd((String)destinationId.substring(8, 16), (String)UplinkProtocolConstants.DESTINATION_ID_PREFIX_PADDING_CHARACTER_AS_STRING);
        return StringUtils.format((String)"%s (via %s/%s)", (Object[])new Object[]{announcedDisplayName, loginName, sessionQualifier});
    }

    private String deriveLogicalNodeRecognitionPart(String destinationId) {
        if (StringUtils.isNullorEmpty((String)destinationId)) {
            throw new IllegalArgumentException("Empty or null destination ID");
        }
        String nodeIdPart = destinationId.replaceAll("[^0-9a-zA-Z]", "_");
        if (nodeIdPart.length() < 32) {
            throw new IllegalArgumentException("Unexpected short node id");
        }
        return nodeIdPart.substring(0, 32);
    }

    @Override
    public LogicalNodeId getLocalLogicalNodeIdForDestinationIdAndUpdateName(String destinationId, String announcedDisplayName) {
        if (this.destinationIdToLogicalNodeMap.containsKey(destinationId)) {
            this.updateDisplayNameIfNecessary(destinationId, announcedDisplayName);
            return this.destinationIdToLogicalNodeMap.get(destinationId);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDestinationIdForLogicalNodeId(LogicalNodeId logicalNodeId) {
        Map<String, LogicalNodeId> map = this.destinationIdToLogicalNodeMap;
        synchronized (map) {
            for (Map.Entry<String, LogicalNodeId> entry : this.destinationIdToLogicalNodeMap.entrySet()) {
                if (!entry.getValue().equals(logicalNodeId)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getDestinationIdForLogicalNodeId(String logicalNodeId) {
        Map<String, LogicalNodeId> map = this.destinationIdToLogicalNodeMap;
        synchronized (map) {
            for (Map.Entry<String, LogicalNodeId> entry : this.destinationIdToLogicalNodeMap.entrySet()) {
                if (!entry.getValue().getLogicalNodeIdString().equals(logicalNodeId)) continue;
                return entry.getKey();
            }
        }
        return null;
    }

    private void updateDisplayNameIfNecessary(String destinationId, String announcedDisplayName) {
        if (!(announcedDisplayName == null || this.destinationIdToAnnouncedNameMap.get(destinationId) != null && this.destinationIdToAnnouncedNameMap.get(destinationId).equals(announcedDisplayName))) {
            LogicalNodeId logicalNodeId = this.destinationIdToLogicalNodeMap.get(destinationId);
            String logicalNodeDisplayName = this.deriveLogicalNodeDisplayName(destinationId, announcedDisplayName);
            this.logicalNodeManagementService.updateDisplayNameForLocalLogicalNodeId(logicalNodeId, logicalNodeDisplayName);
            this.destinationIdToAnnouncedNameMap.put(destinationId, announcedDisplayName);
        }
    }
}

