/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.command.internal;

import de.rcenvironment.core.command.api.CommandExecutionResult;
import de.rcenvironment.core.command.api.CommandExecutionService;
import de.rcenvironment.core.command.internal.MultiCommandHandler;
import de.rcenvironment.core.command.internal.handlers.BuiltInCommandPlugin;
import de.rcenvironment.core.command.spi.AbstractCommandParameter;
import de.rcenvironment.core.command.spi.CommandFlag;
import de.rcenvironment.core.command.spi.CommandModifierInfo;
import de.rcenvironment.core.command.spi.CommandParser;
import de.rcenvironment.core.command.spi.CommandPlugin;
import de.rcenvironment.core.command.spi.ListCommandParameter;
import de.rcenvironment.core.command.spi.MainCommandDescription;
import de.rcenvironment.core.command.spi.MultiStateParameter;
import de.rcenvironment.core.command.spi.NamedMultiParameter;
import de.rcenvironment.core.command.spi.NamedParameter;
import de.rcenvironment.core.command.spi.NamedSingleParameter;
import de.rcenvironment.core.command.spi.ParsedCommandModifiers;
import de.rcenvironment.core.command.spi.ParsedStringParameter;
import de.rcenvironment.core.command.spi.SubCommandDescription;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.receivers.CapturingTextOutReceiver;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncTaskService;
import java.io.File;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;

public class CommandExecutionServiceImpl
implements CommandExecutionService {
    private static final String INDENT = "\t";
    private static final String NEWLINE_INDENT = "\n\t";
    private static final String PARAMETER_OPEN = "<";
    private static final String PARAMETER_CLOSE = ">";
    private static final String OPTIONAL_OPEN = "[";
    private static final String OPTIONAL_CLOSE = "]";
    private static final String SEPERATOR = " - ";
    private static final String SPACE = " ";
    private static final String VERTICAL_LINE = "|";
    private final AsyncTaskService threadPool;
    private final Set<MainCommandDescription> cmdDesc = new HashSet<MainCommandDescription>();
    private ConfigurationService configurationService;
    private CommandParser parser = new CommandParser();

    public CommandExecutionServiceImpl() {
        this.threadPool = ConcurrencyUtils.getAsyncTaskService();
    }

    public void activate() {
        this.registerCommandPlugin(new BuiltInCommandPlugin());
    }

    public void registerCommandPlugin(CommandPlugin plugin) {
        this.parser.registerCommands(plugin.getCommands());
        this.cmdDesc.addAll(Arrays.asList(plugin.getCommands()));
    }

    public void unregisterCommandPlugin(CommandPlugin plugin) {
        this.cmdDesc.removeAll(Arrays.asList(plugin.getCommands()));
    }

    public void bindConfigurationService(ConfigurationService service) {
        this.configurationService = service;
    }

    @Override
    public Future<CommandExecutionResult> asyncExecMultiCommand(List<String> tokens, TextOutputReceiver outputReceiver, Object initiator) {
        File profileOutput = this.configurationService.getConfigurablePath(ConfigurationService.ConfigurablePathId.PROFILE_OUTPUT);
        MultiCommandHandler multiCommandHandler = new MultiCommandHandler(tokens, outputReceiver, this.parser, profileOutput);
        multiCommandHandler.setInitiatorInformation(initiator);
        return this.threadPool.submit((Callable)multiCommandHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void printHelpText(ParsedCommandModifiers modifiers, TextOutputReceiver outputReceiver) {
        Set<MainCommandDescription> set = this.cmdDesc;
        synchronized (set) {
            ParsedStringParameter command = (ParsedStringParameter)modifiers.getPositionalCommandParameter(0);
            boolean showDevCommands = modifiers.hasCommandFlag("--dev");
            boolean showCommandModifiers = modifiers.hasCommandFlag("--details");
            boolean asciidocFormat = modifiers.hasCommandFlag("--asciidoc");
            if (asciidocFormat) {
                new AsciiDocHelpFormatter(this, outputReceiver).generateCommandDocumentation(this.cmdDesc, showDevCommands);
                return;
            }
            if (command == null) {
                this.printGeneralHelp(showDevCommands, outputReceiver);
            } else {
                this.printSpecificHelp(command, showDevCommands, showCommandModifiers, outputReceiver);
            }
        }
    }

    private void printGeneralHelp(boolean showDevCommands, TextOutputReceiver outputReceiver) {
        if (showDevCommands) {
            outputReceiver.addOutput("RCE Console Dev Commands:");
        } else {
            outputReceiver.addOutput("RCE Console Commands:");
        }
        this.cmdDesc.stream().filter(desc -> this.commandGroupShouldBeShown((MainCommandDescription)desc, showDevCommands)).sorted((desc0, desc1) -> desc0.getCommand().compareTo(desc1.getCommand())).forEach(desc -> outputReceiver.addOutput(INDENT + desc.getCommand() + ": " + desc.getCommandGroupDescription()));
        if (showDevCommands) {
            outputReceiver.addOutput("For detailed information and subcommands type \"dev [command] [--details]\"");
        } else {
            outputReceiver.addOutput("For detailed information and subcommands type \"help [command] [--details]\"");
        }
    }

    private void printSpecificHelp(ParsedStringParameter command, boolean showDevCommands, boolean showCommandModifiers, TextOutputReceiver outputReceiver) {
        MainCommandDescription foundCommand = null;
        for (MainCommandDescription desc : this.cmdDesc) {
            if (!desc.getCommand().equalsIgnoreCase(command.getResult())) continue;
            foundCommand = desc;
            break;
        }
        if (foundCommand == null) {
            outputReceiver.addOutput("Specified command was not found");
        } else {
            this.printMaincommandHelp(foundCommand, showCommandModifiers, outputReceiver);
            SubCommandDescription[] fittigSubCommands = null;
            fittigSubCommands = showDevCommands ? (SubCommandDescription[])Arrays.stream(foundCommand.getSubCommands()).toArray(SubCommandDescription[]::new) : (SubCommandDescription[])Arrays.stream(foundCommand.getSubCommands()).filter(subcommand -> !subcommand.getIsDevelopercommand()).toArray(SubCommandDescription[]::new);
            if (fittigSubCommands.length != 0) {
                outputReceiver.addOutput(String.valueOf(foundCommand.getCommand()) + " subcommands:");
                String commandName = foundCommand.getCommand();
                Arrays.stream(fittigSubCommands).sorted((desc0, desc1) -> desc0.getCommand().compareTo(desc1.getCommand())).forEachOrdered(subCommand -> this.printSubcommandHelp(commandName, (SubCommandDescription)subCommand, showCommandModifiers, outputReceiver));
            }
        }
    }

    private void printMaincommandHelp(MainCommandDescription command, boolean showModifiers, TextOutputReceiver outputReceiver) {
        if (!command.isExecutable()) {
            return;
        }
        StringBuilder lineBuilder = new StringBuilder(command.getCommand());
        CommandModifierInfo modifiers = command.getModifiers();
        lineBuilder.append(this.getSyntaxParameters(modifiers));
        lineBuilder.append(NEWLINE_INDENT).append(command.getDescription());
        if (showModifiers) {
            lineBuilder.append(this.getDetailedDescription(modifiers));
        }
        outputReceiver.addOutput(lineBuilder.toString());
    }

    private void printSubcommandHelp(String mainCommand, SubCommandDescription command, boolean showModifiers, TextOutputReceiver outputReceiver) {
        StringBuilder lineBuilder = new StringBuilder();
        lineBuilder.append(mainCommand).append(SPACE).append(command.getCommand());
        CommandModifierInfo modifiers = command.getModifiers();
        lineBuilder.append(this.getSyntaxParameters(modifiers));
        lineBuilder.append(NEWLINE_INDENT).append(command.getDescription());
        if (showModifiers) {
            lineBuilder.append(this.getDetailedDescription(modifiers));
        }
        outputReceiver.addOutput(lineBuilder.toString());
    }

    private String getSyntaxParameters(CommandModifierInfo modifiers) {
        StringBuilder builder = new StringBuilder();
        modifiers.getPositionals().stream().forEachOrdered(param -> {
            StringBuilder stringBuilder2 = builder.append(SPACE).append(this.getSyntaxOfPositionalParameter((AbstractCommandParameter)param));
        });
        modifiers.getNamedParameters().stream().forEachOrdered(param -> {
            StringBuilder stringBuilder2 = builder.append(SPACE).append(this.getSyntaxOfNamedParameter((NamedParameter)param));
        });
        modifiers.getFlags().stream().forEachOrdered(flag -> {
            StringBuilder stringBuilder2 = builder.append(SPACE).append(this.getSyntaxOfFlag((CommandFlag)flag));
        });
        return builder.toString();
    }

    private String getSyntaxOfPositionalParameter(AbstractCommandParameter parameter) {
        StringBuilder builder = new StringBuilder();
        builder.append(PARAMETER_OPEN).append(parameter.getName());
        if (parameter instanceof MultiStateParameter) {
            MultiStateParameter multi = (MultiStateParameter)parameter;
            StringJoiner joiner = new StringJoiner(VERTICAL_LINE);
            Arrays.stream(multi.getStates()).forEachOrdered(joiner::add);
            builder.append(": ").append(joiner.toString());
        } else if (parameter instanceof ListCommandParameter) {
            builder.append("...");
        }
        builder.append(PARAMETER_CLOSE);
        return builder.toString();
    }

    private String getSyntaxOfNamedParameter(NamedParameter parameter) {
        StringBuilder builder = new StringBuilder();
        builder.append(OPTIONAL_OPEN).append(parameter.getName()).append(SPACE);
        if (parameter instanceof NamedSingleParameter) {
            NamedSingleParameter single = (NamedSingleParameter)parameter;
            builder.append(PARAMETER_OPEN);
            if (single.getParameterType() instanceof MultiStateParameter) {
                MultiStateParameter multi = (MultiStateParameter)single.getParameterType();
                StringJoiner joiner = new StringJoiner(VERTICAL_LINE);
                Arrays.stream(multi.getStates()).forEachOrdered(joiner::add);
                builder.append(joiner.toString());
            } else {
                builder.append(single.getParameterType().getName());
                if (single.getParameterType() instanceof ListCommandParameter) {
                    builder.append("...");
                }
            }
            builder.append(PARAMETER_CLOSE);
        } else if (parameter instanceof NamedMultiParameter) {
            NamedMultiParameter multi = (NamedMultiParameter)parameter;
            builder.append(PARAMETER_OPEN);
            StringJoiner joiner = new StringJoiner("> <");
            int i = 0;
            while (i < multi.getParameterTypes().length) {
                AbstractCommandParameter param = multi.getParameterTypes()[i];
                if (i < multi.getMinParameters()) {
                    joiner.add(param.getName());
                } else {
                    joiner.add("(" + param.getName() + ")");
                }
                ++i;
            }
            builder.append(joiner.toString());
            builder.append(PARAMETER_CLOSE);
        } else {
            return "Should never appear";
        }
        builder.append(OPTIONAL_CLOSE);
        return builder.toString();
    }

    private String getSyntaxOfFlag(CommandFlag flag) {
        StringBuilder builder = new StringBuilder();
        builder.append(OPTIONAL_OPEN).append(flag.getLongFlag());
        if (!flag.getLongFlag().equals(flag.getShortFlag())) {
            builder.append(VERTICAL_LINE).append(flag.getShortFlag());
        }
        builder.append(OPTIONAL_CLOSE);
        return builder.toString();
    }

    private String getDetailedDescription(CommandModifierInfo modifiers) {
        StringBuilder builder = new StringBuilder();
        modifiers.getPositionals().stream().forEachOrdered(param -> {
            StringBuilder stringBuilder2 = builder.append(this.getDetailedPositionalDescription((AbstractCommandParameter)param));
        });
        modifiers.getNamedParameters().stream().forEachOrdered(param -> {
            StringBuilder stringBuilder2 = builder.append(this.getDetailedNamedDescription((NamedParameter)param));
        });
        modifiers.getFlags().stream().forEachOrdered(flag -> {
            StringBuilder stringBuilder2 = builder.append(this.getDetailedFlagDescription((CommandFlag)flag));
        });
        return builder.toString();
    }

    private String getDetailedPositionalDescription(AbstractCommandParameter parameter) {
        StringBuilder builder = new StringBuilder();
        builder.append(NEWLINE_INDENT).append(PARAMETER_OPEN).append(parameter.getName());
        if (parameter instanceof MultiStateParameter) {
            MultiStateParameter multi = (MultiStateParameter)parameter;
            StringJoiner joiner = new StringJoiner(VERTICAL_LINE);
            Arrays.stream(multi.getStates()).forEachOrdered(joiner::add);
            builder.append(": ").append(joiner.toString());
        } else if (parameter instanceof ListCommandParameter) {
            builder.append("...");
        }
        builder.append(PARAMETER_CLOSE).append(SEPERATOR).append(parameter.getDescription());
        return builder.toString();
    }

    private String getDetailedNamedDescription(NamedParameter parameter) {
        StringJoiner joiner;
        NamedSingleParameter single;
        StringBuilder builder = new StringBuilder();
        builder.append(NEWLINE_INDENT).append(OPTIONAL_OPEN).append(parameter.getName()).append(SPACE);
        if (parameter instanceof NamedSingleParameter) {
            single = (NamedSingleParameter)parameter;
            builder.append(PARAMETER_OPEN);
            if (single.getParameterType() instanceof MultiStateParameter) {
                MultiStateParameter multi = (MultiStateParameter)single.getParameterType();
                StringJoiner joiner2 = new StringJoiner(VERTICAL_LINE);
                Arrays.stream(multi.getStates()).forEachOrdered(joiner2::add);
                builder.append(joiner2.toString());
            } else {
                builder.append(single.getParameterType().getName());
                if (single.getParameterType() instanceof ListCommandParameter) {
                    builder.append("...");
                }
            }
            builder.append(PARAMETER_CLOSE);
        } else {
            NamedMultiParameter multi = (NamedMultiParameter)parameter;
            builder.append(PARAMETER_OPEN);
            joiner = new StringJoiner(", ");
            int i = 0;
            while (i < multi.getParameterTypes().length) {
                AbstractCommandParameter param = multi.getParameterTypes()[i];
                if (i < multi.getMinParameters()) {
                    joiner.add(param.getName());
                } else {
                    joiner.add("(" + param.getName() + ")");
                }
                ++i;
            }
            builder.append(joiner.toString());
            builder.append(PARAMETER_CLOSE);
        }
        builder.append(OPTIONAL_CLOSE).append(SEPERATOR).append(parameter.getInfotext());
        if (parameter instanceof NamedSingleParameter && (single = (NamedSingleParameter)parameter).getParameterType() instanceof MultiStateParameter) {
            joiner = new StringJoiner(", ");
            Arrays.stream(((MultiStateParameter)single.getParameterType()).getStates()).forEachOrdered(joiner::add);
            builder.append(" values: ").append(joiner.toString());
        }
        return builder.toString();
    }

    private String getDetailedFlagDescription(CommandFlag flag) {
        StringBuilder builder = new StringBuilder();
        builder.append(NEWLINE_INDENT).append(OPTIONAL_OPEN).append(flag.getLongFlag());
        if (!flag.getShortFlag().equals(flag.getLongFlag())) {
            builder.append(VERTICAL_LINE).append(flag.getShortFlag());
        }
        builder.append(OPTIONAL_CLOSE).append(SEPERATOR).append(flag.getInfotext());
        return builder.toString();
    }

    private boolean commandGroupShouldBeShown(MainCommandDescription mainCommand, boolean showDevCommands) {
        return mainCommand.getIsDevelopercommand() == showDevCommands || Arrays.stream(mainCommand.getSubCommands()).anyMatch(sub -> sub.getIsDevelopercommand() == showDevCommands);
    }

    @Override
    public String getHelpText(boolean addCommonPrefix, boolean showDevCommands) {
        CapturingTextOutReceiver capturingReceiver = new CapturingTextOutReceiver();
        ParsedCommandModifiers modifiers = new ParsedCommandModifiers();
        this.printHelpText(modifiers, (TextOutputReceiver)capturingReceiver);
        return capturingReceiver.getBufferedOutput();
    }

    @Override
    public CommandParser getParser() {
        return this.parser;
    }

    public static class AsciiDocHelpFormatter {
        private static final String TABLE_CELL_START = "|";
        private static final String HARD_LINE_BREAK = " +\n";
        private static final String DESCRIPTION_TO_PARAMETERS_SEPARATOR = " +\n\n";
        private static final String PARAMETER_DECLARATION_PRE = "_";
        private static final String PARAMETER_DECLARATION_POST = "_: ";
        private CommandExecutionServiceImpl service;
        private TextOutputReceiver outputReceiver;

        public AsciiDocHelpFormatter(CommandExecutionServiceImpl commandExecutionService, TextOutputReceiver outputReceiver) {
            this.service = commandExecutionService;
            this.outputReceiver = outputReceiver;
        }

        public void generateCommandDocumentation(Set<MainCommandDescription> mainCommands, boolean showDevCommands) {
            mainCommands.stream().sorted((desc0, desc1) -> desc0.getCommand().compareTo(desc1.getCommand())).filter(desc -> this.service.commandGroupShouldBeShown((MainCommandDescription)desc, showDevCommands)).forEach(desc -> this.renderMainCommandSection((MainCommandDescription)desc, showDevCommands));
        }

        private void renderMainCommandSection(MainCommandDescription mainCommand, boolean showDevCommands) {
            this.outputReceiver.addOutput("*The '" + mainCommand.getCommand() + "' command [[" + mainCommand.getCommand() + "]]*");
            this.printTableHeader();
            if (mainCommand.isExecutable() && mainCommand.getIsDevelopercommand() == showDevCommands) {
                this.outputReceiver.addOutput("|" + this.escapeAsciiDocMarkup(this.mainCommandSyntax(mainCommand)) + "|" + this.escapeAsciiDocMarkup(this.mainCommandDescriptionText(mainCommand)));
            }
            Arrays.stream(mainCommand.getSubCommands()).filter(sub -> sub.getIsDevelopercommand() == showDevCommands).sorted((sub0, sub1) -> sub0.getCommand().compareTo(sub1.getCommand())).forEach(sub -> this.outputReceiver.addOutput("|" + this.escapeAsciiDocMarkup(this.subCommandSyntax((SubCommandDescription)sub, mainCommand)) + "|" + this.escapeAsciiDocMarkup(this.subCommandDescriptionText((SubCommandDescription)sub))));
            this.printTableFooter();
        }

        private String mainCommandSyntax(MainCommandDescription mainCommand) {
            StringBuilder builder = new StringBuilder();
            builder.append(mainCommand.getCommand()).append(this.service.getSyntaxParameters(mainCommand.getModifiers()));
            return builder.toString();
        }

        private String subCommandSyntax(SubCommandDescription command, MainCommandDescription mainCommand) {
            StringBuilder builder = new StringBuilder();
            builder.append(mainCommand.getCommand()).append(CommandExecutionServiceImpl.SPACE).append(command.getCommand()).append(this.service.getSyntaxParameters(command.getModifiers()));
            return builder.toString();
        }

        private String mainCommandDescriptionText(MainCommandDescription mainCommand) {
            StringJoiner joiner = new StringJoiner(CommandExecutionServiceImpl.SPACE);
            joiner.add(this.normalizeCommandDescription(mainCommand.getDescription()));
            if (!mainCommand.getModifiers().isEmpty()) {
                joiner.add(DESCRIPTION_TO_PARAMETERS_SEPARATOR);
            }
            mainCommand.getModifiers().getPositionals().stream().forEachOrdered(this.renderDescriptionOfPositional(joiner));
            mainCommand.getModifiers().getNamedParameters().stream().forEach(this.renderDescriptionOfNamed(joiner));
            mainCommand.getModifiers().getFlags().stream().forEach(this.renderDescriptionOfFlag(joiner));
            return joiner.toString();
        }

        private String subCommandDescriptionText(SubCommandDescription command) {
            StringJoiner joiner = new StringJoiner(CommandExecutionServiceImpl.SPACE);
            joiner.add(this.normalizeCommandDescription(command.getDescription()));
            if (!command.getModifiers().isEmpty()) {
                joiner.add(DESCRIPTION_TO_PARAMETERS_SEPARATOR);
            }
            command.getModifiers().getPositionals().stream().forEachOrdered(this.renderDescriptionOfPositional(joiner));
            command.getModifiers().getNamedParameters().stream().forEach(this.renderDescriptionOfNamed(joiner));
            command.getModifiers().getFlags().stream().forEach(this.renderDescriptionOfFlag(joiner));
            return joiner.toString();
        }

        private String normalizeCommandDescription(String description) {
            if (!description.endsWith(".")) {
                description = String.valueOf(description) + ".";
            }
            return StringUtils.capitalize((String)description);
        }

        private Consumer<? super CommandFlag> renderDescriptionOfFlag(StringJoiner joiner) {
            return flag -> {
                StringJoiner stringJoiner2 = joiner.add(PARAMETER_DECLARATION_PRE + this.service.getSyntaxOfFlag((CommandFlag)flag) + PARAMETER_DECLARATION_POST).add(flag.getInfotext()).add(HARD_LINE_BREAK);
            };
        }

        private Consumer<? super NamedParameter> renderDescriptionOfNamed(StringJoiner joiner) {
            return parameter -> {
                StringJoiner stringJoiner2 = joiner.add(PARAMETER_DECLARATION_PRE + this.service.getSyntaxOfNamedParameter((NamedParameter)parameter) + PARAMETER_DECLARATION_POST).add(parameter.getInfotext()).add(HARD_LINE_BREAK);
            };
        }

        private Consumer<? super AbstractCommandParameter> renderDescriptionOfPositional(StringJoiner joiner) {
            return parameter -> {
                StringJoiner stringJoiner2 = joiner.add(PARAMETER_DECLARATION_PRE + this.service.getSyntaxOfPositionalParameter((AbstractCommandParameter)parameter) + PARAMETER_DECLARATION_POST).add(parameter.getDescription()).add(HARD_LINE_BREAK);
            };
        }

        private void printTableHeader() {
            this.outputReceiver.addOutput("|===");
            this.outputReceiver.addOutput("|Command |Description");
            this.outputReceiver.addOutput("");
        }

        private void printTableFooter() {
            this.outputReceiver.addOutput("|===");
        }

        private String escapeAsciiDocMarkup(String input) {
            return input.replace("|", "\\|").replace("<--", "\\<--");
        }
    }
}

