/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.switchcmp.gui;

import de.rcenvironment.components.switchcmp.gui.SwitchConditionSection;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class CloseOutputsSection
extends ValidatingWorkflowNodePropertySection {
    private Button neverCloseButton;
    private Button closeOnConditionButton;
    private Button closeOnNoMatchButton;
    private Combo conditionCombo;
    private PropertyChangeListener registeredListener;

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        parent.setLayout((Layout)new GridLayout(1, false));
        parent.setLayoutData((Object)new GridData(1808));
        Section parentSection = aTabbedPropertySheetPage.getWidgetFactory().createSection(parent, 256);
        parentSection.setLayout((Layout)new GridLayout());
        parentSection.setLayoutData((Object)new GridData(772));
        parentSection.setText("Close Outputs");
        super.createCompositeContent(parent, aTabbedPropertySheetPage);
        Composite mainComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite(parent);
        mainComposite.setLayout((Layout)new GridLayout(2, false));
        CloseOutputsSelectionListener closeOutListener = new CloseOutputsSelectionListener();
        this.neverCloseButton = new Button(mainComposite, 16);
        this.neverCloseButton.setData("property.control", (Object)"neverCloseOutputs");
        this.neverCloseButton.addSelectionListener((SelectionListener)closeOutListener);
        Label neverCloseOutputLabel = new Label(mainComposite, 0);
        neverCloseOutputLabel.setText("Never close outputs");
        neverCloseOutputLabel.setBackground(mainComposite.getDisplay().getSystemColor(1));
        this.closeOnConditionButton = new Button(mainComposite, 16);
        this.closeOnConditionButton.setData("property.control", (Object)"closeOutputsOnConditionNumber");
        this.closeOnConditionButton.addSelectionListener((SelectionListener)closeOutListener);
        Composite comboComposite = aTabbedPropertySheetPage.getWidgetFactory().createComposite(mainComposite);
        comboComposite.setLayout((Layout)new GridLayout(2, false));
        Label closeOnConditionLabel = new Label(comboComposite, 0);
        closeOnConditionLabel.setText("Close outputs on condition number: ");
        closeOnConditionLabel.setBackground(mainComposite.getDisplay().getSystemColor(1));
        ConditionComboListener condCombListener = new ConditionComboListener();
        this.conditionCombo = new Combo(comboComposite, 8);
        this.conditionCombo.setEnabled(false);
        this.conditionCombo.pack();
        this.conditionCombo.setData("property.control", (Object)"selectedCondition");
        this.conditionCombo.addSelectionListener((SelectionListener)condCombListener);
        this.closeOnNoMatchButton = new Button(mainComposite, 16);
        this.closeOnNoMatchButton.setData("property.control", (Object)"closeOutputsOnNoMatch");
        this.closeOnNoMatchButton.addSelectionListener((SelectionListener)closeOutListener);
        Label closeOnNoMatchLabel = new Label(mainComposite, 0);
        closeOnNoMatchLabel.setText("Close outputs if there is no match.");
        closeOnNoMatchLabel.setBackground(mainComposite.getDisplay().getSystemColor(1));
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        Label noteLabel = new Label(mainComposite, 0);
        noteLabel.setLayoutData((Object)gridData);
        noteLabel.setBackground(Display.getDefault().getSystemColor(1));
        noteLabel.setText("Use 'Never close outputs' if the switch component is used outside of a loop or if it is not supposed to control the loop.\nUse one of the other options if the switch component is supposed to control a loop.\nClosing outputs will close all of the inputs which are connected to the outputs. A component is finished if all of its inputs are closed.");
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        super.setInput(part, selection);
        if (this.registeredListener == null) {
            ComponentInstanceProperties config = this.getConfiguration();
            this.registeredListener = evt -> {
                if (evt.getPropertyName().equals("properties.conditionKey")) {
                    this.refreshCombo();
                    this.refreshButtonActivation();
                }
            };
            config.addPropertyChangeListener(this.registeredListener);
        }
    }

    private void refreshCombo() {
        ComponentInstanceProperties config;
        String conTable;
        int numOfCon;
        this.conditionCombo.removeAll();
        if (this.getProperty("conditionKey") != null && (numOfCon = SwitchConditionSection.getTableContentLength(conTable = (config = this.getConfiguration()).getConfigurationDescription().getConfigurationValue("conditionKey"))) > 0) {
            int i = 1;
            while (i <= numOfCon) {
                this.conditionCombo.add(Integer.toString(i));
                ++i;
            }
        }
    }

    private void refreshButtonActivation() {
        this.conditionCombo.setEnabled(this.closeOnConditionButton.getSelection() && this.conditionCombo.getItems().length != 0);
        String selected = this.getProperty("selectedCondition");
        if (selected != null) {
            this.conditionCombo.select(Integer.parseInt(selected) - 1);
        }
    }

    protected WorkflowNodePropertySection.Controller createController() {
        return new CloseOutputsController();
    }

    protected CloseOutputsUpdater createUpdater() {
        return new CloseOutputsUpdater();
    }

    public void aboutToBeShown() {
        super.aboutToBeShown();
        this.refreshCombo();
        this.refreshButtonActivation();
    }

    protected void beforeTearingDownModelBinding() {
        super.beforeTearingDownModelBinding();
        ComponentInstanceProperties config = this.getConfiguration();
        config.removePropertyChangeListener(this.registeredListener);
        this.registeredListener = null;
    }

    private class CloseOutputsController
    extends WorkflowNodePropertySection.DefaultController {
        private CloseOutputsController() {
            super((WorkflowNodePropertySection)CloseOutputsSection.this);
        }

        public void widgetSelected(SelectionEvent event) {
            Button button;
            if (event.getSource() instanceof Button && (button = (Button)event.getSource()).getSelection()) {
                String key1 = (String)button.getData("property.control");
                Control[] controlArray = button.getParent().getChildren();
                int n = controlArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Control control = controlArray[n2];
                    if (control instanceof Button && !((Button)control).equals(button)) {
                        String key2 = (String)control.getData("property.control");
                        Boolean val = Boolean.valueOf(CloseOutputsSection.this.getConfiguration().getConfigurationDescription().getConfigurationValue(key2));
                        if (Boolean.TRUE.equals(val)) {
                            CloseOutputsSection.this.setProperties(key1, String.valueOf(true), new String[]{key2, String.valueOf(false)});
                        }
                    }
                    ++n2;
                }
                CloseOutputsSection.this.refreshButtonActivation();
            }
        }
    }

    private class CloseOutputsSelectionListener
    implements SelectionListener {
        private CloseOutputsSelectionListener() {
        }

        public void widgetDefaultSelected(SelectionEvent evt) {
            this.widgetSelected(evt);
        }

        public void widgetSelected(SelectionEvent evt) {
            Button button = (Button)evt.getSource();
            if (CloseOutputsSection.this.conditionCombo.getItems().length != 0) {
                CloseOutputsSection.this.conditionCombo.setEnabled(button == CloseOutputsSection.this.closeOnConditionButton);
            }
        }
    }

    protected class CloseOutputsUpdater
    extends WorkflowNodePropertySection.DefaultUpdater {
        protected CloseOutputsUpdater() {
            super((WorkflowNodePropertySection)CloseOutputsSection.this);
        }

        public void updateControl(Control control, String propertyName, String newValue, String oldValue) {
            super.updateControl(control, propertyName, newValue, oldValue);
            if (control instanceof Combo) {
                CloseOutputsSection.this.refreshCombo();
                if (newValue != null) {
                    CloseOutputsSection.this.conditionCombo.select(Integer.parseInt(newValue) - 1);
                }
            }
            if (control instanceof Button && ((Button)control).getData("property.control").equals("closeOutputsOnConditionNumber")) {
                CloseOutputsSection.this.conditionCombo.setEnabled(newValue != null && newValue.equals("true") && CloseOutputsSection.this.getProperty("conditionKey") != null);
            }
        }
    }

    private class ConditionComboListener
    implements SelectionListener {
        private ConditionComboListener() {
        }

        public void widgetDefaultSelected(SelectionEvent evt) {
            this.widgetSelected(evt);
        }

        public void widgetSelected(SelectionEvent evt) {
            String selected = CloseOutputsSection.this.conditionCombo.getItem(CloseOutputsSection.this.conditionCombo.getSelectionIndex());
            CloseOutputsSection.this.setProperty("selectedCondition", selected);
        }
    }
}

