/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.gui.view;

import de.rcenvironment.components.excel.common.ChannelValue;
import de.rcenvironment.components.excel.common.ExcelUtils;
import de.rcenvironment.components.excel.gui.view.Messages;
import de.rcenvironment.core.datamodel.types.api.SmallTableTD;
import de.rcenvironment.core.gui.resources.api.ImageManager;
import de.rcenvironment.core.gui.resources.api.ImageSource;
import de.rcenvironment.core.gui.resources.api.StandardImages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public class DoubleClickDialog
extends Dialog {
    private static final int POINTSIZE_Y = 300;
    private static final int POINTSIZE_X = 400;
    private ChannelValue cval = null;
    private Table table = null;
    private Composite composite = null;

    protected DoubleClickDialog(Shell parentShell, ChannelValue cvalue) {
        super(parentShell);
        this.cval = cvalue;
        this.setShellStyle(this.getShellStyle() | 0x4F0);
    }

    public boolean close() {
        boolean ret = super.close();
        ExcelUtils.destroyGarbage();
        return ret;
    }

    protected Control createDialogArea(Composite parentComposite) {
        this.composite = (Composite)super.createDialogArea(parentComposite);
        GridLayout gridLayout = new GridLayout();
        gridLayout.numColumns = 2;
        gridLayout.horizontalSpacing = 0;
        this.composite.setLayout((Layout)gridLayout);
        GridData gridData = new GridData(16384, 128, false, false, 1, 1);
        Label infos = new Label(this.composite, 0);
        String messagePart = null;
        messagePart = this.cval.isInputValue() ? Messages.inputChannelNameType : Messages.outputChannelNameType;
        infos.setText(String.valueOf(Messages.directionColumnName) + ": " + messagePart + "\n" + Messages.channelColumnName + ": " + this.cval.getChannelName());
        infos.setLayoutData((Object)gridData);
        gridData = new GridData(131072, 128, false, false, 1, 1);
        Label header = new Label(this.composite, 0);
        header.setText(Messages.doubleClickHeader);
        Image image = ImageManager.getInstance().getSharedImage((ImageSource)StandardImages.EXCEL_LARGE);
        header.setImage(image);
        header.setLayoutData((Object)gridData);
        gridData = new GridData(4, 4, true, true, 2, 1);
        this.table = new Table(this.composite, 67584);
        this.table.setLayoutData((Object)gridData);
        this.table.setHeaderVisible(true);
        this.table.setLinesVisible(true);
        final String oldText = this.composite.getShell().getText();
        this.composite.getShell().setText(Messages.loadInBackground);
        Runnable r = new Runnable(){

            @Override
            public void run() {
                DoubleClickDialog.this.fillTableWithContent();
                DoubleClickDialog.this.composite.getShell().setText(oldText);
            }
        };
        super.getParentShell().getDisplay().asyncExec(r);
        this.table.computeSize(300, 400);
        return this.composite;
    }

    protected Point getInitialSize() {
        return new Point(400, 300);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText(Messages.doubleClickShellName);
    }

    private void fillTableWithContent() {
        SmallTableTD vals = this.cval.getValues();
        int loopIndex = 0;
        while (loopIndex < vals.getColumnCount()) {
            TableColumn column = new TableColumn(this.table, 0);
            column.setResizable(true);
            ++loopIndex;
        }
        int row = 0;
        while (row < vals.getRowCount()) {
            TableItem item = new TableItem(this.table, 0);
            int col = 0;
            while (col < vals.getColumnCount()) {
                String valueString = ExcelUtils.smallTableToString((SmallTableTD)vals.getSubTable(row, col, row + 1, col + 1), (String)"; ", (String)"\r\n");
                item.setText(col, valueString);
                ++col;
            }
            ++row;
        }
        loopIndex = 0;
        while (loopIndex < vals.getColumnCount()) {
            this.table.getColumn(loopIndex).pack();
            ++loopIndex;
        }
        ExcelUtils.destroyGarbage();
    }
}

