/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.excel.gui.properties;

import de.rcenvironment.components.excel.gui.properties.Messages;
import de.rcenvironment.core.gui.utils.common.components.PropertyTabGuiHelper;
import de.rcenvironment.core.gui.workflow.editor.properties.ValidatingWorkflowNodePropertySection;
import de.rcenvironment.core.gui.workflow.editor.properties.WorkflowNodePropertySection;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetWidgetFactory;

public class FileSection
extends ValidatingWorkflowNodePropertySection {
    private static final int FILE_TEXTFIELD_WIDTH = 300;
    private Button fileChooser;
    private Composite fileGroup;
    private Text xlsFilename;

    protected void createCompositeContent(Composite parent, TabbedPropertySheetPage aTabbedPropertySheetPage) {
        TabbedPropertySheetWidgetFactory toolkit = aTabbedPropertySheetPage.getWidgetFactory();
        WorkflowNodePropertySection.LayoutComposite content = new WorkflowNodePropertySection.LayoutComposite(parent);
        content.setLayout((Layout)new GridLayout(1, true));
        Composite fileChoosingSection = toolkit.createFlatFormComposite((Composite)content);
        this.initFileChoosingSection(toolkit, fileChoosingSection);
    }

    private void initFileChoosingSection(TabbedPropertySheetWidgetFactory toolkit, Composite container) {
        GridData layoutData = new GridData(770);
        container.setLayoutData((Object)layoutData);
        container.setLayout((Layout)new FillLayout());
        Section section = toolkit.createSection(container, 320);
        section.setText(Messages.fileChoosingSectionName);
        Composite client = toolkit.createComposite((Composite)section);
        layoutData = new GridData(768);
        client.setLayoutData((Object)layoutData);
        client.setLayout((Layout)new GridLayout(1, false));
        toolkit.createCLabel(client, Messages.fileSectionDescription);
        this.fileGroup = toolkit.createComposite(client);
        this.fileGroup.setLayout((Layout)new GridLayout(3, false));
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 768;
        gridData.grabExcessHorizontalSpace = true;
        gridData.widthHint = 300;
        this.fileChooser = toolkit.createButton(this.fileGroup, Messages.fileLinkButtonLabel, 8);
        this.xlsFilename = toolkit.createText(this.fileGroup, "", 12);
        this.xlsFilename.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                if (e.stateMask == 262144 && e.keyCode == 97) {
                    FileSection.this.xlsFilename.selectAll();
                }
            }
        });
        this.xlsFilename.setData("property.control", (Object)"xlFilename");
        this.xlsFilename.setLayoutData((Object)gridData);
        section.setClient((Control)client);
    }

    public static ImageDescriptor getImageDescriptor(String relativePath) {
        ImageDescriptor id = ImageDescriptor.createFromURL((URL)FileSection.class.getClassLoader().getResource("resources/" + relativePath));
        return id;
    }

    private void fileChoosing() {
        IFile file = PropertyTabGuiHelper.selectFileFromActiveProject((Shell)this.fileGroup.getShell(), (String)Messages.loadTitle, (String)Messages.loadMessage);
        if (file != null) {
            this.setProperty("xlFilename", file.getFullPath().makeRelative().toString());
            this.refreshSection();
        }
    }

    protected void refreshBeforeValidation() {
        this.fileGroup.pack(true);
    }

    protected WorkflowNodePropertySection.Controller createController() {
        return new FileController();
    }

    private final class FileController
    extends WorkflowNodePropertySection.DefaultController {
        private FileController() {
            super((WorkflowNodePropertySection)FileSection.this);
        }

        protected void widgetSelected(SelectionEvent event, Control source) {
            super.widgetSelected(event, source);
            if (source == FileSection.this.fileChooser) {
                FileSection.this.fileChoosing();
            }
        }
    }
}

