/*
 * Decompiled with CFR 0.152.
 */
package org.jpedal;

import org.jpedal.objects.PdfPageData;

public final class PageOffsets {
    protected int totalSingleWidth = 0;
    protected int totalDoubleWidth = 0;
    protected int gaps = 0;
    protected int doubleGaps = 0;
    protected int totalSingleHeight = 0;
    protected int totalDoubleHeight = 0;
    protected int maxW = 0;
    protected int maxH = 0;
    protected static final int pageGap = 10;
    protected int doublePageWidth = 0;
    protected int doublePageHeight = 0;
    protected int biggestWidth = 0;
    protected int biggestHeight = 0;
    protected int widestPageNR;
    protected int widestPageR;
    protected boolean hasRotated;
    public static int PAGEFLOW_PAGES = 8;
    public static int PAGEFLOW_EXTRA_CACHE = 10;
    public static double PAGEFLOW_SIDE_SIZE = 0.75;
    public static boolean PAGEFLOW_REFLECTION = true;
    public static double PAGEFLOW_EXTRA_HEIGHT_FOR_REFLECTION = 0.35;
    public static boolean PAGEFLOW_SHADOW = true;
    public static float PAGEFLOW_SHADOW_DARKNESS = 0.5f;
    public static final double PAGEFLOW_WIDTH_RATIO = 0.5;
    public static final double PAGEFLOW_HEIGHT_RATIO = 0.7;
    public static final int SIDE_PAGE_DISPLAY_MIN = 110;
    public static final double SIDE_PAGE_DISPLAY_PROPORTION = 0.5;
    public static final int SIDE_PAGE_DISPLAY_MAX = 200;

    public PageOffsets(int n, PdfPageData pdfPageData) {
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        this.totalSingleHeight = 0;
        this.totalSingleWidth = 0;
        this.hasRotated = false;
        int n6 = 0;
        int n7 = 0;
        int n8 = 0;
        int n9 = 0;
        this.widestPageR = 0;
        this.widestPageNR = 0;
        this.totalDoubleWidth = 0;
        this.totalDoubleHeight = 0;
        this.gaps = 0;
        this.doubleGaps = 0;
        this.biggestWidth = 0;
        this.biggestHeight = 0;
        for (int i = 1; i < n + 1; ++i) {
            int n10 = pdfPageData.getCropBoxWidth(i);
            int n11 = pdfPageData.getCropBoxHeight(i);
            int n12 = pdfPageData.getRotation(i);
            if (n12 == 90 || n12 == 270) {
                int n13 = n10;
                n10 = n11;
                n11 = n13;
            }
            if (n10 > this.maxW) {
                this.maxW = n10;
            }
            if (n11 > this.maxH) {
                this.maxH = n11;
            }
            this.gaps += 10;
            this.totalSingleWidth += n10;
            this.totalSingleHeight += n11;
            if ((i & 1) == 1) {
                if (n7 < n10) {
                    n7 = n10;
                }
                if (n9 < n11) {
                    n9 = n11;
                }
            } else {
                if (n6 < n10) {
                    n6 = n10;
                }
                if (n8 < n11) {
                    n8 = n11;
                }
            }
            if (this.widestPageNR < n10) {
                this.widestPageNR = n10;
            }
            if (this.widestPageR < n11) {
                this.widestPageR = n11;
            }
            if (n10 > this.biggestWidth) {
                this.biggestWidth = n10;
            }
            if (n11 > this.biggestHeight) {
                this.biggestHeight = n11;
            }
            if ((i & 1) == 1) {
                if (n4 < n10) {
                    n4 = n10;
                }
                if (n5 < n11) {
                    n5 = n11;
                }
                if (i == 1) {
                    this.totalDoubleWidth = n10;
                    this.totalDoubleHeight = n11;
                } else {
                    this.totalDoubleWidth += n4;
                    this.totalDoubleHeight += n5;
                }
                this.doubleGaps += 10;
                n2 = n10;
                n3 = n11;
                continue;
            }
            n2 += n10;
            n3 += n11;
            n4 = n10;
            n5 = n11;
            if (i != n) continue;
            this.totalDoubleWidth = this.totalDoubleWidth + n4 + 10;
            this.totalDoubleHeight = this.totalDoubleHeight + n5 + 10;
        }
        this.doublePageWidth = n6 + n7 + 10;
        this.doublePageHeight = n8 + n9 + 10;
        this.totalSingleWidth -= 10;
        this.totalSingleHeight -= 10;
    }

    public static double getPageFlowPageWidth(int n, float f) {
        double d = (double)n * PAGEFLOW_SIDE_SIZE * 0.5;
        double d2 = d * 0.5;
        if (d2 > (double)(f * 200.0f)) {
            d2 = f * 200.0f;
        }
        if (d2 < (double)(f * 110.0f)) {
            d2 = f * 110.0f;
        }
        if (d2 > d) {
            d2 = d;
        }
        return d2;
    }

    public static int getPageFlowExtraHeight(int n) {
        if (PAGEFLOW_REFLECTION) {
            return (int)((double)n * (1.0 + PAGEFLOW_EXTRA_HEIGHT_FOR_REFLECTION));
        }
        return n;
    }

    public int getMaxH() {
        return this.maxH;
    }

    public int getMaxW() {
        return this.maxW;
    }

    public int getWidestPageR() {
        return this.widestPageR;
    }

    public int getWidestPageNR() {
        return this.widestPageNR;
    }
}

