/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.embedded.ssh.internal;

import de.rcenvironment.core.embedded.ssh.api.SshAccount;
import de.rcenvironment.core.eventlog.api.EventLog;
import de.rcenvironment.core.eventlog.api.EventLogEntry;
import de.rcenvironment.core.eventlog.api.EventType;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import java.time.Duration;
import java.time.Instant;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IncomingSessionTracker<T> {
    private final Map<T, SessionStateHolder> stateHoldersBySession = new HashMap<T, SessionStateHolder>();
    private final String connectionTypeLogId;
    private final Log log = LogFactory.getLog(this.getClass());

    public IncomingSessionTracker(String connectionTypeLogId) {
        this.connectionTypeLogId = connectionTypeLogId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionHandle registerSessionStart(T session) {
        SessionStateHolder stateHolder = new SessionStateHolder();
        stateHolder.setConnectionType(this.connectionTypeLogId);
        stateHolder.setConnectionId(this.renderConnectionIdOfSession(session));
        Map<T, SessionStateHolder> map = this.stateHoldersBySession;
        synchronized (map) {
            SessionStateHolder existing = this.stateHoldersBySession.get(session);
            if (existing != null) {
                throw new IllegalStateException("Requested duplicate registration of session object " + this.renderLogDescriptorOfSession(session));
            }
            this.stateHoldersBySession.put(session, stateHolder);
            return stateHolder;
        }
    }

    public SessionHandle forSession(T session) throws OperationFailureException {
        return this.getStateHolder(session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSessionClosed(T session, boolean ignoreDuplicateCalls) {
        SessionStateHolder stateHolder;
        Map<T, SessionStateHolder> map = this.stateHoldersBySession;
        synchronized (map) {
            stateHolder = this.stateHoldersBySession.remove(session);
            if (stateHolder == null) {
                if (ignoreDuplicateCalls) {
                    return;
                }
                throw new IllegalStateException("Requested to close unregistered or already closed session " + this.renderLogDescriptorOfSession(session));
            }
        }
        stateHolder.registerEndOfSession(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int logLeftoverSessions() {
        Map<T, SessionStateHolder> map = this.stateHoldersBySession;
        synchronized (map) {
            for (Map.Entry<T, SessionStateHolder> e : this.stateHoldersBySession.entrySet()) {
                T session = e.getKey();
                SessionStateHolder stateHolder = e.getValue();
                this.log.error((Object)("Unfinished session state after cleanup should have occurred; writing best-effort entry to event log. Session object: " + this.renderLogDescriptorOfSession(session)));
                stateHolder.registerEndOfSession(false);
            }
            int leftoverCount = this.stateHoldersBySession.size();
            this.stateHoldersBySession.clear();
            return leftoverCount;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SessionStateHolder getStateHolder(T session) throws OperationFailureException {
        Map<T, SessionStateHolder> map = this.stateHoldersBySession;
        synchronized (map) {
            SessionStateHolder stateHolder = this.stateHoldersBySession.get(session);
            if (stateHolder == null) {
                throw new OperationFailureException("Unregistered session or session already closed: " + this.renderLogDescriptorOfSession(session));
            }
            return stateHolder;
        }
    }

    private String renderLogDescriptorOfSession(T session) {
        return StringUtils.format((String)"%s [%s]", (Object[])new Object[]{session.toString(), this.renderConnectionIdOfSession(session)});
    }

    private String renderConnectionIdOfSession(T session) {
        return Integer.toString(System.identityHashCode(session));
    }

    public static interface SessionHandle {
        public SessionHandle addLogData(Map<String, String> var1);

        public SessionHandle addLogData(String var1, String var2);

        public SessionHandle addLogData(String var1, int var2);

        public SessionHandle registerAuthenticationSuccess(String var1, String var2, Optional<SshAccount> var3);

        public SessionHandle registerAuthenticationFailure(String var1, String var2, String var3);

        public SessionHandle registerDataStreamEOF();

        public int modifyCustomCounter(int var1);

        public int getAuthenticationFailureCount();
    }

    private static final class SessionStateHolder
    implements SessionHandle {
        private static final Log sharedLog = LogFactory.getLog(SessionStateHolder.class);
        private final Instant startTime = Instant.now();
        private final Map<String, String> commonEventLogData = new HashMap<String, String>();
        private boolean hadIncomingEOF;
        private int authenticationFailureCount;
        private String lastAuthLoginName;
        private String lastAuthMethod;
        private String lastAuthFailureReason;
        private boolean hadAuthenticationSuccess;
        private boolean isHealthCheckAccount;
        private boolean wasRegularlyClosed;
        private String connectionId;
        private int customCounter;

        private SessionStateHolder() {
        }

        public synchronized void setConnectionId(String id) {
            this.connectionId = id;
            this.setCommonEventLogKeyValuePair("connection_id", id);
        }

        public synchronized void setConnectionType(String connectionTypeLogId) {
            this.setCommonEventLogKeyValuePair("type", connectionTypeLogId);
        }

        public synchronized void registerEndOfSession(boolean regularClose) {
            sharedLog.debug((Object)("Closing connection " + this.connectionId));
            this.wasRegularlyClosed = regularClose;
            this.appendFinalEventLogEntry();
        }

        @Override
        public synchronized SessionHandle addLogData(Map<String, String> data) {
            for (Map.Entry<String, String> e : data.entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                this.setCommonEventLogKeyValuePair(key, value);
            }
            return this;
        }

        @Override
        public synchronized SessionHandle addLogData(String key, String value) {
            this.setCommonEventLogKeyValuePair(key, value);
            return this;
        }

        @Override
        public synchronized SessionHandle addLogData(String key, int value) {
            this.setCommonEventLogKeyValuePair(key, Integer.toString(value));
            return this;
        }

        @Override
        public synchronized SessionHandle registerAuthenticationSuccess(String loginName, String method, Optional<SshAccount> optionalAccount) {
            boolean bl = this.isHealthCheckAccount = optionalAccount.isPresent() && "health_check".equals(optionalAccount.get().getRole());
            if (this.hadAuthenticationSuccess) {
                if (this.lastAuthLoginName.equals(loginName) && this.lastAuthMethod.equals(method)) {
                    sharedLog.debug((Object)("Ignoring duplicate successful authentication event with same parameters: user '" + loginName + "', method '" + method + "'"));
                    return this;
                }
                sharedLog.warn((Object)("Received duplicate successful authentication event with different parameters: user '" + loginName + "', method " + method + "; writing second event log entry for visibility"));
            }
            this.hadAuthenticationSuccess = true;
            this.lastAuthLoginName = loginName;
            this.lastAuthMethod = method;
            this.appendEventLogEntryAuthenticationSuccess();
            return this;
        }

        @Override
        public synchronized SessionHandle registerAuthenticationFailure(String loginName, String method, String failureReason) {
            if (this.hadAuthenticationSuccess) {
                throw new IllegalStateException("Attempted to register an authentication failure after authentication success for connection " + this.connectionId);
            }
            this.lastAuthLoginName = loginName;
            this.lastAuthMethod = method;
            this.lastAuthFailureReason = failureReason;
            ++this.authenticationFailureCount;
            this.appendEventLogEntryAuthenticationFailure();
            return this;
        }

        @Override
        public synchronized SessionHandle registerDataStreamEOF() {
            this.hadIncomingEOF = true;
            return this;
        }

        @Override
        public int modifyCustomCounter(int delta) {
            this.customCounter += delta;
            return this.customCounter;
        }

        @Override
        public synchronized int getAuthenticationFailureCount() {
            return this.authenticationFailureCount;
        }

        private void setCommonEventLogKeyValuePair(String key, String value) {
            String replaced = this.commonEventLogData.put(key, value);
            if (replaced != null) {
                if (replaced.equals(value)) {
                    sharedLog.warn((Object)("Repeatedly attached the same log data for connection " + this.connectionId + ", key: " + key + ", value: " + value));
                } else {
                    sharedLog.warn((Object)("Replacing log data for connection " + this.connectionId + ", key: " + key + ", old value: " + replaced + ", new value: " + value));
                }
            }
        }

        private void appendEventLogEntryAuthenticationSuccess() {
            if (this.isHealthCheckAccount) {
                return;
            }
            EventLogEntry logEntry = EventLog.newEntry((EventType)EventType.CONNECTION_INCOMING_ACCEPTED);
            logEntry.setAll(this.commonEventLogData);
            logEntry.set("login_name", this.lastAuthLoginName);
            logEntry.set("auth_method", this.lastAuthMethod);
            if (this.authenticationFailureCount != 0) {
                logEntry.set("auth_failure_count", Integer.toString(this.authenticationFailureCount));
            }
            EventLog.append((EventLogEntry)logEntry);
        }

        private void appendEventLogEntryAuthenticationFailure() {
            EventLogEntry logEntry = EventLog.newEntry((EventType)EventType.CONNECTION_INCOMING_AUTH_FAILED);
            logEntry.setAll(this.commonEventLogData);
            logEntry.set("auth_failure_count", Integer.toString(this.authenticationFailureCount));
            logEntry.set("login_name", this.lastAuthLoginName);
            logEntry.set("auth_method", this.lastAuthMethod);
            logEntry.set("auth_failure_reason", this.lastAuthFailureReason);
            EventLog.append((EventLogEntry)logEntry);
        }

        private void appendFinalEventLogEntry() {
            String closeReason;
            EventType mainEventType;
            boolean hadAuthenticationFailure;
            boolean bl = hadAuthenticationFailure = this.authenticationFailureCount != 0;
            if (!this.wasRegularlyClosed) {
                mainEventType = EventType.CONNECTION_INCOMING_CLOSED;
                closeReason = "fallback";
            } else if (this.hadAuthenticationSuccess) {
                if (this.isHealthCheckAccount) {
                    return;
                }
                mainEventType = EventType.CONNECTION_INCOMING_CLOSED;
                closeReason = this.hadIncomingEOF ? "end of stream" : "regular";
            } else if (hadAuthenticationFailure) {
                mainEventType = EventType.CONNECTION_INCOMING_REFUSED;
                closeReason = "auth failure";
            } else {
                mainEventType = EventType.CONNECTION_INCOMING_REFUSED;
                closeReason = "auth timeout";
            }
            EventLogEntry logEntry = EventLog.newEntry((EventType)mainEventType);
            logEntry.setAll(this.commonEventLogData);
            if (this.hadAuthenticationSuccess) {
                logEntry.set("login_name", this.lastAuthLoginName);
                logEntry.set("auth_method", this.lastAuthMethod);
                if (hadAuthenticationFailure) {
                    logEntry.set("auth_failure_count", Integer.toString(this.authenticationFailureCount));
                }
            } else if (hadAuthenticationFailure) {
                logEntry.set("auth_failure_count", Integer.toString(this.authenticationFailureCount));
                logEntry.set("last_login_name", this.lastAuthLoginName);
                logEntry.set("last_auth_method", this.lastAuthMethod);
                logEntry.set("last_auth_failure_reason", this.lastAuthFailureReason);
            }
            logEntry.set("close_reason", closeReason);
            String durationString = Long.toString(Duration.between(this.startTime, Instant.now()).toMillis());
            logEntry.set("duration", durationString);
            EventLog.append((EventLogEntry)logEntry);
        }
    }
}

