/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.extras.testscriptrunner.definitions.common;

import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.exception.OperationFailureException;
import de.rcenvironment.core.utils.common.textstream.TextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.receivers.NOPTextOutputReceiver;
import de.rcenvironment.core.utils.common.textstream.receivers.PrefixingTextOutForwarder;
import de.rcenvironment.extras.testscriptrunner.definitions.common.ManagedInstance;
import de.rcenvironment.extras.testscriptrunner.definitions.common.TestScenarioExecutionContext;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.time.StopWatch;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class AbstractStepDefinitionBase {
    protected static final int DEFAULT_RETRY_DELAY = 1000;
    private static final boolean FORWARD_IM_OUTPUT_TO_CONSOLE = System.getProperty("rce.bdd.debug") != null;
    @Deprecated
    private static final int BACKWARDS_COMPATIBILITY_MAXIMUM_WAIT_TIME = 15;
    protected final TestScenarioExecutionContext executionContext;
    protected final TextOutputReceiver outputReceiver;
    protected final Log log = LogFactory.getLog(this.getClass());

    public AbstractStepDefinitionBase(TestScenarioExecutionContext executionContext) {
        this.executionContext = executionContext;
        this.outputReceiver = executionContext.getOutputReceiver();
    }

    protected final int executeWithRetry(ExecutionAttempt operation, String operationTitle, int maxAttempts) throws AssertionError {
        return this.executeWithRetry(operation, operationTitle, maxAttempts, 1000);
    }

    protected final int executeWithRetry(ExecutionAttempt operation, String operationTitle, int maxAttempts, int delayMsec) throws AssertionError {
        StopWatch stopWatch = StopWatch.createStarted();
        int attemptCount = 1;
        while (attemptCount <= maxAttempts) {
            try {
                if (operation.attempt(attemptCount, attemptCount == maxAttempts)) {
                    this.printToCommandConsole(StringUtils.format((String)"Operation '%s' succeeded after %d attempt(s) and %d msec (retry limit: %d)", (Object[])new Object[]{operationTitle, attemptCount, stopWatch.getTime(TimeUnit.MILLISECONDS), maxAttempts}));
                    return attemptCount;
                }
                Thread.sleep(delayMsec);
            }
            catch (OperationFailureException | IOException | AssertionError | InterruptedException e) {
                throw new AssertionError(StringUtils.format((String)"Exception during attempt %d for operation '%s' after %d msec (total)", (Object[])new Object[]{attemptCount, operationTitle, stopWatch.getTime(TimeUnit.MILLISECONDS)}), (Throwable)e);
            }
            ++attemptCount;
        }
        throw new AssertionError((Object)StringUtils.format((String)"Exceeded the maximum retry count of %d for operation '%s', aborting after %d msec", (Object[])new Object[]{maxAttempts, operationTitle, stopWatch.getTime(TimeUnit.MILLISECONDS)}));
    }

    protected final OperationFailureException testExecutionError(String message) {
        return new OperationFailureException(message);
    }

    protected final OperationFailureException testExecutionError(String message, Throwable cause) {
        return new OperationFailureException(message, cause);
    }

    protected final AssertionError testAssertionFailure(String message) {
        return new AssertionError((Object)message);
    }

    protected final RuntimeException internalError(String message) {
        return new RuntimeException(message);
    }

    protected final RuntimeException internalError(String message, Throwable cause) {
        return new RuntimeException(message, cause);
    }

    protected final void assertPropertyOfTextOutput(ManagedInstance instance, String negationFlag, String useRegexpMarker, String substring, String output, String outputType) {
        boolean useRegexp;
        boolean expectedPresence = negationFlag == null;
        boolean bl = useRegexp = useRegexpMarker != null;
        if (!useRegexp) {
            useRegexpMarker = "";
        }
        boolean found = useRegexp ? Pattern.compile(substring, 8).matcher(output).find() : output.contains(substring);
        if (expectedPresence && !found) {
            throw this.testAssertionFailure(StringUtils.format((String)"The %s of instance \"%s\" did not contain %s\"%s\";\n  saving the examined output as %s for inspection", (Object[])new Object[]{outputType, instance, useRegexpMarker, substring, this.writeOutputToTempFile(output)}));
        }
        if (!expectedPresence && found) {
            throw this.testAssertionFailure(StringUtils.format((String)"The %s of instance \"%s\" contained %s\"%s\" although it should not;\n  saving the examined output as %s for inspection", (Object[])new Object[]{outputType, instance, useRegexpMarker, substring, this.writeOutputToTempFile(output)}));
        }
        if (expectedPresence) {
            this.printToCommandConsole(StringUtils.format((String)"  The %s of instance \"%s\" contained the expected text \"%s\"", (Object[])new Object[]{outputType, instance, substring}));
        } else {
            this.printToCommandConsole(StringUtils.format((String)"  The %s of instance \"%s\" did not contain text \"%s\" (as expected)", (Object[])new Object[]{outputType, instance, substring}));
        }
    }

    protected List<String> listOfSingleStringElement(String element) {
        ArrayList<String> singleInstanceList = new ArrayList<String>();
        singleInstanceList.add(element);
        return singleInstanceList;
    }

    protected final List<String> parseCommaSeparatedList(String commaSeparatedList) {
        if (commaSeparatedList == null) {
            return new LinkedList<String>();
        }
        return Arrays.asList(commaSeparatedList.trim().split("\\s*,\\s*"));
    }

    protected final void printToCommandConsole(String text) {
        this.outputReceiver.addOutput(text);
    }

    protected final boolean stringContainsOrContainsNot(String string, String substring, boolean shouldContain, boolean useRegex) {
        boolean found = useRegex ? Pattern.compile(substring, 8).matcher(string).find() : string.contains(substring);
        return shouldContain == found;
    }

    protected final String writeOutputToTempFile(String output) {
        try {
            File tempFile = File.createTempFile("bdd_test_failure_data", ".txt");
            FileUtils.write((File)tempFile, (CharSequence)output);
            return tempFile.getAbsolutePath();
        }
        catch (IOException e) {
            throw this.internalError("Unexpected error writing temp file: " + e.toString());
        }
    }

    protected TextOutputReceiver getTextoutReceiverForIMOperations() {
        if (FORWARD_IM_OUTPUT_TO_CONSOLE) {
            return new PrefixingTextOutForwarder("  (IM output) ", this.outputReceiver);
        }
        return new NOPTextOutputReceiver();
    }

    protected int applyFallbackMaximumRetryTime(Integer maxiumWaitSeconds) {
        if (maxiumWaitSeconds != null && maxiumWaitSeconds >= 1) {
            return maxiumWaitSeconds;
        }
        this.printToCommandConsole("TODO: Undefined timeout in test scenario (accepted for transitional period): replacing " + maxiumWaitSeconds + " with " + 15);
        return 15;
    }

    @FunctionalInterface
    protected static interface ExecutionAttempt {
        public boolean attempt(int var1, boolean var2) throws AssertionError, OperationFailureException, IOException;
    }
}

