/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.common.configuration;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.ICellEditorValidator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class SelectionPropertyDescriptor
extends PropertyDescriptor {
    private static final int NO_SUCH_VALUE_INDEX = -1;
    private final ValueProvider valueProvider;
    private List<String> labels;
    private List<Object> values;

    public SelectionPropertyDescriptor(Object id, String displayName, ValueProvider valueProvider) {
        super(id, displayName);
        this.valueProvider = valueProvider;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        this.refresh();
        ComboBoxCellEditor editor = new ComboBoxCellEditor(parent, this.labels.toArray(new String[0]), 8){

            protected void doSetValue(Object value) {
                if (!(value instanceof Integer)) {
                    super.doSetValue((Object)SelectionPropertyDescriptor.this.getIndex(value));
                } else {
                    super.doSetValue(value);
                }
            }
        };
        editor.setValidator(new ICellEditorValidator(){

            public String isValid(Object value) {
                int index;
                List<Object> valuesRef = SelectionPropertyDescriptor.this.getValues();
                if (valuesRef.contains(value)) {
                    return null;
                }
                if (value instanceof Integer && (index = ((Integer)value).intValue()) >= -1 && index < valuesRef.size()) {
                    return null;
                }
                return "invalid value";
            }
        });
        if (this.getValidator() != null) {
            editor.setValidator(this.getValidator());
        }
        return editor;
    }

    private List<String> getLabels() {
        if (this.labels == null) {
            this.refresh();
        }
        return this.labels;
    }

    public String getLabel(Object value) {
        int index = this.getIndex(value);
        if (index < 0) {
            return null;
        }
        return this.getLabels().get(index);
    }

    public Integer getIndex(Object value) {
        int index = this.getValues().indexOf(value);
        if (index < 0) {
            return null;
        }
        return index;
    }

    private List<Object> getValues() {
        if (this.values == null) {
            this.refresh();
        }
        return this.values;
    }

    public Object getValue(Integer index) {
        if (index == -1) {
            return null;
        }
        return this.values.get(index);
    }

    private void refresh() {
        if (this.labels == null || this.values == null) {
            this.labels = new ArrayList<String>();
            this.values = new ArrayList<Object>();
        }
        this.labels.clear();
        this.values.clear();
        Object[] objectArray = this.valueProvider.getValues();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            this.labels.add(this.getLabelProvider().getText(value));
            this.values.add(value);
            ++n2;
        }
    }

    public ILabelProvider getLabelProvider() {
        final ILabelProvider labelProvider = super.getLabelProvider();
        return new LabelProvider(){

            public Image getImage(Object element) {
                return labelProvider.getImage(SelectionPropertyDescriptor.this.lookup(element));
            }

            public String getText(Object element) {
                return labelProvider.getText(SelectionPropertyDescriptor.this.lookup(element));
            }
        };
    }

    private Object lookup(Object element) {
        int index;
        List<Object> valuesRef = this.getValues();
        if (!valuesRef.contains(element) && element instanceof Integer && (index = ((Integer)element).intValue()) >= 0 && index < valuesRef.size()) {
            return valuesRef.get(index);
        }
        return element;
    }

    public static interface ValueProvider {
        public Object[] getValues();
    }
}

