/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.utils.common;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;

public final class EventMessageManager {
    private static final EventMessageManager INSTANCE = new EventMessageManager();
    private final AtomicBoolean guiAvailable = new AtomicBoolean(false);
    private final AtomicBoolean dialogOpen = new AtomicBoolean(false);
    private final Log log = LogFactory.getLog(this.getClass());

    private EventMessageManager() {
    }

    public static EventMessageManager getInstance() {
        return INSTANCE;
    }

    public void submitEventMessageAsync(String message, int swtIconCode, Shell parentShell) {
        boolean previousDialogOpen;
        if (swtIconCode != 1 && swtIconCode != 8 && swtIconCode != 2) {
            throw new IllegalArgumentException("Invalid icon code: " + swtIconCode);
        }
        if (!this.guiAvailable.get()) {
            this.performDialogAlternative(message, "because no GUI is available");
            return;
        }
        if (parentShell.isDisposed()) {
            this.log.warn((Object)"Unexpected state: The GUI is marked as still available, but the parent shell provided for a dialog is disposed");
            this.performDialogAlternative(message, "because the parent Shell is disposed");
        }
        if (previousDialogOpen = this.dialogOpen.getAndSet(true)) {
            this.performDialogAlternative(message, "because another dialog is already open");
            return;
        }
        this.showDialogAndReleaseFlagWhenClosed(message, swtIconCode, parentShell);
    }

    private void showDialogAndReleaseFlagWhenClosed(String message, int swtIconCode, Shell parentShell) {
        parentShell.getDisplay().asyncExec(() -> {
            try {
                MessageBox dialog = new MessageBox(parentShell, swtIconCode | 0x20);
                dialog.setMessage(message);
                dialog.open();
            }
            finally {
                this.dialogOpen.set(false);
            }
        });
    }

    private void performDialogAlternative(String message, String noShowReason) {
        this.log.info((Object)(String.valueOf(message) + " (This message was logged instead of being shown as a dialog " + noShowReason + ".)"));
    }

    public void registerGuiAvailable() {
        this.guiAvailable.set(true);
    }

    public void registerGuiStopping() {
        this.guiAvailable.set(false);
    }
}

