/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.communication.views.contributors;

import com.jcraft.jsch.Session;
import de.rcenvironment.core.communication.sshconnection.SshConnectionContext;
import de.rcenvironment.core.communication.sshconnection.SshConnectionService;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionListener;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionListenerAdapter;
import de.rcenvironment.core.communication.sshconnection.api.SshConnectionSetup;
import de.rcenvironment.core.gui.communication.views.contributors.AddSshConnectionDialog;
import de.rcenvironment.core.gui.communication.views.contributors.ConfigurationSnippetDialog;
import de.rcenvironment.core.gui.communication.views.contributors.EditSshConnectionDialog;
import de.rcenvironment.core.gui.communication.views.contributors.EnterPassphraseDialog;
import de.rcenvironment.core.gui.communication.views.contributors.NetworkViewCallback;
import de.rcenvironment.core.gui.communication.views.contributors.NetworkViewContributorBase;
import de.rcenvironment.core.gui.communication.views.internal.AnchorPoints;
import de.rcenvironment.core.gui.communication.views.model.NetworkGraphNodeWithContext;
import de.rcenvironment.core.gui.communication.views.model.SimpleNetworkViewNode;
import de.rcenvironment.core.gui.communication.views.spi.NetworkViewContributor;
import de.rcenvironment.core.gui.communication.views.spi.SelfRenderingNetworkViewNode;
import de.rcenvironment.core.gui.communication.views.spi.StandardUserNodeActionNode;
import de.rcenvironment.core.gui.communication.views.spi.StandardUserNodeActionType;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryPublisherAccess;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.MessageBox;

public class SshConnectionSetupsListContributor
extends NetworkViewContributorBase {
    private static final AnchorPoints PARENT_ANCHOR = AnchorPoints.SSH_REMOTE_ACCESS_SECTION_PARENT_NODE;
    private static final int ROOT_PRIORITY = 40;
    private SelfRenderingNetworkViewNode rootNode;
    private final Image connectedImage;
    private final Image disconnectedImage;
    private final ServiceRegistryPublisherAccess serviceRegistryAccess;
    private SshConnectionService sshConnectionService;
    private Collection<SshConnectionSetup> sshConnectionSetups;
    private final WeakHashMap<SshConnectionSetup, SshConnectionSetupNode> wrapperMap = new WeakHashMap();
    private NetworkViewCallback callback;

    public SshConnectionSetupsListContributor(NetworkViewCallback callback) {
        this.connectedImage = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/connectSsh.png")).createImage();
        this.disconnectedImage = ImageDescriptor.createFromURL((URL)this.getClass().getResource("/resources/icons/disconnectSsh.png")).createImage();
        this.serviceRegistryAccess = ServiceRegistry.createPublisherAccessFor((Object)this);
        this.sshConnectionService = (SshConnectionService)this.serviceRegistryAccess.getService(SshConnectionService.class);
        this.sshConnectionSetups = this.sshConnectionService.getAllSshConnectionSetups();
        this.registerListeners();
        this.callback = callback;
    }

    @Override
    public int getRootElementsPriority() {
        return 40;
    }

    @Override
    public Object[] getTopLevelElements(Object parentNode) {
        if (parentNode != PARENT_ANCHOR) {
            return null;
        }
        boolean hasChildren = this.sshConnectionSetups != null && !this.sshConnectionSetups.isEmpty();
        this.rootNode = new SimpleNetworkViewNode("SSH Remote Access Connections", this.disconnectedImage, this, hasChildren);
        return new Object[]{this.rootNode};
    }

    @Override
    public int getInstanceDataElementsPriority() {
        return 0;
    }

    public void showAddConnectionDialog() {
        AddSshConnectionDialog dialog = new AddSshConnectionDialog(this.treeViewer.getTree().getShell());
        if (dialog.open() == 0) {
            boolean usePassphrase;
            String connectionName = dialog.getConnectionName();
            boolean connectImmediately = dialog.getConnectImmediately();
            boolean autoRetry = dialog.getAutoRetry();
            String host = dialog.getHost();
            int port = dialog.getPort();
            String username = dialog.getUsername();
            String passphrase = dialog.getPassphrase();
            boolean storePassphrase = dialog.shouldStorePassPhrase();
            String keyfileLocation = dialog.getKeyfileLocation();
            SshConnectionContext contextSsh = new SshConnectionContext(null, connectionName, keyfileLocation, host, port, username, keyfileLocation, usePassphrase = dialog.getUsePassphrase(), connectImmediately, autoRetry, usePassphrase);
            if (this.sshConnectionService.sshConnectionAlreadyExists(contextSsh)) {
                this.display.asyncExec(() -> {
                    MessageBox errorDialog = new MessageBox(this.treeViewer.getTree().getShell(), 33);
                    errorDialog.setMessage(StringUtils.format((String)"SSH connection with host %s and port %d already exists.", (Object[])new Object[]{host, port}));
                    errorDialog.open();
                });
                return;
            }
            ConcurrencyUtils.getAsyncTaskService().execute("Create new SSH Connection.", () -> {
                String id = this.sshConnectionService.addSshConnection(contextSsh);
                this.sshConnectionService.setAuthPhraseForSshConnection(id, passphrase, storePassphrase);
                if (connectImmediately) {
                    this.sshConnectionService.connectSession(id, passphrase);
                }
            });
        }
    }

    @Override
    public Object[] getChildrenForNetworkInstanceNode(NetworkGraphNodeWithContext instanceNode) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public boolean hasChildren(Object parentNode) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public Object[] getChildren(Object node) {
        if (node != this.rootNode) {
            throw this.newUnexpectedCallException();
        }
        if (this.sshConnectionSetups.isEmpty()) {
            return EMPTY_ARRAY;
        }
        Object[] nodes = new SshConnectionSetupNode[this.sshConnectionSetups.size()];
        int pos = 0;
        for (SshConnectionSetup setup : this.sshConnectionSetups) {
            SshConnectionSetupNode setupNode = new SshConnectionSetupNode(setup.getId(), setup);
            nodes[pos++] = setupNode;
        }
        return nodes;
    }

    @Override
    public Object getParent(Object node) {
        if (node == this.rootNode) {
            return PARENT_ANCHOR;
        }
        return this.rootNode;
    }

    @Override
    public String getText(Object node) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public Image getImage(Object node) {
        throw this.newUnexpectedCallException();
    }

    @Override
    public void dispose() {
        this.connectedImage.dispose();
        this.disconnectedImage.dispose();
        this.serviceRegistryAccess.dispose();
    }

    private void registerListeners() {
        SshConnectionListenerAdapter listener = new SshConnectionListenerAdapter(){

            public void onCollectionChanged(Collection<SshConnectionSetup> connections) {
                SshConnectionSetupsListContributor.this.display.asyncExec(() -> {
                    SshConnectionSetupsListContributor.this.sshConnectionSetups = connections;
                    if (SshConnectionSetupsListContributor.this.treeViewer.getControl().isDisposed()) {
                        return;
                    }
                    SshConnectionSetupsListContributor.this.treeViewer.refresh((Object)PARENT_ANCHOR, false);
                    SshConnectionSetupsListContributor.this.treeViewer.setExpandedState((Object)SshConnectionSetupsListContributor.this.rootNode, true);
                });
            }

            public void onConnected(SshConnectionSetup setup) {
                SshConnectionSetupsListContributor.this.display.asyncExec(() -> {
                    if (SshConnectionSetupsListContributor.this.treeViewer.getControl().isDisposed()) {
                        return;
                    }
                    SshConnectionSetupNode node = SshConnectionSetupsListContributor.this.getSetupNodeForSetup(setup);
                    SshConnectionSetupsListContributor.this.treeViewer.refresh((Object)node);
                    SshConnectionSetupsListContributor.this.treeViewer.setExpandedState((Object)node, true);
                    SshConnectionSetupsListContributor.this.callback.onStateChanged(node);
                });
            }

            public void onConnectionAttemptFailed(SshConnectionSetup setup, String reason, boolean firstConsecutiveFailure, boolean willAutoRetry) {
                if (firstConsecutiveFailure) {
                    SshConnectionSetupsListContributor.this.display.asyncExec(() -> {
                        MessageBox dialog = new MessageBox(SshConnectionSetupsListContributor.this.treeViewer.getTree().getShell(), 33);
                        String retryMessage = "\n\nWill not try to reconnect.";
                        if (willAutoRetry) {
                            retryMessage = "\n\nWill automatically try to reconnect.";
                        }
                        dialog.setMessage(StringUtils.format((String)"SSH connection attempt to host %s on port %s failed:\n%s%s", (Object[])new Object[]{setup.getHost(), setup.getPort(), reason, retryMessage}));
                        dialog.open();
                    });
                }
                SshConnectionSetupsListContributor.this.display.asyncExec(() -> {
                    if (SshConnectionSetupsListContributor.this.treeViewer.getControl().isDisposed()) {
                        return;
                    }
                    SshConnectionSetupNode node = SshConnectionSetupsListContributor.this.getSetupNodeForSetup(setup);
                    SshConnectionSetupsListContributor.this.treeViewer.refresh((Object)node);
                    SshConnectionSetupsListContributor.this.callback.onStateChanged(node);
                });
            }

            public void onConnectionClosed(SshConnectionSetup setup, boolean willAutoRetry) {
                SshConnectionSetupsListContributor.this.display.asyncExec(() -> {
                    if (SshConnectionSetupsListContributor.this.treeViewer.getControl().isDisposed()) {
                        return;
                    }
                    SshConnectionSetupNode node = SshConnectionSetupsListContributor.this.getSetupNodeForSetup(setup);
                    SshConnectionSetupsListContributor.this.treeViewer.refresh((Object)node);
                    SshConnectionSetupsListContributor.this.callback.onStateChanged(node);
                });
            }
        };
        this.serviceRegistryAccess.registerService(SshConnectionListener.class, (Object)listener);
    }

    private SshConnectionSetupNode getSetupNodeForSetup(SshConnectionSetup setup) {
        return this.wrapperMap.get(setup);
    }

    private final class SshConnectionSetupNode
    implements SelfRenderingNetworkViewNode,
    StandardUserNodeActionNode {
        private final String connectionId;
        private final SshConnectionSetup sshConnectionSetup;

        SshConnectionSetupNode(String connectionId, SshConnectionSetup setup) {
            this.connectionId = connectionId;
            this.sshConnectionSetup = setup;
            SshConnectionSetupsListContributor.this.wrapperMap.put(setup, this);
        }

        @Override
        public NetworkViewContributor getContributor() {
            return SshConnectionSetupsListContributor.this;
        }

        @Override
        public boolean isActionApplicable(StandardUserNodeActionType actionType) {
            switch (actionType) {
                case START: {
                    return !this.sshConnectionSetup.isConnected();
                }
                case STOP: {
                    return this.sshConnectionSetup.isConnected() || this.sshConnectionSetup.isWaitingForRetry();
                }
                case EDIT: {
                    return !this.sshConnectionSetup.isConnected() && !this.sshConnectionSetup.isWaitingForRetry();
                }
                case DELETE: {
                    return !this.sshConnectionSetup.isConnected() && !this.sshConnectionSetup.isWaitingForRetry();
                }
                case SHOW_CONFIGURATION_SNIPPET: {
                    return true;
                }
            }
            return false;
        }

        @Override
        public void performAction(StandardUserNodeActionType actionType) {
            switch (actionType) {
                case START: {
                    SshConnectionSetupsListContributor.this.display.asyncExec(() -> {
                        if (this.sshConnectionSetup.getUsePassphrase()) {
                            EnterPassphraseDialog dialog;
                            String passphrase = SshConnectionSetupsListContributor.this.sshConnectionService.retrieveSshConnectionPassword(this.connectionId);
                            if ((passphrase == null || passphrase.isEmpty()) && (dialog = new EnterPassphraseDialog(SshConnectionSetupsListContributor.this.treeViewer.getTree().getShell())).open() == 0) {
                                passphrase = dialog.getPassphrase();
                                SshConnectionSetupsListContributor.this.sshConnectionService.setAuthPhraseForSshConnection(this.connectionId, dialog.getPassphrase(), dialog.getStorePassphrase());
                            }
                            String passphraseToConnect = passphrase;
                            ConcurrencyUtils.getAsyncTaskService().execute("Connect SSH session.", () -> {
                                Session session = SshConnectionSetupsListContributor.this.sshConnectionService.connectSession(this.connectionId, passphraseToConnect);
                            });
                        } else {
                            ConcurrencyUtils.getAsyncTaskService().execute("Connect SSH session.", () -> {
                                Session session = SshConnectionSetupsListContributor.this.sshConnectionService.connectSession(this.connectionId);
                            });
                        }
                    });
                    break;
                }
                case STOP: {
                    ConcurrencyUtils.getAsyncTaskService().execute("Disconnect SSH Connection.", () -> SshConnectionSetupsListContributor.this.sshConnectionService.disconnectSession(this.connectionId));
                    break;
                }
                case EDIT: {
                    this.performEdit();
                    break;
                }
                case DELETE: {
                    ConcurrencyUtils.getAsyncTaskService().execute("Dispose SSH Connection.", () -> SshConnectionSetupsListContributor.this.sshConnectionService.disposeConnection(this.connectionId));
                    break;
                }
                case SHOW_CONFIGURATION_SNIPPET: {
                    this.performShowConfigurationSnippet();
                    break;
                }
            }
        }

        private void performEdit() {
            String storedPassphrase = null;
            if (this.sshConnectionSetup.getUsePassphrase()) {
                storedPassphrase = SshConnectionSetupsListContributor.this.sshConnectionService.retrieveSshConnectionPassword(this.sshConnectionSetup.getId());
            }
            EditSshConnectionDialog dialog = new EditSshConnectionDialog(SshConnectionSetupsListContributor.this.treeViewer.getTree().getShell(), this.sshConnectionSetup.getDisplayName(), this.sshConnectionSetup.getHost(), this.sshConnectionSetup.getPort(), this.sshConnectionSetup.getUsername(), this.sshConnectionSetup.getKeyfileLocation(), this.sshConnectionSetup.getUsePassphrase(), storedPassphrase != null, this.sshConnectionSetup.getConnectOnStartUp(), this.sshConnectionSetup.getAutoRetry());
            if (storedPassphrase != null) {
                dialog.setPassphrase(storedPassphrase);
            }
            String id = this.sshConnectionSetup.getId();
            if (dialog.open() == 0) {
                String connectionName = dialog.getConnectionName();
                boolean connectImmediately = dialog.getConnectImmediately();
                String host = dialog.getHost();
                int port = dialog.getPort();
                String username = dialog.getUsername();
                String passphrase = dialog.getPassphrase();
                boolean storePassphrase = dialog.shouldStorePassPhrase();
                String keyfileLocation = dialog.getKeyfileLocation();
                boolean usePassphrase = dialog.getUsePassphrase();
                boolean autoRetry = dialog.getAutoRetry();
                ConcurrencyUtils.getAsyncTaskService().execute("Edit SSH Connection.", () -> {
                    SshConnectionSetupsListContributor.this.sshConnectionService.editSshConnection(new SshConnectionContext(id, connectionName, "", host, port, username, keyfileLocation, usePassphrase, connectImmediately, autoRetry, false));
                    SshConnectionSetupsListContributor.this.sshConnectionService.setAuthPhraseForSshConnection(id, passphrase, storePassphrase);
                    if (connectImmediately) {
                        SshConnectionSetupsListContributor.this.sshConnectionService.connectSession(id, passphrase);
                    }
                });
            }
        }

        private void performShowConfigurationSnippet() {
            SshConnectionSetupsListContributor.this.display.asyncExec(() -> {
                ConfigurationSnippetDialog showConfigurationSnippetDialog = new ConfigurationSnippetDialog(SshConnectionSetupsListContributor.this.treeViewer.getTree().getShell(), "sshRemoteAccess", "sshConnections", "MySSHConnectionID", this.getConfigurationEntries());
                showConfigurationSnippetDialog.open();
            });
        }

        private Map<String, Object> getConfigurationEntries() {
            LinkedHashMap<String, Object> configurationEntries = new LinkedHashMap<String, Object>();
            configurationEntries.put("displayName", this.sshConnectionSetup.getDisplayName());
            configurationEntries.put("host", this.sshConnectionSetup.getHost());
            configurationEntries.put("port", this.sshConnectionSetup.getPort());
            configurationEntries.put("connectOnStartup", this.sshConnectionSetup.getConnectOnStartUp());
            configurationEntries.put("autoRetry", this.sshConnectionSetup.getAutoRetry());
            configurationEntries.put("loginName", this.sshConnectionSetup.getUsername());
            if (this.sshConnectionSetup.getKeyfileLocation() != null) {
                configurationEntries.put("keyfileLocation", this.sshConnectionSetup.getKeyfileLocation());
            }
            if (!this.sshConnectionSetup.getUsePassphrase()) {
                configurationEntries.put("noPassphrase", Boolean.TRUE);
            }
            return configurationEntries;
        }

        @Override
        public String getText() {
            String status = "connected";
            if (!SshConnectionSetupsListContributor.this.sshConnectionService.isConnected(this.connectionId)) {
                status = SshConnectionSetupsListContributor.this.sshConnectionService.isWaitingForRetry(this.connectionId) ? "disconnected, waiting for retry" : "disconnected";
            }
            return StringUtils.format((String)"%s (%s)", (Object[])new Object[]{this.sshConnectionSetup.getDisplayName(), status});
        }

        @Override
        public Image getImage() {
            if (SshConnectionSetupsListContributor.this.sshConnectionService.isConnected(this.connectionId)) {
                return SshConnectionSetupsListContributor.this.connectedImage;
            }
            return SshConnectionSetupsListContributor.this.disconnectedImage;
        }

        @Override
        public boolean getHasChildren() {
            return false;
        }
    }
}

