/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.integration.workflowintegration;

import de.rcenvironment.core.component.integration.IntegrationContext;
import de.rcenvironment.core.component.integration.IntegrationContextType;
import de.rcenvironment.core.component.integration.ToolIntegrationContextRegistry;
import de.rcenvironment.core.gui.integration.common.IntegrationHelper;
import de.rcenvironment.core.gui.integration.workflowintegration.handlers.EditWorkflowIntegrationHandler;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ListViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Shell;

public class EditWorkflowIntegrationDialog
extends TitleAreaDialog {
    private static final int LIST_HEIGHT = 200;
    private static final int LIST_WIDTH = 300;
    private String[] activeIds;
    private String[] inactiveIds;
    private List workflowList;
    private List workflowActivationList;
    private IntegrationHelper integrationHelper = new IntegrationHelper();
    private ToolIntegrationContextRegistry integrationContextRegistry;

    public EditWorkflowIntegrationDialog(Shell parent) {
        super(parent);
        ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)((Object)this));
        this.integrationContextRegistry = (ToolIntegrationContextRegistry)serviceRegistryAccess.getService(ToolIntegrationContextRegistry.class);
        this.readExistingConfigurations();
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText("Edit an integrated Workflow");
    }

    public void create() {
        super.create();
        this.setTitle("Choose Workflow Configuration");
        this.setMessage("Edit an active workflow configuration or activate an inactive one.");
        this.getButton(0).setEnabled(false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        container.setLayout((Layout)new GridLayout(1, true));
        GridData g = new GridData(1808);
        g.grabExcessHorizontalSpace = true;
        container.setLayoutData((Object)g);
        new Label(container, 0).setText("Choose workflow configuration to edit: ");
        ListViewer viewer = new ListViewer(container, 2560);
        viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        viewer.setInput((Object)this.activeIds);
        this.workflowList = viewer.getList();
        GridData workflowListData = new GridData(1808);
        workflowListData.widthHint = 300;
        workflowListData.heightHint = 200;
        this.workflowList.setLayoutData((Object)workflowListData);
        this.workflowList.addSelectionListener((SelectionListener)new EditWorkflowSelectionListener());
        this.workflowList.addMouseListener((MouseListener)new EditWorkflowMouseListener());
        new Label(container, 0).setText("Choose inactive workflow configuration to edit: ");
        ListViewer inactiveComponentsViewer = new ListViewer(container, 2560);
        inactiveComponentsViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        inactiveComponentsViewer.setInput((Object)this.inactiveIds);
        this.workflowActivationList = inactiveComponentsViewer.getList();
        GridData activateListData = new GridData(1808);
        activateListData.widthHint = 300;
        activateListData.heightHint = 200;
        this.workflowActivationList.setLayoutData((Object)activateListData);
        this.workflowActivationList.addSelectionListener((SelectionListener)new EditWorkflowSelectionListener());
        this.workflowActivationList.addMouseListener((MouseListener)new EditWorkflowMouseListener());
        return container;
    }

    protected void okPressed() {
        String workflowName;
        int i;
        if (this.workflowActivationList.isEnabled() && this.workflowActivationList.getSelectionCount() == 1) {
            i = this.workflowActivationList.getSelectionIndex();
            workflowName = this.workflowActivationList.getItem(i);
        } else if (this.workflowList.getSelectionCount() == 1) {
            i = this.workflowList.getSelectionIndex();
            workflowName = this.workflowList.getItem(i);
        } else {
            return;
        }
        EditWorkflowIntegrationHandler handler = new EditWorkflowIntegrationHandler(workflowName);
        try {
            handler.execute(null);
        }
        catch (ExecutionException e) {
            LogFactory.getLog(EditWorkflowIntegrationDialog.class).error((Object)"Opening Edit Workflow failed", (Throwable)e);
        }
        super.okPressed();
    }

    private void readExistingConfigurations() {
        HashSet<String> activeIdSet = new HashSet<String>();
        HashSet<String> inactiveIdSet = new HashSet<String>();
        IntegrationContext context = this.integrationContextRegistry.getToolIntegrationContextByType(IntegrationContextType.WORKFLOW.toString());
        String integrationContextName = context.getNameOfToolIntegrationDirectory();
        String rootPath = context.getRootPathToToolIntegrationDirectory();
        File workflowIntegrationDir = new File(rootPath, integrationContextName);
        if (!workflowIntegrationDir.isDirectory()) {
            return;
        }
        File[] fileArray = workflowIntegrationDir.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            Optional configFile;
            File workflowDir = fileArray[n2];
            if (workflowDir.isDirectory() && (configFile = this.integrationHelper.tryFindConfigurationFile(context, workflowDir)).isPresent()) {
                Map map;
                try {
                    map = (Map)JsonUtils.getDefaultObjectMapper().readValue((File)configFile.get(), HashMap.class);
                }
                catch (IOException e) {
                    throw new RuntimeException(StringUtils.format((String)"Error reading the configuration file \"%s\"", (Object[])new Object[]{((File)configFile.get()).toString()}), e);
                }
                if (map.containsKey("toolName")) {
                    if (map.get("isActive") == null || map.get("isActive").equals(Boolean.TRUE)) {
                        activeIdSet.add((String)map.get("toolName"));
                    } else {
                        inactiveIdSet.add((String)map.get("toolName"));
                    }
                }
            }
            ++n2;
        }
        this.activeIds = activeIdSet.toArray(new String[0]);
        this.inactiveIds = inactiveIdSet.toArray(new String[0]);
        Arrays.sort(this.activeIds, String.CASE_INSENSITIVE_ORDER);
        Arrays.sort(this.inactiveIds, String.CASE_INSENSITIVE_ORDER);
    }

    private class EditWorkflowMouseListener
    implements MouseListener {
        private EditWorkflowMouseListener() {
        }

        public void mouseUp(MouseEvent arg0) {
        }

        public void mouseDown(MouseEvent arg0) {
        }

        public void mouseDoubleClick(MouseEvent arg0) {
            EditWorkflowIntegrationDialog.this.okPressed();
        }
    }

    private class EditWorkflowSelectionListener
    implements SelectionListener {
        private EditWorkflowSelectionListener() {
        }

        public void widgetSelected(SelectionEvent arg0) {
            Object src = arg0.getSource();
            if (src instanceof List) {
                List list = (List)src;
                int index = list.getSelectionIndex();
                EditWorkflowIntegrationDialog.this.workflowList.deselectAll();
                EditWorkflowIntegrationDialog.this.workflowActivationList.deselectAll();
                list.setSelection(index);
                EditWorkflowIntegrationDialog.this.getButton(0).setEnabled(true);
            }
        }

        public void widgetDefaultSelected(SelectionEvent arg0) {
            this.widgetSelected(arg0);
        }
    }
}

