/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.nebula.visualization.xygraph.dataprovider;

import java.util.AbstractCollection;
import java.util.Iterator;
import java.util.NoSuchElementException;

public class CircularBuffer<T>
extends AbstractCollection<T> {
    private int bufferSize = 0;
    private T[] buffer;
    private int head;
    private int tail;
    private int count;

    public CircularBuffer(int bufferSize) {
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("Buffer size must be greater than zero.");
        }
        this.setBufferSize(bufferSize, true);
    }

    @Override
    public synchronized boolean add(T element) {
        if (this.tail == this.head && this.count == this.bufferSize) {
            this.buffer[this.tail] = element;
            this.head = (this.head + 1) % this.bufferSize;
            this.tail = (this.tail + 1) % this.bufferSize;
            return true;
        }
        this.buffer[this.tail] = element;
        this.tail = (this.tail + 1) % this.bufferSize;
        ++this.count;
        return true;
    }

    public synchronized T getElement(int index) {
        if (index < this.count) {
            return this.buffer[(this.head + index) % this.bufferSize];
        }
        return null;
    }

    public synchronized T getHead() {
        if (this.count > 0) {
            return this.buffer[this.head];
        }
        return null;
    }

    public synchronized T getTail() {
        if (this.count > 0) {
            return this.buffer[(this.head + this.count - 1) % this.bufferSize];
        }
        return null;
    }

    @Override
    public synchronized void clear() {
        this.head = 0;
        this.tail = 0;
        this.count = 0;
    }

    public synchronized void setBufferSize(int bufferSize, boolean clear) {
        assert (bufferSize > 0);
        if (this.bufferSize != bufferSize) {
            if (clear) {
                this.buffer = new Object[bufferSize];
                this.clear();
            } else {
                Object[] tempBuffer = this.toArray();
                this.buffer = new Object[bufferSize];
                int i = 0;
                while (i < Math.min(bufferSize, this.count)) {
                    this.buffer[i] = tempBuffer[i];
                    ++i;
                }
                this.count = Math.min(bufferSize, this.count);
                this.head = 0;
                this.tail = this.count % bufferSize;
            }
            this.bufferSize = bufferSize;
        }
    }

    public synchronized int getBufferSize() {
        return this.bufferSize;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < CircularBuffer.this.count;
            }

            @Override
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                return CircularBuffer.this.buffer[(CircularBuffer.this.head + this.index++) % CircularBuffer.this.bufferSize];
            }

            @Override
            public void remove() {
            }
        };
    }

    @Override
    public int size() {
        return this.count;
    }
}

