/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.evaluationmemory.gui;

import de.rcenvironment.core.component.model.endpoint.api.EndpointMetaDataDefinition;
import de.rcenvironment.core.component.workflow.model.spi.ComponentInstanceProperties;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.EndpointActionType;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.gui.utils.incubator.NumericalTextConstraintListener;
import de.rcenvironment.core.gui.workflow.editor.properties.EndpointEditDialog;
import java.util.Map;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class EvaluationMemoryEndpointEditDialog
extends EndpointEditDialog {
    private static final int MAX_TOLERANCE = 100;
    private static final String TOLERANCE_MESSAGE = "Define a value for the tolerance from 0 to 100";
    private Button useToleranceButton;
    private Label toleranceFieldLabel;
    private Text toleranceField;
    private DataType previousDataType = null;
    private Label percentageSignLabel;

    public EvaluationMemoryEndpointEditDialog(Shell parentShell, EndpointActionType actionType, ComponentInstanceProperties configuration, EndpointType direction, String id, boolean isStatic, EndpointMetaDataDefinition metaData, Map<String, String> metadataValues) {
        super(parentShell, actionType, configuration, direction, id, isStatic, metaData, metadataValues);
    }

    protected void createEndpointSettings(Composite parent) {
        super.createEndpointSettings(parent);
        this.comboDataType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                DataType newDataType = EvaluationMemoryEndpointEditDialog.this.getTypeSelectionFromUI();
                EvaluationMemoryEndpointEditDialog.this.updateControlsAndDataType(newDataType);
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
    }

    protected Text createLabelAndTextfield(Composite container, String text, String dataType, String value) {
        this.appendUseToleranceButton(container);
        this.appendToleranceFieldAndLabel(container, text);
        this.previousDataType = this.getTypeSelectionFromUI();
        this.setUseToleranceButtonEnabled(this.dataTypeSupportsTolerance(this.previousDataType));
        if (value.isEmpty()) {
            this.setToleranceFieldEnabled(false);
        } else {
            this.useToleranceButton.setSelection(true);
            this.toleranceField.setText(value);
        }
        return this.toleranceField;
    }

    private boolean useTolerance() {
        return this.useToleranceButton.getSelection();
    }

    private String getToleranceFieldText() {
        return this.toleranceField.getText();
    }

    protected void okPressed() {
        if (this.useTolerance()) {
            this.setToleranceInMetadata(this.getToleranceFieldText());
        } else {
            this.removeToleranceFromMetadata();
        }
        super.okPressed();
    }

    private void setToleranceInMetadata(String tolerance) {
        this.metadataValues.put("tolerance", tolerance);
    }

    private void removeToleranceFromMetadata() {
        this.metadataValues.put("tolerance", "");
    }

    private void appendUseToleranceButton(Composite container) {
        this.useToleranceButton = new Button(container, 32);
        this.useToleranceButton.setText("Use relative tolerance");
        this.useToleranceButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                boolean useTolerance = EvaluationMemoryEndpointEditDialog.this.useToleranceButton.getSelection();
                EvaluationMemoryEndpointEditDialog.this.setToleranceFieldEnabled(useTolerance);
                EvaluationMemoryEndpointEditDialog.this.validateInput();
            }

            public void widgetDefaultSelected(SelectionEvent event) {
                this.widgetSelected(event);
            }
        });
        GridData gridData = new GridData();
        gridData.horizontalSpan = 2;
        gridData.grabExcessHorizontalSpace = true;
        this.useToleranceButton.setLayoutData((Object)gridData);
    }

    private void appendToleranceFieldAndLabel(Composite container, String text) {
        this.toleranceFieldLabel = new Label(container, 0);
        this.toleranceFieldLabel.setText(text);
        this.toleranceFieldLabel.setVisible(true);
        Composite toleranceFieldContainer = new Composite(container, 0);
        toleranceFieldContainer.setLayout((Layout)new GridLayout(2, false));
        toleranceFieldContainer.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toleranceField = new Text(toleranceFieldContainer, 133120);
        this.toleranceField.setLayoutData((Object)new GridData(4, 4, true, false));
        this.toleranceField.setVisible(true);
        this.percentageSignLabel = new Label(toleranceFieldContainer, 0);
        this.percentageSignLabel.setText("%");
        this.percentageSignLabel.setVisible(true);
        this.toleranceField.addVerifyListener((VerifyListener)new NumericalTextConstraintListener(4));
    }

    private boolean dataTypeSupportsTolerance(DataType dataType) {
        boolean previousIsInt = dataType.equals((Object)DataType.Integer);
        boolean previousIsFloat = dataType.equals((Object)DataType.Float);
        return previousIsInt || previousIsFloat;
    }

    private void updateControlsAndDataType(DataType newDataType) {
        boolean previousSupportsTolerance = this.dataTypeSupportsTolerance(this.previousDataType);
        boolean currentSupportsTolerance = this.dataTypeSupportsTolerance(newDataType);
        if (previousSupportsTolerance && !currentSupportsTolerance) {
            this.setUseToleranceButtonEnabled(false);
            this.setToleranceFieldEnabled(false);
        } else if (!previousSupportsTolerance && currentSupportsTolerance) {
            this.setUseToleranceButtonEnabled(true);
            this.setToleranceFieldEnabled(false);
        }
        this.previousDataType = newDataType;
    }

    protected boolean validateMetaDataInputs() {
        if (!this.useTolerance()) {
            return super.validateMetaDataInputs();
        }
        String toleranceValue = this.toleranceField.getText();
        boolean validTolerance = false;
        if (!toleranceValue.isEmpty()) {
            float toleranceValueFloat = Float.parseFloat(toleranceValue);
            boolean bl = validTolerance = toleranceValueFloat <= 100.0f;
        }
        if (!validTolerance) {
            this.updateMessage(TOLERANCE_MESSAGE, true);
        }
        return validTolerance && super.validateMetaDataInputs();
    }

    private void setUseToleranceButtonEnabled(boolean enabled) {
        this.useToleranceButton.setSelection(false);
        this.useToleranceButton.setEnabled(enabled);
    }

    private void setToleranceFieldEnabled(boolean enabled) {
        this.toleranceFieldLabel.setEnabled(enabled);
        this.toleranceField.setEnabled(enabled);
        this.toleranceField.setEditable(enabled);
        this.percentageSignLabel.setEnabled(enabled);
    }
}

