/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.palette.view.palettetreenodes;

import de.rcenvironment.core.gui.palette.view.PaletteView;
import de.rcenvironment.core.gui.palette.view.palettetreenodes.PaletteTreeNode;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditor;
import java.util.Optional;
import org.eclipse.gef.Tool;
import org.eclipse.swt.graphics.Image;

public class CreationToolNode
extends PaletteTreeNode {
    private Tool tool;
    private String contextID;

    public CreationToolNode(PaletteTreeNode parent, String nodeName, Tool tool, Image icon) {
        super(parent, nodeName);
        this.setIcon(icon);
        this.setTool(tool);
    }

    private void setTool(Tool tool) {
        this.tool = tool;
    }

    @Override
    public void handleDoubleclick(PaletteView paletteView) {
        Optional<WorkflowEditor> optional = paletteView.getWorkflowEditor();
        if (!optional.isPresent()) {
            return;
        }
        WorkflowEditor editor = optional.get();
        editor.onPaletteDoubleClick(this.getTool());
    }

    @Override
    public void handleWidgetSelected(WorkflowEditor editor) {
        editor.getViewer().getEditDomain().setActiveTool(this.getTool());
    }

    public Tool getTool() {
        return this.tool;
    }

    @Override
    public void handleEditEvent() {
    }

    @Override
    public boolean canHandleEditEvent() {
        return false;
    }

    @Override
    public boolean isCustomized() {
        return false;
    }

    @Override
    public Optional<String> getHelpContextID() {
        return Optional.ofNullable(this.contextID);
    }

    public void setHelpContextID(String toolContextID) {
        this.contextID = toolContextID;
    }
}

