/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.cluster.torque.internal;

import de.rcenvironment.core.utils.cluster.ClusterJobInformation;
import de.rcenvironment.core.utils.cluster.internal.AbstractClusterService;
import de.rcenvironment.core.utils.cluster.internal.ClusterJobInformationImpl;
import de.rcenvironment.core.utils.cluster.internal.ClusterJobTimesInformation;
import de.rcenvironment.core.utils.ssh.jsch.SshSessionConfiguration;
import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TorqueClusterService
extends AbstractClusterService {
    private static final String LINE_ENDING_REGEXP = "\\r?\\n";
    private static final int INDEX_JOBID = 0;
    private static final int INDEX_USER = 1;
    private static final int INDEX_QUEUE = 2;
    private static final int INDEX_JOBNAME = 3;
    private static final int INDEX_JOBSTATE = 9;
    private static final int INDEX_REMAININGTIME = 4;
    private static final int INDEX_STARTTIME = 5;
    private static final int INDEX_QUEUETIME = 5;
    private static final int SECTION_ACTIVE_JOBS = 0;
    private static final int SECTION_IDLE_JOBS = 1;
    private static final int SECTION_BLOCKED_JOBS = 2;

    public TorqueClusterService(SshSessionConfiguration sshConfiguration, Map<String, String> pathToQueuingSystemCommands) {
        super(sshConfiguration, pathToQueuingSystemCommands);
    }

    @Override
    public Set<ClusterJobInformation> fetchClusterJobInformation() throws IOException {
        this.ensureJschSessionEstablished();
        String stdout = this.executesCommand(this.jschSession, String.valueOf(this.buildMainCommand("qstat")) + " -a", "~");
        Map<String, ClusterJobInformation> jobInformation = this.parseStdoutForClusterJobInformation(stdout);
        this.latestFetchedJobInformation = Collections.unmodifiableMap(jobInformation);
        this.latestFetch = new Date().getTime();
        this.ensureJschSessionEstablished();
        stdout = this.executesCommand(this.jschSession, this.buildMainCommand("showq"), "~");
        Map<String, ClusterJobTimesInformation> jobTimesInformation = this.parseStdoutForClusterJobTimesInformation(stdout);
        return this.enhanceClusterJobInformation(jobInformation, jobTimesInformation);
    }

    @Override
    public String cancelClusterJobs(List<String> jobIds) throws IOException {
        StringBuilder commandBuilder = new StringBuilder(String.valueOf(this.buildMainCommand("qdel")) + " ");
        for (String jobId : jobIds) {
            commandBuilder.append(" ");
            commandBuilder.append(jobId);
        }
        this.ensureJschSessionEstablished();
        try {
            this.executesCommand(this.jschSession, commandBuilder.toString(), "~");
        }
        catch (IllegalArgumentException e) {
            return e.getMessage();
        }
        return "";
    }

    protected Map<String, ClusterJobInformation> parseStdoutForClusterJobInformation(String stdout) {
        String[] lines;
        HashMap<String, ClusterJobInformation> jobInformation = new HashMap<String, ClusterJobInformation>();
        boolean headerCompleted = false;
        boolean isHeader = false;
        String[] stringArray = lines = stdout.split(LINE_ENDING_REGEXP);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            headerCompleted = isHeader;
            String[] lineTokens = line.split("(\\s+)");
            if (headerCompleted) {
                ClusterJobInformation information = this.extractClusterJobInformation(lineTokens);
                jobInformation.put(information.getJobId(), information);
            } else {
                isHeader = true;
                String[] stringArray2 = lineTokens;
                int n3 = lineTokens.length;
                int n4 = 0;
                while (n4 < n3) {
                    String attribute = stringArray2[n4];
                    if (!attribute.matches("(-+)")) {
                        isHeader = false;
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return jobInformation;
    }

    protected Map<String, ClusterJobTimesInformation> parseStdoutForClusterJobTimesInformation(String stdout) {
        String[] lines;
        HashMap<String, ClusterJobTimesInformation> information = new HashMap<String, ClusterJobTimesInformation>();
        int section = 0;
        boolean inSection = false;
        boolean emptyRowPassed = false;
        String[] stringArray = lines = stdout.split(LINE_ENDING_REGEXP);
        int n = lines.length;
        int n2 = 0;
        while (n2 < n) {
            String line = stringArray[n2];
            String[] lineTokens = line.split("(\\s+)");
            if (inSection) {
                if (lineTokens.length <= 1) {
                    if (!emptyRowPassed) {
                        emptyRowPassed = true;
                    } else {
                        emptyRowPassed = false;
                        inSection = false;
                        ++section;
                    }
                } else {
                    ClusterJobTimesInformation timesInformation = this.extractClusterJobTimesInformation(lineTokens, section);
                    information.put(timesInformation.getJobId(), timesInformation);
                }
            } else {
                String[] stringArray2 = lineTokens;
                int n3 = lineTokens.length;
                int n4 = 0;
                while (n4 < n3) {
                    String attribute = stringArray2[n4];
                    if (attribute.matches("JOBNAME")) {
                        inSection = true;
                        break;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return information;
    }

    protected Set<ClusterJobInformation> enhanceClusterJobInformation(Map<String, ClusterJobInformation> jobInformation, Map<String, ClusterJobTimesInformation> jobTimesInformation) {
        jobInformation = this.enhanceClusterJobInformationWithTimesInformation(jobInformation, jobTimesInformation);
        return new HashSet<ClusterJobInformation>(jobInformation.values());
    }

    private Map<String, ClusterJobInformation> enhanceClusterJobInformationWithTimesInformation(Map<String, ClusterJobInformation> jobInformation, Map<String, ClusterJobTimesInformation> jobTimesInformation) {
        for (ClusterJobInformation information : jobInformation.values()) {
            String jobName = information.getJobId().split("\\.")[0];
            if (jobTimesInformation.containsKey(jobName)) {
                ((ClusterJobInformationImpl)information).setClusterJobTimesInformation(jobTimesInformation.get(jobName));
                continue;
            }
            ((ClusterJobInformationImpl)information).setClusterJobTimesInformation(new ClusterJobTimesInformation());
        }
        return jobInformation;
    }

    private ClusterJobTimesInformation extractClusterJobTimesInformation(String[] lineTokens, int section) {
        ClusterJobTimesInformation information = new ClusterJobTimesInformation();
        information.setJobId(lineTokens[0]);
        switch (section) {
            case 0: {
                information.setRemainingTime(lineTokens[4]);
                information.setStartTime(this.getTime(lineTokens, 5));
                break;
            }
            default: {
                information.setQueueTime(this.getTime(lineTokens, 5));
            }
        }
        return information;
    }

    private String getTime(String[] lineTokens, int startIndex) {
        StringBuilder strBuilder = new StringBuilder();
        int i = startIndex;
        while (i < lineTokens.length) {
            strBuilder.append(lineTokens[i]);
            strBuilder.append(" ");
            ++i;
        }
        return strBuilder.delete(strBuilder.length() - 1, strBuilder.length()).toString();
    }

    private ClusterJobInformation extractClusterJobInformation(String[] lineTokens) {
        ClusterJobInformationImpl information = new ClusterJobInformationImpl();
        information.setJobId(lineTokens[0]);
        information.setUser(lineTokens[1]);
        information.setQueue(lineTokens[2]);
        information.setJobName(lineTokens[3]);
        information.setJobState(this.getClusterJobState(lineTokens[9]));
        return information;
    }

    private ClusterJobInformation.ClusterJobState getClusterJobState(String stateToken) {
        ClusterJobInformation.ClusterJobState state = ClusterJobInformation.ClusterJobState.Unknown;
        if (stateToken.equals("C")) {
            state = ClusterJobInformation.ClusterJobState.Completed;
        } else if (stateToken.equals("E")) {
            state = ClusterJobInformation.ClusterJobState.Exiting;
        } else if (stateToken.equals("H")) {
            state = ClusterJobInformation.ClusterJobState.Held;
        } else if (stateToken.equals("Q")) {
            state = ClusterJobInformation.ClusterJobState.Queued;
        } else if (stateToken.equals("R")) {
            state = ClusterJobInformation.ClusterJobState.Running;
        } else if (stateToken.equals("T")) {
            state = ClusterJobInformation.ClusterJobState.Moved;
        } else if (stateToken.equals("W")) {
            state = ClusterJobInformation.ClusterJobState.Waiting;
        } else if (stateToken.equals("S")) {
            state = ClusterJobInformation.ClusterJobState.Suspended;
        }
        return state;
    }
}

