/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.rpc.internal;

import de.rcenvironment.core.communication.api.ReliableRPCStreamHandle;
import de.rcenvironment.core.communication.api.RemotableReliableRPCStreamService;
import de.rcenvironment.core.communication.api.ServiceCallContext;
import de.rcenvironment.core.communication.common.LogicalNodeSessionId;
import de.rcenvironment.core.communication.common.SerializationException;
import de.rcenvironment.core.communication.messaging.internal.InternalMessagingException;
import de.rcenvironment.core.communication.routing.MessageRoutingService;
import de.rcenvironment.core.communication.rpc.ServiceCallRequest;
import de.rcenvironment.core.communication.rpc.ServiceCallResult;
import de.rcenvironment.core.communication.rpc.internal.ReliableRPCStreamHandleImpl;
import de.rcenvironment.core.communication.rpc.internal.ReliableRPCStreamReceiver;
import de.rcenvironment.core.communication.rpc.internal.ReliableRPCStreamSender;
import de.rcenvironment.core.communication.rpc.internal.ReliableRPCStreamService;
import de.rcenvironment.core.communication.rpc.spi.RemoteServiceCallHandlerService;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import de.rcenvironment.core.utils.incubator.DebugSettings;
import de.rcenvironment.toolkit.modules.concurrency.api.threadcontext.ThreadContextHolder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class ReliableRPCStreamServiceImpl
implements RemotableReliableRPCStreamService,
ReliableRPCStreamService {
    private MessageRoutingService routingService;
    private RemoteServiceCallHandlerService serviceCallHandlerService;
    private final AtomicInteger streamIdGenerator = new AtomicInteger(0);
    private final Map<String, ReliableRPCStreamReceiver> streamReceivers = new HashMap<String, ReliableRPCStreamReceiver>();
    private final Map<ReliableRPCStreamHandle, ReliableRPCStreamSender> streamSenders = new HashMap<ReliableRPCStreamHandle, ReliableRPCStreamSender>();
    private final boolean verboseRequestLoggingEnabled = DebugSettings.getVerboseLoggingEnabled((String)"RemoteServiceCalls");
    private final Log log = LogFactory.getLog(this.getClass());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AllowRemoteAccess
    public String createReliableRPCStream() throws RemoteOperationException {
        String streamId = Integer.toString(this.streamIdGenerator.incrementAndGet());
        Map<String, ReliableRPCStreamReceiver> map = this.streamReceivers;
        synchronized (map) {
            ReliableRPCStreamReceiver replaced = this.streamReceivers.put(streamId, new ReliableRPCStreamReceiver(streamId, this.serviceCallHandlerService));
            if (replaced != null) {
                throw new IllegalStateException();
            }
        }
        this.log.debug((Object)("Created rRPC stream " + streamId + " initiated by " + ((ServiceCallContext)ThreadContextHolder.getCurrentContextAspect(ServiceCallContext.class)).getCallingNode()));
        return streamId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @AllowRemoteAccess
    public void disposeReliableRPCStream(String streamId) throws RemoteOperationException {
        Map<String, ReliableRPCStreamReceiver> map = this.streamReceivers;
        synchronized (map) {
            ReliableRPCStreamReceiver removed = this.streamReceivers.remove(streamId);
            if (removed == null) {
                throw new RemoteOperationException("Requested to dispose an rRPC stream that does not exist; streamId = " + streamId);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ReliableRPCStreamHandle createLocalSetupForRemoteStreamId(LogicalNodeSessionId resolvedTargetNodeId, String streamId) {
        ReliableRPCStreamHandleImpl streamHandle = new ReliableRPCStreamHandleImpl(resolvedTargetNodeId, streamId);
        Map<ReliableRPCStreamHandle, ReliableRPCStreamSender> map = this.streamSenders;
        synchronized (map) {
            ReliableRPCStreamSender replaced = this.streamSenders.put(streamHandle, new ReliableRPCStreamSender(streamHandle, this.routingService));
            if (replaced != null) {
                throw new IllegalStateException("There already was a stream sender registered for rRPC stream handle " + streamId);
            }
        }
        return streamHandle;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceCallResult performRequest(ServiceCallRequest serviceCallRequest) throws SerializationException {
        ReliableRPCStreamSender streamSender;
        String streamId = serviceCallRequest.getReliableRPCStreamId();
        Map<ReliableRPCStreamHandle, ReliableRPCStreamSender> map = this.streamSenders;
        synchronized (map) {
            streamSender = this.streamSenders.get(serviceCallRequest.getSenderSideReliableRPCStreamHandle());
            if (streamSender == null) {
                throw new RuntimeException("No active sender for rRPC stream " + streamId + " - it may have been closed before this RPC was initiated");
            }
        }
        return streamSender.performRequest(serviceCallRequest);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ServiceCallResult handleIncomingRequest(ServiceCallRequest serviceCallRequest) throws InternalMessagingException {
        ReliableRPCStreamReceiver streamReceiver;
        String streamId = serviceCallRequest.getReliableRPCStreamId();
        Map<String, ReliableRPCStreamReceiver> map = this.streamReceivers;
        synchronized (map) {
            streamReceiver = this.streamReceivers.get(streamId);
            if (streamReceiver == null) {
                throw new InternalMessagingException("No active receiver for rRPC stream " + streamId + " - it may have been closed before this RPC was received", null);
            }
        }
        return streamReceiver.handle(serviceCallRequest);
    }

    @Reference
    public void bindMessageRoutingService(MessageRoutingService newInstance) {
        this.routingService = newInstance;
    }

    @Reference
    public void bindServiceCallHandlerService(RemoteServiceCallHandlerService newInstance) {
        this.serviceCallHandlerService = newInstance;
    }
}

