/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.protocol;

import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.model.NetworkRequest;
import de.rcenvironment.core.communication.model.impl.NetworkRequestImpl;
import de.rcenvironment.core.communication.protocol.MessageMetaData;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public final class NetworkRequestFactory {
    private NetworkRequestFactory() {
    }

    public static NetworkRequest createNetworkRequest(byte[] contentBytes, String messageType, InstanceNodeSessionId sender, InstanceNodeSessionId finalRecipient) {
        MessageMetaData metaData = MessageMetaData.create();
        metaData.setMessageType(messageType);
        metaData.setSender(sender);
        if (finalRecipient != null) {
            metaData.setFinalRecipient(finalRecipient);
        }
        metaData.addTraceStep(sender.getInstanceNodeSessionIdString());
        return new NetworkRequestImpl(contentBytes, metaData.getInnerMap());
    }

    public static NetworkRequest createNetworkRequestForForwarding(NetworkRequest receivedRequest, InstanceNodeSessionId localNodeId) {
        MessageMetaData newMetadata = MessageMetaData.cloneAndWrap(receivedRequest.accessRawMetaData());
        newMetadata.incHopCount();
        newMetadata.addTraceStep(localNodeId.getInstanceNodeSessionIdString());
        String requestIdToMaintain = receivedRequest.getRequestId();
        return new NetworkRequestImpl(receivedRequest.getContentBytes(), newMetadata.getInnerMap(), requestIdToMaintain);
    }

    public static NetworkRequest reconstructNetworkRequest(byte[] contentBytes, Map<String, String> metaData) {
        return new NetworkRequestImpl(contentBytes, metaData, metaData.get("common.requestId"));
    }

    public static NetworkRequestImpl createDetachedClone(NetworkRequest request) {
        byte[] originalContent = request.getContentBytes();
        byte[] detachedContentBytes = Arrays.copyOf(originalContent, originalContent.length);
        HashMap<String, String> clonedRequestMetaData = new HashMap<String, String>(request.accessRawMetaData());
        NetworkRequestImpl clonedRequest = new NetworkRequestImpl(detachedContentBytes, clonedRequestMetaData, request.getRequestId());
        return clonedRequest;
    }

    public static NetworkRequest cloneWithNewRequestId(NetworkRequest request) {
        HashMap<String, String> newMetaData = new HashMap<String, String>(request.accessRawMetaData());
        return new NetworkRequestImpl(request.getContentBytes(), newMetaData);
    }
}

