/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.configuration.logging;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.FileManager;
import org.apache.logging.log4j.core.appender.OutputStreamManager;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.Property;
import org.apache.logging.log4j.core.config.plugins.Plugin;
import org.apache.logging.log4j.core.config.plugins.PluginAttribute;
import org.apache.logging.log4j.core.config.plugins.PluginElement;
import org.apache.logging.log4j.core.config.plugins.PluginFactory;

@Plugin(name="SelectableLocationFileAppender", elementType="appender", category="Core")
public final class SelectableLocationFileAppender
extends AbstractOutputStreamAppender<FileManager> {
    protected static final String PLUGIN_NAME = "SelectableLocationFileAppender";
    private static final String SYSTEM_PROPERTY_ENABLE_DEBUG_OUTPUT = "rce.debug.logging";
    private static final boolean USE_IO_BUFFERING = true;
    private static final int DEFAULT_IO_BUFFER_SIZE = 256;
    private static final int EARLY_LOG_EVENT_CAPTURE_BUFFER_SIZE = 100;
    private static final CharSequence UNRESOLVED_PROPERTY_MARKER = "${";
    private static final Map<String, SelectableLocationFileAppender> REGISTERED_INSTANCES = new HashMap<String, SelectableLocationFileAppender>();
    private static final Map<String, List<LogEvent>> EARLY_LOG_EVENT_CAPTURE_BUFFERS = new HashMap<String, List<LogEvent>>();
    private static final AtomicInteger sharedInstantiationCounter = new AtomicInteger();
    private static final boolean VERBOSE_DEBUG_OUTPUT = System.getProperty("rce.debug.logging") != null;
    private List<LogEvent> earlyLogEventCaptureList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected SelectableLocationFileAppender(String name, Layout<? extends Serializable> layout, Filter filter, FileManager fileManager, File logFileLocation, boolean ignoreExceptions, boolean immediateFlush, Property[] properties) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, properties, (OutputStreamManager)fileManager);
        Object object = EARLY_LOG_EVENT_CAPTURE_BUFFERS;
        synchronized (object) {
            this.earlyLogEventCaptureList = EARLY_LOG_EVENT_CAPTURE_BUFFERS.get(this.getName());
        }
        if (this.earlyLogEventCaptureList != null) {
            object = this.earlyLogEventCaptureList;
            synchronized (object) {
                for (LogEvent event : this.earlyLogEventCaptureList) {
                    super.append(event);
                    if (!VERBOSE_DEBUG_OUTPUT) continue;
                    System.err.println("LOG SYSTEM DEBUG: Injecting buffered log event into the new " + this.getName() + " appender: " + event.getMessage().getFormat());
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @PluginFactory
    public static SelectableLocationFileAppender createAppender(@PluginAttribute(value="name") String internalLoggerName, @PluginAttribute(value="initialLocation") String initialLocation, @PluginAttribute(value="finalLocation") String finalLocation, @PluginElement(value="Layout") Layout<?> layout, @PluginElement(value="Filter") Filter filter) {
        String advertiseUri = null;
        String filePermissions = null;
        String fileOwner = null;
        String fileGroup = null;
        Configuration configuration = null;
        AbstractMap.SimpleEntry<File, Optional<File>> result = SelectableLocationFileAppender.resolveEffectiveLogFileLocation(initialLocation, finalLocation);
        File effectiveLocation = result.getKey();
        Optional<File> optionalPreviousLocation = result.getValue();
        FileManager fileManager = FileManager.getFileManager((String)effectiveLocation.getPath(), (boolean)false, (boolean)false, (boolean)true, (boolean)false, advertiseUri, layout, (int)256, filePermissions, fileOwner, fileGroup, configuration);
        Map<String, List<LogEvent>> map = EARLY_LOG_EVENT_CAPTURE_BUFFERS;
        synchronized (map) {
            if (EARLY_LOG_EVENT_CAPTURE_BUFFERS.get(internalLoggerName) == null) {
                EARLY_LOG_EVENT_CAPTURE_BUFFERS.put(internalLoggerName, new ArrayList(100));
            }
        }
        SelectableLocationFileAppender newInstance = new SelectableLocationFileAppender(internalLoggerName, layout, filter, fileManager, effectiveLocation, true, false, null);
        fileManager.flush();
        if (optionalPreviousLocation.isPresent()) {
            File previousLocation = optionalPreviousLocation.get();
            if (previousLocation.delete()) {
                if (VERBOSE_DEBUG_OUTPUT) {
                    System.err.println("LOG SYSTEM DEBUG: Deleted initial log file " + previousLocation.toString());
                }
            } else {
                System.err.println("Failed to delete initial log file " + previousLocation.toString());
            }
        }
        Map<String, SelectableLocationFileAppender> map2 = REGISTERED_INSTANCES;
        synchronized (map2) {
            REGISTERED_INSTANCES.put(internalLoggerName, newInstance);
        }
        return newInstance;
    }

    private static AbstractMap.SimpleEntry<File, Optional<File>> resolveEffectiveLogFileLocation(String initialLocation, String finalLocation) {
        File effectiveLocation;
        boolean isFinalLocationResolved;
        boolean isInitialLocationResolved = initialLocation != null && !initialLocation.contains(UNRESOLVED_PROPERTY_MARKER);
        boolean bl = isFinalLocationResolved = finalLocation != null && !finalLocation.contains(UNRESOLVED_PROPERTY_MARKER);
        if (!isInitialLocationResolved && !isFinalLocationResolved) {
            throw new IllegalStateException("Unable to configure log file location: Neither the initial location '" + initialLocation + "' nor the final location '" + finalLocation + "' is a resolved path");
        }
        Optional<Object> optionalPreviousLocation = Optional.empty();
        if (isFinalLocationResolved) {
            effectiveLocation = SelectableLocationFileAppender.toCanonicalFileWithErrorHandling(finalLocation);
            if (isInitialLocationResolved) {
                optionalPreviousLocation = Optional.of(SelectableLocationFileAppender.toCanonicalFileWithErrorHandling(initialLocation));
            }
        } else {
            effectiveLocation = SelectableLocationFileAppender.toCanonicalFileWithErrorHandling(initialLocation);
        }
        if (VERBOSE_DEBUG_OUTPUT) {
            String message = "LOG SYSTEM DEBUG: Initializing custom appender #" + sharedInstantiationCounter.incrementAndGet() + " for log file " + effectiveLocation + " (initial location param: " + initialLocation + " , final location param: " + finalLocation;
            System.err.println(message);
        }
        return new AbstractMap.SimpleEntry<File, Optional<File>>(effectiveLocation, optionalPreviousLocation);
    }

    private static File toCanonicalFileWithErrorHandling(String locationString) {
        try {
            return new File(locationString).getCanonicalFile();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to convert log file location '" + locationString + "' to a canonical path", e);
        }
    }

    public static void configureFinalLogEnvironment(File baseDirectory, String filenamePrefix) {
        if (filenamePrefix == null) {
            filenamePrefix = "";
        }
        LOGGER.debug("Reconfiguring log parameters: new base directory='" + baseDirectory + "', filename prefix='" + filenamePrefix + "'");
        System.setProperty("rce.profilePath", baseDirectory.getAbsolutePath());
        System.setProperty("rce.logFilenamesPrefix", filenamePrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void finalizeLogRelocationForAllAppenders() {
        Map<String, Object> map = REGISTERED_INSTANCES;
        synchronized (map) {
            for (Map.Entry<String, SelectableLocationFileAppender> instance : REGISTERED_INSTANCES.entrySet()) {
                SelectableLocationFileAppender appenderInstance = instance.getValue();
                appenderInstance.finalizeLogRelocation();
            }
        }
        map = EARLY_LOG_EVENT_CAPTURE_BUFFERS;
        synchronized (map) {
            EARLY_LOG_EVENT_CAPTURE_BUFFERS.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void append(LogEvent event) {
        if (event == null) {
            return;
        }
        List<LogEvent> immutableCopyOfEarlyLogEventCaptureList = this.earlyLogEventCaptureList;
        if (immutableCopyOfEarlyLogEventCaptureList != null) {
            List<LogEvent> list = immutableCopyOfEarlyLogEventCaptureList;
            synchronized (list) {
                immutableCopyOfEarlyLogEventCaptureList.add(event);
            }
        }
        if (VERBOSE_DEBUG_OUTPUT) {
            System.err.println("LOG SYSTEM DEBUG: Appending to " + this.getName() + "(" + System.identityHashCode((Object)this) + "/" + System.identityHashCode(((Object)((Object)this)).getClass()) + "): " + event.getMessage().getFormat());
        }
        super.append(event);
    }

    private void finalizeLogRelocation() {
        this.earlyLogEventCaptureList = null;
    }
}

