/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.introduction;

import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

final class WelcomeScreenScriptFile {
    private static final String CHECKBOX_LINE_MARKER = "checkbox.checked = ";
    private static final String CHECKBOX_LINE_IF_UNCHECKED = "\tcheckbox.checked = false;";
    private static final String CHECKBOX_LINE_IF_CHECKED = "\tcheckbox.checked = true;";
    private final Log log = LogFactory.getLog(this.getClass());
    private final String absolutePathToScript;

    private WelcomeScreenScriptFile(String pathToScript) {
        this.absolutePathToScript = pathToScript;
    }

    public static WelcomeScreenScriptFile createFromAbsolutePath(String absolutePathToScript) {
        return new WelcomeScreenScriptFile(absolutePathToScript);
    }

    public void persistUserChoice(boolean checkboxState) {
        String replacementCheckboxLine = this.checkboxLineForCheckboxState(checkboxState);
        Optional<byte[]> fileWithReplacedLine = this.readFileReplaceCheckboxLineAndHandleErrors(replacementCheckboxLine);
        fileWithReplacedLine.ifPresent(content -> this.writeFileWithErrorHandling((byte[])content));
    }

    private Optional<byte[]> readFileReplaceCheckboxLineAndHandleErrors(String replacementCheckboxLine) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (Stream<String> scriptLines = this.getScriptFileLineStream();){
                byte[] newFileContents = this.readFileAndReplaceCheckboxLine(scriptLines, replacementCheckboxLine);
                return Optional.ofNullable(newFileContents);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logReadingExceptionAsError(e);
            return Optional.empty();
        }
    }

    private Stream<String> getScriptFileLineStream() throws IOException {
        Path pathToScriptFile = Paths.get(this.absolutePathToScript, new String[0]);
        return Files.lines(pathToScriptFile);
    }

    private byte[] readFileAndReplaceCheckboxLine(Stream<String> lines, String replacementCheckboxLine) throws IOException {
        return lines.map(line -> this.replaceLineIfCheckboxLine((String)line, replacementCheckboxLine)).collect(Collectors.joining("\n")).getBytes();
    }

    private String replaceLineIfCheckboxLine(String line, String replacementCheckboxLine) {
        if (this.lineIsCheckboxLine(line)) {
            return replacementCheckboxLine;
        }
        return line;
    }

    private boolean lineIsCheckboxLine(String line) {
        return line.contains(CHECKBOX_LINE_MARKER);
    }

    private void writeFileWithErrorHandling(byte[] newFileContents) {
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileOutputStream scriptFileOutputStream = this.buildFileOutputStream();){
                scriptFileOutputStream.write(newFileContents);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            this.logWritingExceptionAsError(e);
        }
    }

    private FileOutputStream buildFileOutputStream() throws FileNotFoundException {
        return new FileOutputStream(this.absolutePathToScript);
    }

    private String checkboxLineForCheckboxState(boolean checkboxState) {
        if (checkboxState) {
            return CHECKBOX_LINE_IF_CHECKED;
        }
        return CHECKBOX_LINE_IF_UNCHECKED;
    }

    private void logReadingExceptionAsError(IOException e) {
        this.log.error((Object)("I/O error occurred while reading " + this.getScriptFilename()), (Throwable)e);
    }

    private void logWritingExceptionAsError(IOException e) {
        this.log.error((Object)("I/O error occurred while writing " + this.getScriptFilename()), (Throwable)e);
    }

    private String getScriptFilename() {
        Path path = Paths.get(this.absolutePathToScript, new String[0]);
        String filename = path.getFileName().toString();
        return filename;
    }
}

