/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.introduction;

import de.rcenvironment.core.gui.introduction.SaveUserInputParameters;
import de.rcenvironment.core.gui.introduction.WelcomeScreenScriptFile;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroSite;
import org.eclipse.ui.intro.config.IIntroAction;
import org.osgi.framework.Bundle;
import org.osgi.service.prefs.BackingStoreException;

public class SaveUserInput
implements IIntroAction {
    private static final String RELATIVE_PATH_TO_SCRIPT = "content/script/intro.js";
    private static final Log LOG = LogFactory.getLog(SaveUserInput.class);

    private static String getPathToScriptFile() {
        Bundle bundle = Platform.getBundle((String)"de.rcenvironment.core.gui.introduction");
        URL scriptFileURL = bundle.getEntry(RELATIVE_PATH_TO_SCRIPT);
        try {
            URL resolvedFileURL = FileLocator.toFileURL((URL)scriptFileURL);
            URI resolvedURI = new URI(resolvedFileURL.getProtocol(), resolvedFileURL.getPath(), null);
            String resolvedPath = new File(resolvedURI).toPath().toAbsolutePath().toString();
            return resolvedPath;
        }
        catch (IOException | URISyntaxException e) {
            LOG.error((Object)"Unable to locate script file 'intro.js'", (Throwable)e);
            return "";
        }
    }

    public void run(IIntroSite site, Properties properties) {
        SaveUserInputParameters parameters = SaveUserInputParameters.createFromProperties(properties);
        this.storeCheckboxValueToPreferences(parameters.isCheckboxChecked());
        this.persistUserPreferenceToScriptFile();
    }

    private void persistUserPreferenceToScriptFile() {
        try {
            boolean preferencesContainShowIntroKey = this.preferencesContainShowIntroKey();
            WelcomeScreenScriptFile scriptFile = WelcomeScreenScriptFile.createFromAbsolutePath(SaveUserInput.getPathToScriptFile());
            scriptFile.persistUserChoice(preferencesContainShowIntroKey);
        }
        catch (BackingStoreException e) {
            this.logExceptionAsError(e);
        }
    }

    private boolean preferencesContainShowIntroKey() throws BackingStoreException {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.ui");
        preferences.flush();
        List<String> prefKeyList = Arrays.asList(preferences.keys());
        return prefKeyList.contains("showIntro");
    }

    private void storeCheckboxValueToPreferences(boolean userHasCheckedCheckbox) {
        PlatformUI.getPreferenceStore().setValue("showIntro", !userHasCheckedCheckbox);
    }

    private void logExceptionAsError(BackingStoreException e) {
        LOG.error((Object)"Preferences operation could not be completed", (Throwable)e);
    }
}

