/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal;

import com.googlecode.lanterna.terminal.swing.TerminalPalette;
import java.awt.Color;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;

public class XTerm8bitIndexedColorUtils {
    private static final Collection<Entry> colorEntries = Collections.unmodifiableList(Arrays.asList(new Entry(0, 0, 0, 0), new Entry(1, 170, 0, 0), new Entry(2, 0, 170, 0), new Entry(3, 170, 85, 0), new Entry(4, 0, 0, 170), new Entry(5, 170, 0, 170), new Entry(6, 0, 170, 170), new Entry(7, 170, 170, 170), new Entry(8, 85, 85, 85), new Entry(9, 255, 85, 85), new Entry(10, 85, 255, 85), new Entry(11, 255, 255, 85), new Entry(12, 85, 85, 255), new Entry(13, 255, 85, 255), new Entry(14, 85, 255, 255), new Entry(15, 255, 255, 255), new Entry(16, 0, 0, 0), new Entry(17, 0, 0, 95), new Entry(18, 0, 0, 135), new Entry(19, 0, 0, 175), new Entry(20, 0, 0, 215), new Entry(21, 0, 0, 255), new Entry(22, 0, 95, 0), new Entry(23, 0, 95, 95), new Entry(24, 0, 95, 135), new Entry(25, 0, 95, 175), new Entry(26, 0, 95, 215), new Entry(27, 0, 95, 255), new Entry(28, 0, 135, 0), new Entry(29, 0, 135, 95), new Entry(30, 0, 135, 135), new Entry(31, 0, 135, 175), new Entry(32, 0, 135, 215), new Entry(33, 0, 135, 255), new Entry(34, 0, 175, 0), new Entry(35, 0, 175, 95), new Entry(36, 0, 175, 135), new Entry(37, 0, 175, 175), new Entry(38, 0, 175, 215), new Entry(39, 0, 175, 255), new Entry(40, 0, 215, 0), new Entry(41, 0, 215, 95), new Entry(42, 0, 215, 135), new Entry(43, 0, 215, 175), new Entry(44, 0, 215, 215), new Entry(45, 0, 215, 255), new Entry(46, 0, 255, 0), new Entry(47, 0, 255, 95), new Entry(48, 0, 255, 135), new Entry(49, 0, 255, 175), new Entry(50, 0, 255, 215), new Entry(51, 0, 255, 255), new Entry(52, 95, 0, 0), new Entry(53, 95, 0, 95), new Entry(54, 95, 0, 135), new Entry(55, 95, 0, 175), new Entry(56, 95, 0, 215), new Entry(57, 95, 0, 255), new Entry(58, 95, 95, 0), new Entry(59, 95, 95, 95), new Entry(60, 95, 95, 135), new Entry(61, 95, 95, 175), new Entry(62, 95, 95, 215), new Entry(63, 95, 95, 255), new Entry(64, 95, 135, 0), new Entry(65, 95, 135, 95), new Entry(66, 95, 135, 135), new Entry(67, 95, 135, 175), new Entry(68, 95, 135, 215), new Entry(69, 95, 135, 255), new Entry(70, 95, 175, 0), new Entry(71, 95, 175, 95), new Entry(72, 95, 175, 135), new Entry(73, 95, 175, 175), new Entry(74, 95, 175, 215), new Entry(75, 95, 175, 255), new Entry(76, 95, 215, 0), new Entry(77, 95, 215, 95), new Entry(78, 95, 215, 135), new Entry(79, 95, 215, 175), new Entry(80, 95, 215, 215), new Entry(81, 95, 215, 255), new Entry(82, 95, 255, 0), new Entry(83, 95, 255, 95), new Entry(84, 95, 255, 135), new Entry(85, 95, 255, 175), new Entry(86, 95, 255, 215), new Entry(87, 95, 255, 255), new Entry(88, 135, 0, 0), new Entry(89, 135, 0, 95), new Entry(90, 135, 0, 135), new Entry(91, 135, 0, 175), new Entry(92, 135, 0, 215), new Entry(93, 135, 0, 255), new Entry(94, 135, 95, 0), new Entry(95, 135, 95, 95), new Entry(96, 135, 95, 135), new Entry(97, 135, 95, 175), new Entry(98, 135, 95, 215), new Entry(99, 135, 95, 255), new Entry(100, 135, 135, 0), new Entry(101, 135, 135, 95), new Entry(102, 135, 135, 135), new Entry(103, 135, 135, 175), new Entry(104, 135, 135, 215), new Entry(105, 135, 135, 255), new Entry(106, 135, 175, 0), new Entry(107, 135, 175, 95), new Entry(108, 135, 175, 135), new Entry(109, 135, 175, 175), new Entry(110, 135, 175, 215), new Entry(111, 135, 175, 255), new Entry(112, 135, 215, 0), new Entry(113, 135, 215, 95), new Entry(114, 135, 215, 135), new Entry(115, 135, 215, 175), new Entry(116, 135, 215, 215), new Entry(117, 135, 215, 255), new Entry(118, 135, 255, 0), new Entry(119, 135, 255, 95), new Entry(120, 135, 255, 135), new Entry(121, 135, 255, 175), new Entry(122, 135, 255, 215), new Entry(123, 135, 255, 255), new Entry(124, 175, 0, 0), new Entry(125, 175, 0, 95), new Entry(126, 175, 0, 135), new Entry(127, 175, 0, 175), new Entry(128, 175, 0, 215), new Entry(129, 175, 0, 255), new Entry(130, 175, 95, 0), new Entry(131, 175, 95, 95), new Entry(132, 175, 95, 135), new Entry(133, 175, 95, 175), new Entry(134, 175, 95, 215), new Entry(135, 175, 95, 255), new Entry(136, 175, 135, 0), new Entry(137, 175, 135, 95), new Entry(138, 175, 135, 135), new Entry(139, 175, 135, 175), new Entry(140, 175, 135, 215), new Entry(141, 175, 135, 255), new Entry(142, 175, 175, 0), new Entry(143, 175, 175, 95), new Entry(144, 175, 175, 135), new Entry(145, 175, 175, 175), new Entry(146, 175, 175, 215), new Entry(147, 175, 175, 255), new Entry(148, 175, 215, 0), new Entry(149, 175, 215, 95), new Entry(150, 175, 215, 135), new Entry(151, 175, 215, 175), new Entry(152, 175, 215, 215), new Entry(153, 175, 215, 255), new Entry(154, 175, 255, 0), new Entry(155, 175, 255, 95), new Entry(156, 175, 255, 135), new Entry(157, 175, 255, 175), new Entry(158, 175, 255, 215), new Entry(159, 175, 255, 255), new Entry(160, 215, 0, 0), new Entry(161, 215, 0, 95), new Entry(162, 215, 0, 135), new Entry(163, 215, 0, 175), new Entry(164, 215, 0, 215), new Entry(165, 215, 0, 255), new Entry(166, 215, 95, 0), new Entry(167, 215, 95, 95), new Entry(168, 215, 95, 135), new Entry(169, 215, 95, 175), new Entry(170, 215, 95, 215), new Entry(171, 215, 95, 255), new Entry(172, 215, 135, 0), new Entry(173, 215, 135, 95), new Entry(174, 215, 135, 135), new Entry(175, 215, 135, 175), new Entry(176, 215, 135, 215), new Entry(177, 215, 135, 255), new Entry(178, 215, 175, 0), new Entry(179, 215, 175, 95), new Entry(180, 215, 175, 135), new Entry(181, 215, 175, 175), new Entry(182, 215, 175, 215), new Entry(183, 215, 175, 255), new Entry(184, 215, 215, 0), new Entry(185, 215, 215, 95), new Entry(186, 215, 215, 135), new Entry(187, 215, 215, 175), new Entry(188, 215, 215, 215), new Entry(189, 215, 215, 255), new Entry(190, 215, 255, 0), new Entry(191, 215, 255, 95), new Entry(192, 215, 255, 135), new Entry(193, 215, 255, 175), new Entry(194, 215, 255, 215), new Entry(195, 215, 255, 255), new Entry(196, 255, 0, 0), new Entry(197, 255, 0, 95), new Entry(198, 255, 0, 135), new Entry(199, 255, 0, 175), new Entry(200, 255, 0, 215), new Entry(201, 255, 0, 255), new Entry(202, 255, 95, 0), new Entry(203, 255, 95, 95), new Entry(204, 255, 95, 135), new Entry(205, 255, 95, 175), new Entry(206, 255, 95, 215), new Entry(207, 255, 95, 255), new Entry(208, 255, 135, 0), new Entry(209, 255, 135, 95), new Entry(210, 255, 135, 135), new Entry(211, 255, 135, 175), new Entry(212, 255, 135, 215), new Entry(213, 255, 135, 255), new Entry(214, 255, 175, 0), new Entry(215, 255, 175, 95), new Entry(216, 255, 175, 135), new Entry(217, 255, 175, 175), new Entry(218, 255, 175, 215), new Entry(219, 255, 175, 255), new Entry(220, 255, 215, 0), new Entry(221, 255, 215, 95), new Entry(222, 255, 215, 135), new Entry(223, 255, 215, 175), new Entry(224, 255, 215, 215), new Entry(225, 255, 215, 255), new Entry(226, 255, 255, 0), new Entry(227, 255, 255, 95), new Entry(228, 255, 255, 135), new Entry(229, 255, 255, 175), new Entry(230, 255, 255, 215), new Entry(231, 255, 255, 255), new Entry(232, 8, 8, 8), new Entry(233, 18, 18, 18), new Entry(234, 28, 28, 28), new Entry(235, 38, 38, 38), new Entry(236, 48, 48, 48), new Entry(237, 58, 58, 58), new Entry(238, 68, 68, 68), new Entry(239, 78, 78, 78), new Entry(240, 88, 88, 88), new Entry(241, 98, 98, 98), new Entry(242, 108, 108, 108), new Entry(243, 118, 118, 118), new Entry(244, 128, 128, 128), new Entry(245, 138, 138, 138), new Entry(246, 148, 148, 148), new Entry(247, 158, 158, 158), new Entry(248, 168, 168, 168), new Entry(249, 178, 178, 178), new Entry(250, 188, 188, 188), new Entry(251, 198, 198, 198), new Entry(252, 208, 208, 208), new Entry(253, 218, 218, 218), new Entry(254, 228, 228, 228), new Entry(255, 238, 238, 238)));

    private XTerm8bitIndexedColorUtils() {
    }

    public static int getClosestColor(int red, int green, int blue) {
        if (red < 0 || red > 255) {
            throw new IllegalArgumentException("getClosestColor: red is outside of valid range (0-255)");
        }
        if (green < 0 || green > 255) {
            throw new IllegalArgumentException("getClosestColor: green is outside of valid range (0-255)");
        }
        if (blue < 0 || blue > 255) {
            throw new IllegalArgumentException("getClosestColor: blue is outside of valid range (0-255)");
        }
        double closestMatch = Double.MAX_VALUE;
        int closestIndex = 0;
        for (Entry entry : colorEntries) {
            double distance = entry.distanceTo(red, green, blue);
            if (!(distance < closestMatch)) continue;
            closestIndex = entry.index;
            closestMatch = distance;
        }
        return closestIndex;
    }

    public static Color getAWTColor(int index) {
        return XTerm8bitIndexedColorUtils.getAWTColor(index, null);
    }

    public static Color getAWTColor(int index, TerminalPalette terminalPalette) {
        if (index < 0 || index > 255) {
            throw new IllegalArgumentException("getClosestColor: red is outside of valid range (0-255)");
        }
        if (terminalPalette != null && index < 16) {
            switch (index) {
                case 0: {
                    return terminalPalette.getNormalBlack();
                }
                case 1: {
                    return terminalPalette.getNormalRed();
                }
                case 2: {
                    return terminalPalette.getNormalGreen();
                }
                case 3: {
                    return terminalPalette.getNormalYellow();
                }
                case 4: {
                    return terminalPalette.getNormalBlue();
                }
                case 5: {
                    return terminalPalette.getNormalMagenta();
                }
                case 6: {
                    return terminalPalette.getNormalCyan();
                }
                case 7: {
                    return terminalPalette.getNormalWhite();
                }
                case 8: {
                    return terminalPalette.getBrightBlack();
                }
                case 9: {
                    return terminalPalette.getBrightRed();
                }
                case 10: {
                    return terminalPalette.getBrightGreen();
                }
                case 11: {
                    return terminalPalette.getBrightYellow();
                }
                case 12: {
                    return terminalPalette.getBrightBlue();
                }
                case 13: {
                    return terminalPalette.getBrightMagenta();
                }
                case 14: {
                    return terminalPalette.getBrightCyan();
                }
                case 15: {
                    return terminalPalette.getBrightWhite();
                }
            }
        }
        for (Entry entry : colorEntries) {
            if (entry.index != index) continue;
            return new Color(entry.red, entry.green, entry.blue);
        }
        throw new IllegalArgumentException("getClosestColor: couldn't find color for index " + index);
    }

    private static class Entry {
        int index;
        int red;
        int green;
        int blue;

        Entry(int index, int red, int green, int blue) {
            this.index = index;
            this.red = red;
            this.green = green;
            this.blue = blue;
        }

        double distanceTo(int red, int green, int blue) {
            return Math.pow(this.red - red, 2.0) + Math.pow(this.green - green, 2.0) + Math.pow(this.blue - blue, 2.0);
        }
    }
}

