/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal;

import com.googlecode.lanterna.terminal.Terminal;
import com.googlecode.lanterna.terminal.TerminalSize;
import java.util.ArrayList;
import java.util.List;

public abstract class AbstractTerminal
implements Terminal {
    private final List<Terminal.ResizeListener> resizeListeners = new ArrayList<Terminal.ResizeListener>();
    private TerminalSize lastKnownSize = null;

    @Override
    public void addResizeListener(Terminal.ResizeListener listener) {
        if (listener != null) {
            this.resizeListeners.add(listener);
        }
    }

    @Override
    public void removeResizeListener(Terminal.ResizeListener listener) {
        if (listener != null) {
            this.resizeListeners.remove(listener);
        }
    }

    protected synchronized void onResized(int columns, int rows) {
        TerminalSize newSize = new TerminalSize(columns, rows);
        if (this.lastKnownSize == null || !this.lastKnownSize.equals(newSize)) {
            this.lastKnownSize = newSize;
            for (Terminal.ResizeListener resizeListener : this.resizeListeners) {
                resizeListener.onResized(this.lastKnownSize);
            }
        }
    }

    protected TerminalSize getLastKnownSize() {
        return this.lastKnownSize;
    }
}

