/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui;

import com.googlecode.lanterna.gui.TextGraphics;
import com.googlecode.lanterna.gui.Theme;
import com.googlecode.lanterna.screen.Screen;
import com.googlecode.lanterna.screen.ScreenCharacterStyle;
import com.googlecode.lanterna.screen.TabBehaviour;
import com.googlecode.lanterna.terminal.Terminal;
import com.googlecode.lanterna.terminal.TerminalPosition;
import com.googlecode.lanterna.terminal.TerminalSize;
import java.util.Arrays;
import java.util.EnumSet;

class TextGraphicsImpl
implements TextGraphics {
    private final TerminalPosition topLeft;
    private final TerminalSize areaSize;
    private final Screen screen;
    private Theme theme;
    private Terminal.Color foregroundColor;
    private Terminal.Color backgroundColor;
    private boolean currentlyBold;

    TextGraphicsImpl(TerminalPosition topLeft, TerminalSize areaSize, Screen screen, Theme theme) {
        this.topLeft = topLeft;
        this.areaSize = areaSize;
        this.screen = screen;
        this.theme = theme;
        this.currentlyBold = false;
        this.foregroundColor = Terminal.Color.DEFAULT;
        this.backgroundColor = Terminal.Color.DEFAULT;
    }

    private TextGraphicsImpl(TextGraphicsImpl graphics, TerminalPosition topLeft, TerminalSize areaSize) {
        this(new TerminalPosition(topLeft.getColumn() + graphics.topLeft.getColumn(), topLeft.getRow() + graphics.topLeft.getRow()), new TerminalSize(areaSize.getColumns() < graphics.getWidth() - topLeft.getColumn() ? areaSize.getColumns() : graphics.getWidth() - topLeft.getColumn(), areaSize.getRows() < graphics.getHeight() - topLeft.getRow() ? areaSize.getRows() : graphics.getHeight() - topLeft.getRow()), graphics.screen, graphics.theme);
        this.foregroundColor = graphics.foregroundColor;
        this.backgroundColor = graphics.backgroundColor;
        this.currentlyBold = graphics.currentlyBold;
    }

    @Override
    public TextGraphics subAreaGraphics(TerminalPosition terminalPosition) {
        terminalPosition.ensurePositivePosition();
        TerminalSize newArea = new TerminalSize(this.areaSize);
        newArea.setColumns(newArea.getColumns() - terminalPosition.getColumn());
        newArea.setRows(newArea.getRows() - terminalPosition.getRow());
        return this.subAreaGraphics(terminalPosition, newArea);
    }

    @Override
    public TextGraphics subAreaGraphics(TerminalPosition topLeft, TerminalSize subAreaSize) {
        if (topLeft.getColumn() < 0) {
            topLeft.setColumn(0);
        }
        if (topLeft.getRow() < 0) {
            topLeft.setRow(0);
        }
        if (subAreaSize.getColumns() < 0) {
            subAreaSize.setColumns(-subAreaSize.getColumns());
        }
        if (subAreaSize.getRows() < 0) {
            subAreaSize.setRows(-subAreaSize.getRows());
        }
        if (topLeft.getColumn() >= this.areaSize.getColumns() || topLeft.getRow() >= this.areaSize.getRows()) {
            return new NullTextGraphics();
        }
        if (topLeft.getColumn() + subAreaSize.getColumns() > this.areaSize.getColumns()) {
            subAreaSize.setColumns(this.areaSize.getColumns() - topLeft.getColumn());
        }
        if (topLeft.getRow() + subAreaSize.getRows() > this.areaSize.getRows()) {
            subAreaSize.setRows(this.areaSize.getRows() - topLeft.getRow());
        }
        return new TextGraphicsImpl(this, topLeft, subAreaSize);
    }

    @Override
    public void drawString(int column, int row, String string, ScreenCharacterStyle ... styles) {
        if (column >= this.areaSize.getColumns() || row >= this.areaSize.getRows() || string == null) {
            return;
        }
        if ((string = TabBehaviour.ALIGN_TO_COLUMN_4.replaceTabs(string, column + this.topLeft.getColumn())).length() + column > this.areaSize.getColumns()) {
            string = string.substring(0, this.areaSize.getColumns() - column);
        }
        EnumSet<ScreenCharacterStyle> stylesSet = EnumSet.noneOf(ScreenCharacterStyle.class);
        if (styles != null && styles.length != 0) {
            stylesSet = EnumSet.copyOf(Arrays.asList(styles));
        }
        if (this.currentlyBold) {
            stylesSet.add(ScreenCharacterStyle.Bold);
        }
        this.screen.putString(column + this.topLeft.getColumn(), row + this.topLeft.getRow(), string, this.foregroundColor, this.backgroundColor, stylesSet);
    }

    @Override
    public Terminal.Color getBackgroundColor() {
        return this.backgroundColor;
    }

    @Override
    public Terminal.Color getForegroundColor() {
        return this.foregroundColor;
    }

    @Override
    public void setBackgroundColor(Terminal.Color backgroundColor) {
        this.backgroundColor = backgroundColor;
    }

    @Override
    public void setForegroundColor(Terminal.Color foregroundColor) {
        this.foregroundColor = foregroundColor;
    }

    @Override
    public int getWidth() {
        return this.areaSize.getColumns();
    }

    @Override
    public int getHeight() {
        return this.areaSize.getRows();
    }

    @Override
    public TerminalSize getSize() {
        return new TerminalSize(this.getWidth(), this.getHeight());
    }

    @Override
    public void setBoldMask(boolean enabledBoldMask) {
        this.currentlyBold = enabledBoldMask;
    }

    @Override
    public Theme getTheme() {
        return this.theme;
    }

    @Override
    public TerminalPosition translateToGlobalCoordinates(TerminalPosition pointInArea) {
        return new TerminalPosition(pointInArea.getColumn() + this.topLeft.getColumn(), pointInArea.getRow() + this.topLeft.getRow());
    }

    @Override
    public void applyTheme(Theme.Category category) {
        this.applyTheme(this.getTheme().getDefinition(category));
    }

    @Override
    public void applyTheme(Theme.Definition themeItem) {
        this.setForegroundColor(themeItem.foreground());
        this.setBackgroundColor(themeItem.background());
        this.setBoldMask(themeItem.isHighlighted());
    }

    @Override
    public void fillArea(char character) {
        this.fillRectangle(character, new TerminalPosition(0, 0), new TerminalSize(this.areaSize));
    }

    @Override
    public void fillRectangle(char character, TerminalPosition topLeft, TerminalSize rectangleSize) {
        StringBuilder emptyLineBuilder = new StringBuilder();
        for (int i = 0; i < rectangleSize.getColumns(); ++i) {
            emptyLineBuilder.append(character);
        }
        String emptyLine = emptyLineBuilder.toString();
        for (int i = 0; i < rectangleSize.getRows(); ++i) {
            this.drawString(topLeft.getColumn(), topLeft.getRow() + i, emptyLine, new ScreenCharacterStyle[0]);
        }
    }

    public String toString() {
        return "TextGraphics {topLeft: " + this.topLeft.toString() + ", size: " + this.areaSize.toString() + "}";
    }

    private static class NullTextGraphics
    implements TextGraphics {
        private NullTextGraphics() {
        }

        @Override
        public void applyTheme(Theme.Category category) {
        }

        @Override
        public void applyTheme(Theme.Definition themeItem) {
        }

        @Override
        public void drawString(int column, int row, String string, ScreenCharacterStyle ... styles) {
        }

        @Override
        public void fillArea(char character) {
        }

        @Override
        public void fillRectangle(char character, TerminalPosition topLeft, TerminalSize rectangleSize) {
        }

        @Override
        public Terminal.Color getBackgroundColor() {
            return Terminal.Color.DEFAULT;
        }

        @Override
        public Terminal.Color getForegroundColor() {
            return Terminal.Color.DEFAULT;
        }

        @Override
        public int getHeight() {
            return 0;
        }

        @Override
        public TerminalSize getSize() {
            return new TerminalSize(0, 0);
        }

        @Override
        public Theme getTheme() {
            return Theme.getDefaultTheme();
        }

        @Override
        public int getWidth() {
            return 0;
        }

        @Override
        public void setBackgroundColor(Terminal.Color backgroundColor) {
        }

        @Override
        public void setBoldMask(boolean enabledBoldMask) {
        }

        @Override
        public void setForegroundColor(Terminal.Color foregroundColor) {
        }

        @Override
        public TextGraphics subAreaGraphics(TerminalPosition terminalPosition) {
            return new NullTextGraphics();
        }

        @Override
        public TextGraphics subAreaGraphics(TerminalPosition topLeft, TerminalSize subAreaSize) {
            return new NullTextGraphics();
        }

        @Override
        public TerminalPosition translateToGlobalCoordinates(TerminalPosition pointInArea) {
            return new TerminalPosition(0, 0);
        }
    }
}

