/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.executor.context;

import de.rcenvironment.core.utils.common.validation.ValidationFailureException;
import de.rcenvironment.core.utils.executor.CommandLineExecutor;
import de.rcenvironment.core.utils.executor.context.ExecutorContextFactory;
import de.rcenvironment.core.utils.executor.context.spi.ExecutorContext;
import de.rcenvironment.core.utils.executor.context.spi.SandboxStrategy;
import java.io.IOException;

public class SandboxedExecutorLifeCycleFacade {
    private ExecutorContext executionContext;
    private SandboxStrategy sandboxStrategy;

    public SandboxedExecutorLifeCycleFacade(ExecutorContextFactory factory) {
        this.executionContext = factory.createExecutorContext();
        this.sandboxStrategy = factory.createSandboxStrategy(this.executionContext);
    }

    public void setUpSession() throws IOException, ValidationFailureException {
        this.executionContext.setUpSession();
    }

    public CommandLineExecutor setUpExecutionPhase() throws IOException {
        return this.sandboxStrategy.prepareExecutionPhase();
    }

    public void tearDownExecutionPhase(CommandLineExecutor executor) throws IOException {
        this.sandboxStrategy.afterExecutionPhase(executor);
    }

    public void tearDownSession() throws IOException {
        this.sandboxStrategy.beforeSessionTeardown();
        this.executionContext.tearDownSession();
    }

    public ExecutorContext getExecutorContext() {
        return this.executionContext;
    }
}

