/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.timeline;

import de.rcenvironment.core.gui.resources.api.ColorManager;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineActivityPart;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineView;
import de.rcenvironment.core.gui.workflow.view.timeline.TimelineViewConstants;
import java.util.Date;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;

public class TimelineComponentCanvas
extends Canvas
implements PaintListener,
MouseListener,
MouseMoveListener {
    private TimelineActivityPart[] activities = null;
    private Date wfEndTime = null;
    private Date visibleStartTime = null;
    private Date visibleEndTime = null;

    public TimelineComponentCanvas(Composite parent, Date startTime, Date endTime) {
        super(parent, 4);
        this.addPaintListener(this);
        this.addMouseMoveListener(this);
        this.setVisibleTimeArea(startTime, endTime);
    }

    public void paintControl(PaintEvent e) {
        int maxX = this.getSize().x;
        int maxY = this.getSize().y;
        e.gc.setBackground(ColorManager.getInstance().getSharedColor(TimelineViewConstants.CANVAS_COLOR_BACKGROUND));
        e.gc.fillRectangle(0, 0, maxX, maxY);
        e.gc.setForeground(ColorManager.getInstance().getSharedColor(TimelineViewConstants.CANVAS_COLOR_BACKGROUND_LINE));
        e.gc.drawLine(0, maxY / 2, maxX, maxY / 2);
        if (this.activities == null || this.activities.length == 0 || this.visibleStartTime == null || this.visibleEndTime == null || this.wfEndTime == null) {
            return;
        }
        int i = 0;
        while (i < this.activities.length) {
            TimelineActivityPart activity = this.activities[i];
            if (activity.getType() != null && activity.getType().getColor() != null) {
                if (activity.getEndDate() == null) {
                    activity.setEndtime(this.wfEndTime);
                }
                if (!activity.getEndDate().before(this.visibleStartTime) && !activity.getDate().after(this.visibleEndTime)) {
                    e.gc.setBackground(new Color(null, activity.getType().getColor()));
                    long startdraw = TimelineView.convertDateToPixel(activity.getDate(), maxX, this.visibleStartTime, this.visibleEndTime);
                    long enddraw = (long)TimelineView.convertDateToPixel(activity.getEndDate(), maxX, this.visibleStartTime, this.visibleEndTime) - startdraw;
                    e.gc.fillRectangle((int)startdraw, 3, (int)enddraw, maxY - 4);
                }
            }
            ++i;
        }
    }

    public void setWorkflowEndTime(Date newwfEndTime) {
        this.wfEndTime = newwfEndTime;
        this.redraw();
    }

    public void setVisibleTimeArea(Date startTime, Date endTime) {
        this.visibleStartTime = startTime;
        this.visibleEndTime = endTime;
        this.redraw();
    }

    public void setActivities(TimelineActivityPart[] newActivities) {
        this.activities = newActivities;
        this.redraw();
    }

    public void mouseDoubleClick(MouseEvent arg0) {
    }

    public void mouseDown(MouseEvent arg0) {
    }

    public void mouseUp(MouseEvent arg0) {
    }

    public void mouseMove(MouseEvent e) {
        String newToolTipText = "";
        long tmpdate = (long)e.x * (this.visibleEndTime.getTime() - this.visibleStartTime.getTime()) / (long)this.getSize().x + this.visibleStartTime.getTime();
        int i = 0;
        while (i < this.activities.length) {
            TimelineActivityPart current = this.activities[i];
            if (current.getDate().getTime() < tmpdate) {
                newToolTipText = this.activities[i].getTooltipText(this.wfEndTime);
            }
            ++i;
        }
        this.setToolTipText(newToolTipText);
    }
}

