/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.datamanagement.browser.spi;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.component.datamanagement.api.ComponentDataManagementService;
import de.rcenvironment.core.component.datamanagement.api.DefaultComponentHistoryDataItem;
import de.rcenvironment.core.component.datamanagement.api.EndpointHistoryDataItem;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.DataTypeException;
import de.rcenvironment.core.datamodel.api.EndpointType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.api.TypedDatumConverter;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.datamodel.types.api.DirectoryReferenceTD;
import de.rcenvironment.core.datamodel.types.api.FileReferenceTD;
import de.rcenvironment.core.datamodel.types.api.MatrixTD;
import de.rcenvironment.core.datamodel.types.api.NotAValueTD;
import de.rcenvironment.core.datamodel.types.api.SmallTableTD;
import de.rcenvironment.core.datamodel.types.api.VectorTD;
import de.rcenvironment.core.gui.datamanagement.browser.Activator;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNode;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeType;
import de.rcenvironment.core.utils.common.JsonUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class CommonHistoryDataItemSubtreeBuilderUtils {
    public static final String COLON = ": ";
    public static final int MAX_LABEL_LENGTH = 30;
    private static final String STRING_CONVERSION_INFORMATION = "{\"guiName\":\"Converted from data type %s\", \"value\":\"%s\"}";
    private static final String NOT_CONVERTIBLE_MESSAGE = "Datum of type '%s' is not convertible to data type '%s' expected by input '%s'";
    private static final int MAX_NON_PERSISTENT_ENTRIES = 1000;
    private static final String LEAF_TEXT_FORMAT = "%s: %s";
    private static final List<String> META_DATA_KEYS_TO_HIDE = new ArrayList<String>(Arrays.asList("rce.common.data_type"));
    private static Log logger = LogFactory.getLog(CommonHistoryDataItemSubtreeBuilderUtils.class);
    private static ObjectMapper mapper = JsonUtils.getDefaultObjectMapper();

    private CommonHistoryDataItemSubtreeBuilderUtils() {
    }

    public static void buildDefaultHistoryDataItemSubtrees(DefaultComponentHistoryDataItem dataItem, DMBrowserNode parent) {
        CommonHistoryDataItemSubtreeBuilderUtils.buildInputsSubstree(dataItem, parent);
        CommonHistoryDataItemSubtreeBuilderUtils.buildOutputsSubtree(dataItem, parent);
    }

    public static void buildCommonHistoryDataItemSubtrees(CommonComponentHistoryDataItem dataItem, DMBrowserNode parent) {
        CommonHistoryDataItemSubtreeBuilderUtils.buildDefaultHistoryDataItemSubtrees((DefaultComponentHistoryDataItem)dataItem, parent);
        CommonHistoryDataItemSubtreeBuilderUtils.buildExitCodeNode(dataItem, parent);
    }

    public static void buildInputsSubstree(DefaultComponentHistoryDataItem dataItem, DMBrowserNode parent) {
        if (dataItem.getInputs().size() > 0) {
            DMBrowserNode inputNode = DMBrowserNode.addNewChildNode("Inputs", DMBrowserNodeType.Input, parent);
            List<String> inputKeyList = CommonHistoryDataItemSubtreeBuilderUtils.sortKeys(dataItem.getInputs().keySet());
            for (String name : inputKeyList) {
                Deque inputsDeque = (Deque)dataItem.getInputs().get(name);
                if (inputsDeque.size() == 1) {
                    EndpointHistoryDataItem currentInput = (EndpointHistoryDataItem)inputsDeque.pop();
                    CommonHistoryDataItemSubtreeBuilderUtils.handleDataItem(currentInput, name, inputNode, parent.getDataReferenceId(), EndpointType.INPUT, dataItem.getMetaDataForInput(name));
                    continue;
                }
                if (inputsDeque.size() <= 1) continue;
                DMBrowserNodeType type = CommonHistoryDataItemSubtreeBuilderUtils.getDMBrowserNodeTypeByDataType(((EndpointHistoryDataItem)inputsDeque.peekFirst()).getValue().getDataType());
                DMBrowserNode inputNameNode = DMBrowserNode.addNewChildNode(name, type, inputNode);
                for (EndpointHistoryDataItem item : inputsDeque) {
                    CommonHistoryDataItemSubtreeBuilderUtils.handleDataItem(item, name, inputNameNode, parent.getDataReferenceId(), EndpointType.INPUT, dataItem.getMetaDataForInput(name));
                }
            }
        }
    }

    public static void buildOutputsSubtree(DefaultComponentHistoryDataItem dataItem, DMBrowserNode parent) {
        if (dataItem.getOutputs().size() > 0) {
            DMBrowserNode outputNode = DMBrowserNode.addNewChildNode("Outputs", DMBrowserNodeType.Output, parent);
            List<String> outputKeyList = CommonHistoryDataItemSubtreeBuilderUtils.sortKeys(dataItem.getOutputs().keySet());
            for (String name : outputKeyList) {
                Deque outputsDeque = (Deque)dataItem.getOutputs().get(name);
                if (outputsDeque.size() == 1) {
                    EndpointHistoryDataItem currentOutput = (EndpointHistoryDataItem)outputsDeque.pop();
                    CommonHistoryDataItemSubtreeBuilderUtils.handleDataItem(currentOutput, name, outputNode, parent.getDataReferenceId(), EndpointType.OUTPUT, dataItem.getMetaDataForOutput(name));
                    continue;
                }
                if (outputsDeque.size() <= 1) continue;
                DMBrowserNodeType type = CommonHistoryDataItemSubtreeBuilderUtils.getDMBrowserNodeTypeByDataType(((EndpointHistoryDataItem)outputsDeque.peekFirst()).getValue().getDataType());
                DMBrowserNode outputNameNode = DMBrowserNode.addNewChildNode(name, type, outputNode);
                for (EndpointHistoryDataItem item : outputsDeque) {
                    CommonHistoryDataItemSubtreeBuilderUtils.handleDataItem(item, name, outputNameNode, parent.getDataReferenceId(), EndpointType.OUTPUT, dataItem.getMetaDataForOutput(name));
                }
            }
        }
    }

    public static void buildExitCodeNode(CommonComponentHistoryDataItem dataItem, DMBrowserNode parent) {
        if (dataItem.getExitCode() != null) {
            DMBrowserNode executionLogNode = null;
            for (DMBrowserNode node : parent.getChildren()) {
                if (!node.getTitle().equals("Execution Log")) continue;
                executionLogNode = node;
                break;
            }
            if (executionLogNode == null) {
                executionLogNode = DMBrowserNode.addNewChildNode("Execution Log", DMBrowserNodeType.LogFolder, parent);
            }
            if (dataItem.getExitCode() != null) {
                DMBrowserNode.addNewLeafNode(StringUtils.format((String)"%s: %d", (Object[])new Object[]{"Exit code", dataItem.getExitCode()}), DMBrowserNodeType.InformationText, executionLogNode);
            }
        }
    }

    private static DMBrowserNodeType getDMBrowserNodeTypeByDataType(DataType dataType) {
        DMBrowserNodeType type = null;
        type = dataType == DataType.ShortText ? DMBrowserNodeType.ShortText : (dataType == DataType.Boolean ? DMBrowserNodeType.Boolean : (dataType == DataType.Integer ? DMBrowserNodeType.Integer : (dataType == DataType.Float ? DMBrowserNodeType.Float : (dataType == DataType.Vector ? DMBrowserNodeType.Vector : (dataType == DataType.SmallTable ? DMBrowserNodeType.SmallTable : (dataType == DataType.NotAValue ? DMBrowserNodeType.Indefinite : (dataType == DataType.FileReference ? DMBrowserNodeType.DMFileResource : (dataType == DataType.DirectoryReference ? DMBrowserNodeType.DMDirectoryReference : (dataType == DataType.Matrix ? DMBrowserNodeType.Matrix : DMBrowserNodeType.InformationText)))))))));
        return type;
    }

    private static List<String> sortKeys(Set<String> unsortedKeys) {
        ArrayList<String> sortedKeys = new ArrayList<String>();
        sortedKeys.addAll(unsortedKeys);
        Collections.sort(sortedKeys);
        return sortedKeys;
    }

    private static void addFileReference(EndpointHistoryDataItem item, DMBrowserNode node) {
        if (item.getValue() instanceof FileReferenceTD) {
            FileReferenceTD fileReference = (FileReferenceTD)item.getValue();
            node.setAssociatedFilename(fileReference.getFileName());
            node.setDataReferenceId(fileReference.getFileReference());
            node.setTitle(StringUtils.format((String)LEAF_TEXT_FORMAT, (Object[])new Object[]{item.getEndpointName(), fileReference.getFileName()}));
        }
    }

    private static void addDirectoryReference(EndpointHistoryDataItem item, DMBrowserNode node) {
        if (item.getValue() instanceof DirectoryReferenceTD) {
            DirectoryReferenceTD directoryReference = (DirectoryReferenceTD)item.getValue();
            node.setAssociatedFilename(directoryReference.getDirectoryName());
            node.setDataReferenceId(directoryReference.getDirectoryReference());
            node.setTitle(StringUtils.format((String)LEAF_TEXT_FORMAT, (Object[])new Object[]{item.getEndpointName(), directoryReference.getDirectoryName()}));
            node.setDirectoryReferenceTD((DirectoryReferenceTD)item.getValue());
        }
    }

    private static String getAbbreviatedContent(TypedDatum datum) {
        DataType dataType = datum.getDataType();
        switch (dataType) {
            case SmallTable: {
                SmallTableTD table = (SmallTableTD)datum;
                return table.toLengthLimitedString(30);
            }
            case Vector: {
                VectorTD vector = (VectorTD)datum;
                return vector.toLengthLimitedString(30);
            }
            case Matrix: {
                MatrixTD matrix = (MatrixTD)datum;
                return matrix.toLengthLimitedString(30);
            }
        }
        return datum.toString();
    }

    private static String handleBooleanDigitShortTextLabel(EndpointHistoryDataItem item, String endpointName, DMBrowserNode node) {
        String fullContent = item.getValue().toString();
        return CommonHistoryDataItemSubtreeBuilderUtils.handleLabel(fullContent, org.apache.commons.lang3.StringUtils.abbreviate((String)fullContent, (int)30), endpointName, node);
    }

    private static void handleNotAValueLabel(EndpointHistoryDataItem item, String endpointName, DMBrowserNode node) {
        NotAValueTD notAValue = (NotAValueTD)item.getValue();
        String labelText = notAValue.toString();
        labelText = notAValue.getCause().equals((Object)NotAValueTD.Cause.Failure) ? String.valueOf(labelText) + " [cause: some component failed]" : String.valueOf(labelText) + " [cause: explicitly sent by some component]";
        node.setTitle(StringUtils.format((String)LEAF_TEXT_FORMAT, (Object[])new Object[]{endpointName, labelText}));
    }

    private static String handleSmallTableLabel(EndpointHistoryDataItem item, String endpointName, DMBrowserNode node) {
        SmallTableTD table = (SmallTableTD)item.getValue();
        String abbreviatedContent = table.toLengthLimitedString(30);
        if (table.getColumnCount() * table.getRowCount() > 1000) {
            node.setSmallTableTDAndFileName(table, endpointName);
            return CommonHistoryDataItemSubtreeBuilderUtils.handleLabel(abbreviatedContent, endpointName, node);
        }
        return CommonHistoryDataItemSubtreeBuilderUtils.handleLabel(table.toString(), abbreviatedContent, endpointName, node);
    }

    private static String handleMatrixLabel(EndpointHistoryDataItem item, String endpointName, DMBrowserNode node) {
        MatrixTD matrix = (MatrixTD)item.getValue();
        String abbreviatedContent = matrix.toLengthLimitedString(30);
        if (matrix.getRowDimension() * matrix.getColumnDimension() > 1000) {
            node.setMatrixTDAndFileName(matrix, endpointName);
            return CommonHistoryDataItemSubtreeBuilderUtils.handleLabel(abbreviatedContent, endpointName, node);
        }
        return CommonHistoryDataItemSubtreeBuilderUtils.handleLabel(matrix.toString(), abbreviatedContent, endpointName, node);
    }

    private static String handleVectorLabel(EndpointHistoryDataItem item, String endpointName, DMBrowserNode node) {
        VectorTD vector = (VectorTD)item.getValue();
        String abbreviatedContent = vector.toLengthLimitedString(30);
        if (vector.getRowDimension() > 1000) {
            node.setVectorTDAndFileName(vector, endpointName);
            return CommonHistoryDataItemSubtreeBuilderUtils.handleLabel(abbreviatedContent, endpointName, node);
        }
        return CommonHistoryDataItemSubtreeBuilderUtils.handleLabel(vector.toString(), abbreviatedContent, endpointName, node);
    }

    private static String handleLabel(String abbreviatedContent, String endpointName, DMBrowserNode node) {
        String formattedLabel = StringUtils.format((String)LEAF_TEXT_FORMAT, (Object[])new Object[]{endpointName, abbreviatedContent});
        node.setTitle(formattedLabel);
        return formattedLabel;
    }

    private static String handleLabel(String fullContent, String abbreviatedContent, String endpointName, DMBrowserNode node) {
        node.setFileContentAndName(fullContent, endpointName);
        return CommonHistoryDataItemSubtreeBuilderUtils.handleLabel(abbreviatedContent, endpointName, node);
    }

    private static void handleDataItem(EndpointHistoryDataItem item, String name, DMBrowserNode parent, String historyItemDataReferenceId, EndpointType endpointType, Map<String, String> endpointMetaData) {
        boolean hasMetaData = endpointMetaData != null && !endpointMetaData.isEmpty();
        DataType currentDataType = item.getValue().getDataType();
        if (hasMetaData && endpointMetaData.containsKey("rce.common.data_type") && currentDataType != DataType.NotAValue) {
            currentDataType = DataType.byShortName((String)endpointMetaData.get("rce.common.data_type"));
            if (!item.getValue().getDataType().equals((Object)currentDataType)) {
                try {
                    CommonHistoryDataItemSubtreeBuilderUtils dummyInstance = new CommonHistoryDataItemSubtreeBuilderUtils();
                    ServiceRegistryAccess registryAccess = ServiceRegistry.createAccessFor((Object)dummyInstance);
                    TypedDatumConverter converter = ((TypedDatumService)registryAccess.getService(TypedDatumService.class)).getConverter();
                    endpointMetaData.put("rce.common.data_type_conversion", StringUtils.format((String)STRING_CONVERSION_INFORMATION, (Object[])new Object[]{item.getValue().getDataType().getDisplayName(), CommonHistoryDataItemSubtreeBuilderUtils.getAbbreviatedContent(item.getValue())}));
                    item = new EndpointHistoryDataItem(item.getTimestamp(), item.getEndpointName(), converter.castOrConvert(item.getValue(), currentDataType));
                }
                catch (DataTypeException dataTypeException) {
                    throw new RuntimeException(StringUtils.format((String)NOT_CONVERTIBLE_MESSAGE, (Object[])new Object[]{item.getValue().getDataType(), currentDataType, name}));
                }
            }
        }
        DMBrowserNodeType type = CommonHistoryDataItemSubtreeBuilderUtils.getDMBrowserNodeTypeByDataType(currentDataType);
        DMBrowserNode node = null;
        if (currentDataType != DataType.DirectoryReference && !CommonHistoryDataItemSubtreeBuilderUtils.hasMetaDataToDisplay(endpointMetaData)) {
            node = DMBrowserNode.addNewLeafNode(name, type, parent);
        } else if (CommonHistoryDataItemSubtreeBuilderUtils.hasMetaDataToDisplay(endpointMetaData)) {
            DMBrowserNode outputNameNode = DMBrowserNode.addNewChildNode(name, type, parent);
            node = DMBrowserNode.addNewLeafNode(name, type, outputNameNode);
        } else {
            node = DMBrowserNode.addNewChildNode(name, type, parent);
        }
        switch (currentDataType) {
            case SmallTable: {
                CommonHistoryDataItemSubtreeBuilderUtils.handleSmallTableLabel(item, name, node);
                break;
            }
            case Vector: {
                CommonHistoryDataItemSubtreeBuilderUtils.handleVectorLabel(item, name, node);
                break;
            }
            case ShortText: 
            case Boolean: 
            case Integer: 
            case Float: {
                CommonHistoryDataItemSubtreeBuilderUtils.handleBooleanDigitShortTextLabel(item, name, node);
                break;
            }
            case NotAValue: {
                CommonHistoryDataItemSubtreeBuilderUtils.handleNotAValueLabel(item, name, node);
                break;
            }
            case Matrix: {
                CommonHistoryDataItemSubtreeBuilderUtils.handleMatrixLabel(item, name, node);
                break;
            }
            case FileReference: {
                CommonHistoryDataItemSubtreeBuilderUtils.addFileReference(item, node);
                break;
            }
            case DirectoryReference: {
                CommonHistoryDataItemSubtreeBuilderUtils.addDirectoryReference(item, node);
                break;
            }
            default: {
                node.setTitle(StringUtils.format((String)LEAF_TEXT_FORMAT, (Object[])new Object[]{name, item.getValue()}));
            }
        }
        if (CommonHistoryDataItemSubtreeBuilderUtils.hasMetaDataToDisplay(endpointMetaData)) {
            for (Map.Entry<String, String> property : endpointMetaData.entrySet()) {
                if (property.getKey().equals("rce.common.data_type")) continue;
                try {
                    JsonNode tree = mapper.readTree(property.getValue());
                    DMBrowserNode.addNewLeafNode(StringUtils.format((String)LEAF_TEXT_FORMAT, (Object[])new Object[]{tree.get("guiName").asText(), tree.get("value").asText()}), DMBrowserNodeType.InformationText, node.getParent());
                }
                catch (IOException iOException) {
                    logger.error((Object)("Could not parse endpoint properties from json string " + property.getValue()));
                }
            }
        }
    }

    private static boolean hasMetaDataToDisplay(Map<String, String> endpointMetaData) {
        if (endpointMetaData != null && !endpointMetaData.isEmpty()) {
            for (String key : endpointMetaData.keySet()) {
                if (META_DATA_KEYS_TO_HIDE.contains(key)) continue;
                return true;
            }
        }
        return false;
    }

    public static void buildSubtreeForDirectoryItem(DirectoryReferenceTD directoryReference, DMBrowserNode node, DMBrowserNode parent) {
        File dir = new File(Activator.getInstance().getBundleSpecificTempDir(), directoryReference.getDirectoryReference());
        if (!(dir.mkdir() || dir.exists() && !dir.isFile())) {
            logger.error((Object)("Temp directory could not be created or did already exist as file: " + dir));
            return;
        }
        if (dir.list().length == 0) {
            CommonHistoryDataItemSubtreeBuilderUtils dummyInstance = new CommonHistoryDataItemSubtreeBuilderUtils();
            ServiceRegistryAccess serviceRegistryAccess = ServiceRegistry.createAccessFor((Object)dummyInstance);
            ComponentDataManagementService componentService = (ComponentDataManagementService)serviceRegistryAccess.getService(ComponentDataManagementService.class);
            try {
                componentService.copyDirectoryReferenceTDToLocalDirectory(directoryReference, dir, (NetworkDestination)parent.getNodeWithTypeWorkflow().getNodeIdentifier());
            }
            catch (IOException e) {
                logger.error((Object)"Copying directory from data management to the file system failed", (Throwable)e);
            }
        }
        if (dir != null) {
            File f = new File(dir, directoryReference.getDirectoryName());
            if (f.listFiles() != null && f.listFiles().length > 0) {
                CommonHistoryDataItemSubtreeBuilderUtils.recursiveBrowseDirectory(new File(dir, directoryReference.getDirectoryName()), node);
            } else {
                node.markAsLeaf();
            }
        }
    }

    private static void recursiveBrowseDirectory(File parentFile, DMBrowserNode parentNode) {
        File[] fileArray = parentFile.listFiles();
        int n = fileArray.length;
        int n2 = 0;
        while (n2 < n) {
            DMBrowserNode node;
            File file = fileArray[n2];
            if (file.isDirectory()) {
                if (file.listFiles().length > 0) {
                    node = DMBrowserNode.addNewChildNode(file.getName(), DMBrowserNodeType.DMDirectoryReference, parentNode);
                    CommonHistoryDataItemSubtreeBuilderUtils.recursiveBrowseDirectory(file, node);
                } else {
                    DMBrowserNode.addNewLeafNode(file.getName(), DMBrowserNodeType.DMDirectoryReference, parentNode);
                }
            } else {
                node = DMBrowserNode.addNewLeafNode(file.getName(), DMBrowserNodeType.DMFileResource, parentNode);
                node.setAssociatedFilename(file.getName());
                node.setFileReferencePath(file.getAbsolutePath());
            }
            ++n2;
        }
    }
}

