/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.evaluationmemory.execution.internal;

import de.rcenvironment.core.component.execution.api.ComponentLog;
import de.rcenvironment.core.datamodel.api.DataType;
import de.rcenvironment.core.datamodel.api.TypedDatum;
import de.rcenvironment.core.datamodel.types.api.FloatTD;
import de.rcenvironment.core.datamodel.types.api.IntegerTD;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;

public abstract class ToleranceHandling {
    private final ComponentLog log;

    private ToleranceHandling(ComponentLog log) {
        this.log = log;
    }

    public static ToleranceHandling constructLenientHandling(ComponentLog log) {
        return new LenientToleranceHandling(log);
    }

    public static ToleranceHandling constructStrictHandling(ComponentLog log) {
        return new StrictToleranceHandling(log);
    }

    public boolean isInToleranceInterval(Map<String, TypedDatum> inputValues, Map<String, Double> tolerances, Map<String, TypedDatum> storedValues) {
        Set<String> inputs = inputValues.keySet();
        boolean allDataInToleranceInterval = true;
        for (String input : inputs) {
            TypedDatum inputValue = inputValues.get(input);
            if (!tolerances.containsKey(input)) {
                String errorString = String.format("Internal error: No tolerance found in Metadata for input %s", input);
                this.log.componentError(errorString);
                return false;
            }
            Double tolerance = tolerances.get(input);
            if (!storedValues.containsKey(input)) {
                String errorString = String.format("Internal error: No value found in stored vector for input %s", input);
                this.log.componentError(errorString);
                return false;
            }
            TypedDatum storedValue = storedValues.get(input);
            allDataInToleranceInterval &= this.singleDatumInToleranceInterval(inputValue, tolerance, storedValue);
        }
        return allDataInToleranceInterval;
    }

    private boolean singleDatumInToleranceInterval(TypedDatum inputValue, Double tolerance, TypedDatum storedValue) {
        boolean singleDatumAboveLowerBound;
        boolean singleDatumBelowUpperBound;
        if (tolerance == null || (double)tolerance.floatValue() == 0.0) {
            return inputValue.equals(storedValue);
        }
        float toleranceValue = tolerance.floatValue();
        DataType inputType = inputValue.getDataType();
        if (inputType.equals((Object)DataType.Float)) {
            double upperBound = ((FloatTD)inputValue).getFloatValue() * (1.0 + (double)toleranceValue);
            singleDatumBelowUpperBound = ((FloatTD)storedValue).getFloatValue() <= upperBound;
            double lowerBound = ((FloatTD)inputValue).getFloatValue() * (1.0 - (double)toleranceValue);
            singleDatumAboveLowerBound = lowerBound <= ((FloatTD)storedValue).getFloatValue();
        } else {
            int upperBound = (int)((double)((IntegerTD)inputValue).getIntValue() * (1.0 + (double)toleranceValue));
            singleDatumBelowUpperBound = ((IntegerTD)storedValue).getIntValue() <= (long)upperBound;
            int lowerBound = (int)((double)((IntegerTD)inputValue).getIntValue() * (1.0 - (double)toleranceValue));
            boolean bl = singleDatumAboveLowerBound = (long)(lowerBound + 1) <= ((IntegerTD)storedValue).getIntValue();
        }
        return singleDatumBelowUpperBound && singleDatumAboveLowerBound;
    }

    public SortedMap<String, TypedDatum> pickMostToleratedInputs(Collection<SortedMap<String, TypedDatum>> candidates, SortedMap<String, TypedDatum> inputValue) {
        SortedMap<String, TypedDatum> returnValue = this.choiceAlgorithm(candidates, inputValue);
        if (returnValue != null) {
            String logMessage = String.format("Picked stored value '%s' as representative within tolerance interval of '%s'", returnValue, inputValue);
            this.log.componentInfo(logMessage);
        }
        return returnValue;
    }

    protected abstract SortedMap<String, TypedDatum> choiceAlgorithm(Collection<SortedMap<String, TypedDatum>> var1, SortedMap<String, TypedDatum> var2);

    static final class LenientToleranceHandling
    extends ToleranceHandling {
        LenientToleranceHandling(ComponentLog log) {
            super(log);
        }

        @Override
        public SortedMap<String, TypedDatum> choiceAlgorithm(Collection<SortedMap<String, TypedDatum>> candidates, SortedMap<String, TypedDatum> inputValue) {
            Iterator<SortedMap<String, TypedDatum>> iterator = candidates.iterator();
            if (iterator.hasNext()) {
                return candidates.iterator().next();
            }
            return null;
        }
    }

    static final class StrictToleranceHandling
    extends ToleranceHandling {
        StrictToleranceHandling(ComponentLog log) {
            super(log);
        }

        @Override
        public SortedMap<String, TypedDatum> choiceAlgorithm(Collection<SortedMap<String, TypedDatum>> candidates, SortedMap<String, TypedDatum> inputValue) {
            if (candidates.size() == 1) {
                return candidates.iterator().next();
            }
            return null;
        }
    }
}

