/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.components.cpacs.writer.gui;

import de.rcenvironment.core.component.api.ComponentUtils;
import de.rcenvironment.core.component.datamanagement.api.CommonComponentHistoryDataItem;
import de.rcenvironment.core.component.xml.XmlComponentHistoryDataItem;
import de.rcenvironment.core.datamodel.api.TypedDatumSerializer;
import de.rcenvironment.core.datamodel.api.TypedDatumService;
import de.rcenvironment.core.gui.datamanagement.browser.spi.CommonHistoryDataItemSubtreeBuilderUtils;
import de.rcenvironment.core.gui.datamanagement.browser.spi.ComponentHistoryDataItemSubtreeBuilder;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNode;
import de.rcenvironment.core.gui.datamanagement.browser.spi.DMBrowserNodeType;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.net.URL;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;

public class CpacsWriterHistoryDataItemSubtreeBuilder
implements ComponentHistoryDataItemSubtreeBuilder {
    private static final Image COMPONENT_ICON;

    static {
        String bundleName = "de.rcenvironment.components.cpacs.writer.common";
        String iconName = "cpacsWriter16.png";
        URL url = ComponentUtils.readIconURL((String)bundleName, (String)iconName);
        COMPONENT_ICON = url != null ? ImageDescriptor.createFromURL((URL)url).createImage() : null;
    }

    public String[] getSupportedHistoryDataItemIdentifier() {
        return new String[]{"de.rcenvironment.cpacswriter"};
    }

    public Serializable deserializeHistoryDataItem(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        return (Serializable)ois.readObject();
    }

    public void buildInitialHistoryDataItemSubtree(Serializable historyDataItem, DMBrowserNode parent) {
        ServiceRegistryAccess registryAccess = ServiceRegistry.createAccessFor((Object)this);
        TypedDatumSerializer serializer = ((TypedDatumService)registryAccess.getService(TypedDatumService.class)).getSerializer();
        if (historyDataItem instanceof String) {
            XmlComponentHistoryDataItem historyData;
            try {
                historyData = XmlComponentHistoryDataItem.fromString((String)((String)((Object)historyDataItem)), (TypedDatumSerializer)serializer, (String)"de.rcenvironment.cpacswriter");
            }
            catch (IOException e) {
                throw new IllegalArgumentException(e);
            }
            CommonHistoryDataItemSubtreeBuilderUtils.buildCommonHistoryDataItemSubtrees((CommonComponentHistoryDataItem)historyData, (DMBrowserNode)parent);
            if (historyData.getXmlWithVariablesFileReference() != null) {
                DMBrowserNode mappingWithVariablesNode = DMBrowserNode.addNewChildNode((String)"Mapping with variables", (DMBrowserNodeType)DMBrowserNodeType.InformationText, (DMBrowserNode)parent);
                DMBrowserNode cpacsWithVariablesFileNode = DMBrowserNode.addNewLeafNode((String)"cpacsWithVariables.xml", (DMBrowserNodeType)DMBrowserNodeType.DMFileResource, (DMBrowserNode)mappingWithVariablesNode);
                cpacsWithVariablesFileNode.setAssociatedFilename("cpacsWithVariables.xml");
                cpacsWithVariablesFileNode.setDataReferenceId(historyData.getXmlWithVariablesFileReference());
            }
        } else {
            throw new IllegalArgumentException(StringUtils.format((String)"Parsing history data point failed: Expected type %s, but was type %s", (Object[])new Object[]{String.class.getCanonicalName(), historyDataItem.getClass().getCanonicalName()}));
        }
    }

    public Image getComponentIcon(String identifier) {
        return COMPONENT_ICON;
    }
}

