/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.tiglviewer.views;

import com.sun.jna.Pointer;
import com.sun.jna.platform.win32.User32;
import com.sun.jna.platform.win32.WinDef;
import com.sun.jna.ptr.IntByReference;
import de.rcenvironment.core.configuration.ConfigurationSegment;
import de.rcenvironment.core.configuration.ConfigurationService;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.TempFileServiceAccess;
import de.rcenvironment.core.utils.incubator.ServiceRegistry;
import de.rcenvironment.core.utils.incubator.ServiceRegistryAccess;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Random;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.exec.OS;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.part.ViewPart;

public class TIGLViewer
extends ViewPart {
    public static final String ID = "de.rcenvironment.core.gui.tiglviewer.views.TIGLViewer";
    private static final Log LOGGER = LogFactory.getLog(TIGLViewer.class);
    private static final int RADIX = 36;
    private static final String DOUBLE_QUOTE = "\"";
    private static final String REGEXP_QUOTED_BACKSLASH = "\\\\";
    private static final int GRAB_PROCESS_THREAD_DELAY = 250;
    private static final int START_PROCESS_TIMEOUT = 10;
    private static final int LOAD_FILE_TIMEOUT = 90;
    private int processID = 0;
    private Future<?> grabApplication;
    private CountDownLatch grabProcessLatch = new CountDownLatch(1);
    private CountDownLatch grabWindowLatch = new CountDownLatch(1);
    private Composite parentComposite;
    private File ctrlFile = null;

    public void createPartControl(Composite parent) {
        this.parentComposite = parent;
        if (OS.isFamilyWindows()) {
            this.startTiGLViewerApplication();
        } else {
            this.showMessage("The TiGL Viewer integration is not supported by the current operating system");
        }
    }

    private void startTiGLViewerApplication() {
        this.showMessage("Waiting for the external TiGL Viewer application to be started...");
        ConfigurationSegment tiglViewerSegment = this.getTiGLViewerConfigurationSegment();
        String tiglViewerBinaryPath = tiglViewerSegment.getString("binaryPath");
        if (tiglViewerBinaryPath == null) {
            LOGGER.warn((Object)"TiGL Viewer integration not configured (correctly). The 'binaryPath' key of the 'tiglViewer' configuration segment returned null.");
            this.showMessage("The TiGL Viewer integration is not configured.\nPlease see the \"thirdPartyConfiguration\" segment in the configuration reference for details.");
            return;
        }
        int startupTimeout = tiglViewerSegment.getInteger("startupTimeoutSeconds") != null ? tiglViewerSegment.getInteger("startupTimeoutSeconds") : 10;
        boolean embedWindow = tiglViewerSegment.getBoolean("embedWindow") != null ? tiglViewerSegment.getBoolean("embedWindow") : true;
        String windowTitleToken = Long.toString(new Random().nextLong(), 36);
        String windowTitle = "TIGLViewer-" + windowTitleToken;
        File exeFile = new File(tiglViewerBinaryPath);
        if (!(exeFile.exists() && exeFile.isFile() && exeFile.canExecute())) {
            this.showMessage(StringUtils.format((String)"TiGL Viewer executable not found at the configured path: %s\nPlease check the TiGL Viewer configuration. See the \"thirdPartyConfiguration\" segment in the configuration reference for details.", (Object[])new Object[]{exeFile.getAbsolutePath()}));
            LOGGER.error((Object)StringUtils.format((String)"TiGL Viewer executable not found at path: %s", (Object[])new Object[]{exeFile.getAbsolutePath()}));
            return;
        }
        if (!exeFile.canExecute()) {
            this.showMessage(StringUtils.format((String)"The configured TiGL Viewer file is not executable: %s\nPlease check the file privileges.", (Object[])new Object[]{exeFile.getAbsolutePath()}));
            LOGGER.error((Object)StringUtils.format((String)"The configured TiGL Viewer file is not executable: %s", (Object[])new Object[]{exeFile.getAbsolutePath()}));
        }
        LOGGER.debug((Object)StringUtils.format((String)"Located TiGL Viewer executable at: %s", (Object[])new Object[]{exeFile.getAbsolutePath()}));
        ConcurrencyUtils.getAsyncTaskService().execute("Starting TiGL Viewer application.", () -> {
            this.generateControlFile();
            String secondaryViewId = this.getViewSite().getSecondaryId();
            String exeFilePathString = this.convertToPathStringForExecution(exeFile);
            String ctrlFilePathString = this.convertToPathStringForExecution(this.ctrlFile);
            String commonCommandPart = this.buildCommonCommandPart(embedWindow, windowTitle, exeFilePathString, ctrlFilePathString);
            try {
                String sCommand;
                if (secondaryViewId == null) {
                    sCommand = commonCommandPart;
                    LOGGER.debug((Object)"Starting TiGL Viewer application without an input file.");
                } else {
                    File file2 = new File(secondaryViewId = secondaryViewId.replaceAll("&#38", ":"));
                    if (!file2.exists()) {
                        throw new IOException("Could not find input file for the TiGL Viewer: " + secondaryViewId);
                    }
                    sCommand = String.valueOf(commonCommandPart) + " --filename " + DOUBLE_QUOTE + secondaryViewId + DOUBLE_QUOTE;
                    LOGGER.debug((Object)StringUtils.format((String)"Starting TiGL Viewer application with input file %s", (Object[])new Object[]{secondaryViewId}));
                }
                Runtime.getRuntime().exec(sCommand);
                if (!this.grabProcessLatch.await(startupTimeout, TimeUnit.SECONDS)) {
                    throw new InterruptedException("Unable to identify TiGL Viewer process ID");
                }
                if (!this.grabWindowLatch.await(90L, TimeUnit.SECONDS)) {
                    throw new InterruptedException(StringUtils.format((String)"The TiGL Viewer application took too long to start. Timeout (%ss) reached.\nThis can be caused by too large input files or general problems with the TiGL Viewer application.", (Object[])new Object[]{90}));
                }
            }
            catch (IOException | InterruptedException e) {
                Display.getDefault().asyncExec(() -> this.showMessage("Unable to start the TiGL Viewer application.\n" + e.getMessage()));
                this.grabApplication.cancel(true);
                this.killTiglViewerProcess();
                this.disposeControlFile();
                LOGGER.error((Object)e);
                Thread.currentThread().interrupt();
            }
        });
        this.grabApplication = ConcurrencyUtils.getAsyncTaskService().scheduleAtFixedIntervalAfterInitialDelay("Grabbing the external TiGL Viewer application window.", () -> {
            LOGGER.debug((Object)"Scanning for the TiGL Viewer applications process ID.");
            WinDef.HWND hwnd = User32.INSTANCE.FindWindow(null, windowTitle);
            IntByReference pidReference = new IntByReference();
            User32.INSTANCE.GetWindowThreadProcessId(hwnd, pidReference);
            this.processID = pidReference.getValue();
            if (this.processID != 0) {
                this.grabProcessLatch.countDown();
                LOGGER.debug((Object)StringUtils.format((String)"TiGL Viewer application process startet with process ID %s.", (Object[])new Object[]{this.processID}));
                if (embedWindow) {
                    User32.INSTANCE.SetWindowLong(hwnd, -16, 0x14000000);
                    Display.getDefault().asyncExec(() -> {
                        if (this.parentComposite.isDisposed()) {
                            return;
                        }
                        LOGGER.debug((Object)StringUtils.format((String)"Grabbing the external TiGL Viewer window with the title '%s'.", (Object[])new Object[]{windowTitle}));
                        this.clearMessage();
                        Composite nativeComposite = new Composite(this.parentComposite, 0x1000000);
                        WinDef.HWND nativeCompositeHwnd = new WinDef.HWND();
                        nativeCompositeHwnd.setPointer(new Pointer(nativeComposite.handle));
                        User32.INSTANCE.SetParent(hwnd, nativeCompositeHwnd);
                        nativeComposite.pack();
                        nativeComposite.setBounds(nativeComposite.getParent().getBounds());
                        this.grabWindowLatch.countDown();
                    });
                } else {
                    Display.getDefault().syncExec(() -> {
                        this.showMessage(StringUtils.format((String)"TiGL Viewer started externally with the window title '%s'.\nNote: Closing this view also closes the external window.", (Object[])new Object[]{windowTitle}));
                        LOGGER.debug((Object)StringUtils.format((String)"TiGL Viewer started externally with the window title '%s'.", (Object[])new Object[]{windowTitle}));
                    });
                    this.grabWindowLatch.countDown();
                }
                this.grabApplication.cancel(true);
            }
        }, 250L, 250L);
    }

    private String buildCommonCommandPart(boolean embedWindow, String windowTitle, String exeFilePathString, String ctrlFilePathString) {
        StringBuilder commonCommandPart = new StringBuilder();
        commonCommandPart.append("cmd /C start ");
        if (embedWindow) {
            commonCommandPart.append("/MIN ");
        }
        commonCommandPart.append(exeFilePathString);
        commonCommandPart.append(" --windowtitle ");
        commonCommandPart.append(windowTitle);
        commonCommandPart.append(" --controlFile ");
        commonCommandPart.append(ctrlFilePathString);
        return commonCommandPart.toString();
    }

    private void generateControlFile() {
        String controlContent = "<?xml version=\"1.0\" encoding=\"utf-8\"?>\n<TIGLViewer>\n    <console display=\"0\"/>\n    <toolbars display=\"1\"/>\n</TIGLViewer>";
        try {
            this.ctrlFile = TempFileServiceAccess.getInstance().createTempFileWithFixedFilename("controlfile.xml");
        }
        catch (IOException e) {
            LOGGER.error((Object)"Error generating temp file.", (Throwable)e);
        }
        try {
            Throwable e = null;
            Object var3_6 = null;
            try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.ctrlFile.getAbsolutePath()));){
                writer.write(controlContent);
            }
            catch (Throwable throwable) {
                if (e == null) {
                    e = throwable;
                } else if (e != throwable) {
                    e.addSuppressed(throwable);
                }
                throw e;
            }
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Error generating controlfile for TiGL Viewer.", (Throwable)e);
        }
    }

    private void showMessage(String message) {
        if (this.parentComposite.isDisposed()) {
            return;
        }
        this.clearMessage();
        Composite c = new Composite(this.parentComposite, 0);
        c.setLayout((Layout)new GridLayout(1, false));
        Label label = new Label(c, 0);
        label.setText(message);
        this.parentComposite.pack();
    }

    private void clearMessage() {
        Control[] controlArray = this.parentComposite.getChildren();
        int n = controlArray.length;
        int n2 = 0;
        while (n2 < n) {
            Control c = controlArray[n2];
            c.dispose();
            ++n2;
        }
    }

    private ConfigurationSegment getTiGLViewerConfigurationSegment() {
        ServiceRegistryAccess serviceRegistry = ServiceRegistry.createAccessFor((Object)((Object)this));
        ConfigurationService confService = (ConfigurationService)serviceRegistry.getService(ConfigurationService.class);
        return confService.getConfigurationSegment("thirdPartyIntegration/tiglViewer");
    }

    private String convertToPathStringForExecution(File file) {
        return String.valueOf(file.getAbsolutePath().replaceFirst(REGEXP_QUOTED_BACKSLASH, "\"\\\\")) + DOUBLE_QUOTE;
    }

    public void setFocus() {
    }

    public void dispose() {
        if (this.grabApplication != null) {
            this.grabApplication.cancel(true);
        }
        this.killTiglViewerProcess();
        this.disposeControlFile();
    }

    private void disposeControlFile() {
        if (this.ctrlFile != null) {
            try {
                TempFileServiceAccess.getInstance().disposeManagedTempDirOrFile(this.ctrlFile);
            }
            catch (IOException iOException) {
                LOGGER.error((Object)("Failed to dispose controlfile: " + this.ctrlFile.getAbsolutePath()));
            }
        }
    }

    private void killTiglViewerProcess() {
        if (this.processID != 0) {
            LOGGER.debug((Object)StringUtils.format((String)"Stopping and disposing the TiGL Viewer application with process ID %s.", (Object[])new Object[]{this.processID}));
            try {
                Runtime.getRuntime().exec("taskkill /F /PID " + this.processID);
                this.processID = 0;
            }
            catch (IOException e) {
                LOGGER.error((Object)StringUtils.format((String)"Unable to stop and dispose process with ID %s.", (Object[])new Object[]{this.processID}), (Throwable)e);
            }
        }
    }
}

