/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.incubator;

import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.incubator.StateChangeException;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedExecutionQueue;

public abstract class AbstractStateMachine<S extends Enum<?>, E> {
    private S currentState;
    private AsyncOrderedExecutionQueue eventQueue;

    public AbstractStateMachine(S initialState) {
        this.currentState = initialState;
        this.eventQueue = ConcurrencyUtils.getFactory().createAsyncOrderedExecutionQueue(AsyncCallbackExceptionPolicy.LOG_AND_PROCEED);
    }

    public void postEvent(final E event) {
        this.eventQueue.enqueue(new Runnable(){

            @Override
            public void run() {
                AbstractStateMachine.this.processEventInternal(event);
            }
        });
    }

    private synchronized void processEventInternal(E event) {
        try {
            S newState = this.processEvent(this.currentState, event);
            if (newState == null || newState == this.currentState) {
                return;
            }
            try {
                this.checkProposedStateChange(this.currentState, newState);
            }
            catch (StateChangeException e) {
                throw new StateChangeException(e, (Enum<?>)this.currentState, (Enum<?>)newState);
            }
            S oldState = this.currentState;
            this.currentState = newState;
            this.onStateChanged(oldState, newState);
        }
        catch (StateChangeException e) {
            this.onStateChangeException(event, e);
        }
    }

    public synchronized S getState() {
        return this.currentState;
    }

    protected abstract S processEvent(S var1, E var2) throws StateChangeException;

    protected void checkProposedStateChange(S oldState, S newState) throws StateChangeException {
    }

    protected void onStateChanged(S oldState, S newState) {
    }

    protected abstract void onStateChangeException(E var1, StateChangeException var2);
}

