/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.terminal;

public class TerminalSize {
    private int columns;
    private int rows;

    public TerminalSize(int columns, int rows) {
        this.setColumns(columns);
        this.setRows(rows);
    }

    public TerminalSize(TerminalSize terminalSize) {
        this(terminalSize.getColumns(), terminalSize.getRows());
    }

    public int getColumns() {
        return this.columns;
    }

    public void setColumns(int columns) {
        if (columns < 0) {
            throw new IllegalArgumentException("TerminalSize.columns cannot be less than 0!");
        }
        this.columns = columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        if (rows < 0) {
            throw new IllegalArgumentException("TerminalSize.rows cannot be less than 0!");
        }
        this.rows = rows;
    }

    public String toString() {
        return "{" + this.columns + "x" + this.rows + "}";
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TerminalSize)) {
            return false;
        }
        TerminalSize other = (TerminalSize)obj;
        return this.columns == other.columns && this.rows == other.rows;
    }

    public int hashCode() {
        int hash = 5;
        hash = 53 * hash + this.columns;
        hash = 53 * hash + this.rows;
        return hash;
    }
}

