/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.screen;

import com.googlecode.lanterna.screen.ScreenCharacterStyle;
import com.googlecode.lanterna.terminal.Terminal;
import java.util.EnumSet;
import java.util.Set;

class ScreenCharacter {
    private final char character;
    private final Terminal.Color foregroundColor;
    private final Terminal.Color backgroundColor;
    private final boolean bold;
    private final boolean underline;
    private final boolean reverse;
    private final boolean blinking;

    ScreenCharacter(char character) {
        this(character, Terminal.Color.DEFAULT, Terminal.Color.DEFAULT);
    }

    ScreenCharacter(char character, Terminal.Color foregroundColor, Terminal.Color backgroundColor) {
        this(character, foregroundColor, backgroundColor, EnumSet.noneOf(ScreenCharacterStyle.class));
    }

    ScreenCharacter(char character, Terminal.Color foregroundColor, Terminal.Color backgroundColor, Set<ScreenCharacterStyle> style) {
        if (foregroundColor == null) {
            foregroundColor = Terminal.Color.DEFAULT;
        }
        if (backgroundColor == null) {
            backgroundColor = Terminal.Color.DEFAULT;
        }
        this.character = character;
        this.foregroundColor = foregroundColor;
        this.backgroundColor = backgroundColor;
        this.bold = style.contains((Object)ScreenCharacterStyle.Bold);
        this.underline = style.contains((Object)ScreenCharacterStyle.Underline);
        this.reverse = style.contains((Object)ScreenCharacterStyle.Reverse);
        this.blinking = style.contains((Object)ScreenCharacterStyle.Blinking);
    }

    ScreenCharacter(ScreenCharacter character) {
        this.character = character.character;
        this.foregroundColor = character.foregroundColor;
        this.backgroundColor = character.backgroundColor;
        this.bold = character.bold;
        this.underline = character.underline;
        this.reverse = character.reverse;
        this.blinking = character.blinking;
    }

    char getCharacter() {
        return this.character;
    }

    Terminal.Color getBackgroundColor() {
        return this.backgroundColor;
    }

    boolean isBold() {
        return this.bold;
    }

    Terminal.Color getForegroundColor() {
        return this.foregroundColor;
    }

    boolean isNegative() {
        return this.reverse;
    }

    boolean isUnderline() {
        return this.underline;
    }

    boolean isBlinking() {
        return this.blinking;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ScreenCharacter)) {
            return false;
        }
        ScreenCharacter other = (ScreenCharacter)obj;
        return this.character == other.getCharacter() && this.getForegroundColor() == other.getForegroundColor() && this.getBackgroundColor() == other.getBackgroundColor() && this.isBold() == other.isBold() && this.isNegative() == other.isNegative() && this.isUnderline() == other.isUnderline() && this.isBlinking() == other.isBlinking();
    }

    public int hashCode() {
        int hash = 5;
        hash = 71 * hash + this.character;
        return hash;
    }

    public String toString() {
        return Character.toString(this.character);
    }
}

