/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna.gui.component;

import com.googlecode.lanterna.gui.Interactable;
import com.googlecode.lanterna.gui.component.AbstractComponent;
import com.googlecode.lanterna.gui.component.InteractableComponent;
import com.googlecode.lanterna.gui.listener.ComponentListener;
import com.googlecode.lanterna.terminal.TerminalPosition;

public abstract class AbstractInteractableComponent
extends AbstractComponent
implements InteractableComponent {
    private boolean hasFocus;
    private TerminalPosition hotspot = null;

    @Override
    public final void onEnterFocus(Interactable.FocusChangeDirection direction) {
        this.hasFocus = true;
        for (ComponentListener cl : this.getComponentListeners()) {
            cl.onComponentReceivedFocus(this);
        }
        this.afterEnteredFocus(direction);
    }

    @Override
    public final void onLeaveFocus(Interactable.FocusChangeDirection direction) {
        this.hasFocus = false;
        for (ComponentListener cl : this.getComponentListeners()) {
            cl.onComponentLostFocus(this);
        }
        this.afterLeftFocus(direction);
    }

    protected void afterEnteredFocus(Interactable.FocusChangeDirection direction) {
    }

    protected void afterLeftFocus(Interactable.FocusChangeDirection direction) {
    }

    public boolean hasFocus() {
        return this.hasFocus;
    }

    @Override
    public TerminalPosition getHotspot() {
        return this.hotspot;
    }

    protected void setHotspot(TerminalPosition point) {
        this.hotspot = point;
    }
}

