/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.lanterna;

import com.googlecode.lanterna.gui.GUIScreen;
import com.googlecode.lanterna.screen.Screen;
import com.googlecode.lanterna.terminal.Terminal;
import com.googlecode.lanterna.terminal.swing.SwingTerminal;
import com.googlecode.lanterna.terminal.swing.TerminalAppearance;
import com.googlecode.lanterna.terminal.text.CygwinTerminal;
import com.googlecode.lanterna.terminal.text.UnixTerminal;
import java.awt.GraphicsEnvironment;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;

public class TerminalFacade {
    private static final Charset DEFAULT_CHARSET = Charset.forName(System.getProperty("file.encoding"));

    private TerminalFacade() {
    }

    public static Terminal createTerminal() {
        return TerminalFacade.createTerminal(DEFAULT_CHARSET);
    }

    public static Terminal createTerminal(Charset terminalCharset) {
        return TerminalFacade.createTerminal(System.in, System.out, terminalCharset);
    }

    public static Terminal createTerminal(InputStream terminalInput, OutputStream terminalOutput) {
        return TerminalFacade.createTerminal(terminalInput, terminalOutput, DEFAULT_CHARSET);
    }

    public static Terminal createTerminal(InputStream terminalInput, OutputStream terminalOutput, Charset terminalCharset) {
        if (GraphicsEnvironment.isHeadless()) {
            return TerminalFacade.createTextTerminal(terminalInput, terminalOutput, terminalCharset);
        }
        return TerminalFacade.createSwingTerminal();
    }

    public static SwingTerminal createSwingTerminal() {
        return TerminalFacade.createSwingTerminal(100, 30);
    }

    public static SwingTerminal createSwingTerminal(int columns, int rows) {
        return new SwingTerminal(columns, rows);
    }

    public static SwingTerminal createSwingTerminal(TerminalAppearance appearance) {
        return TerminalFacade.createSwingTerminal(appearance, 100, 30);
    }

    public static SwingTerminal createSwingTerminal(TerminalAppearance appearance, int columns, int rows) {
        return new SwingTerminal(appearance, columns, rows);
    }

    public static UnixTerminal createUnixTerminal() {
        return TerminalFacade.createUnixTerminal(DEFAULT_CHARSET);
    }

    public static UnixTerminal createUnixTerminal(Charset terminalCharset) {
        return TerminalFacade.createUnixTerminal(System.in, System.out, terminalCharset);
    }

    public static UnixTerminal createUnixTerminal(InputStream terminalInput, OutputStream terminalOutput) {
        return TerminalFacade.createUnixTerminal(terminalInput, terminalOutput, DEFAULT_CHARSET);
    }

    public static UnixTerminal createUnixTerminal(InputStream terminalInput, OutputStream terminalOutput, Charset terminalCharset) {
        return new UnixTerminal(terminalInput, terminalOutput, terminalCharset);
    }

    public static CygwinTerminal createCygwinTerminal() {
        return TerminalFacade.createCygwinTerminal(DEFAULT_CHARSET);
    }

    public static CygwinTerminal createCygwinTerminal(Charset terminalCharset) {
        return TerminalFacade.createCygwinTerminal(System.in, System.out, terminalCharset);
    }

    public static CygwinTerminal createCygwinTerminal(InputStream terminalInput, OutputStream terminalOutput) {
        return TerminalFacade.createCygwinTerminal(terminalInput, terminalOutput, DEFAULT_CHARSET);
    }

    public static CygwinTerminal createCygwinTerminal(InputStream terminalInput, OutputStream terminalOutput, Charset terminalCharset) {
        return new CygwinTerminal(terminalInput, terminalOutput, terminalCharset);
    }

    public static Terminal createTextTerminal() {
        return TerminalFacade.createTextTerminal(System.in, System.out, DEFAULT_CHARSET);
    }

    public static Terminal createTextTerminal(InputStream terminalInput, OutputStream terminalOutput, Charset terminalCharset) {
        if (System.getProperty("os.name", "").toLowerCase().startsWith("windows")) {
            return TerminalFacade.createCygwinTerminal(terminalInput, terminalOutput, terminalCharset);
        }
        return TerminalFacade.createUnixTerminal(terminalInput, terminalOutput, terminalCharset);
    }

    public static Screen createScreen() {
        return TerminalFacade.createScreen(TerminalFacade.createTerminal());
    }

    public static Screen createScreen(Terminal terminal) {
        return new Screen(terminal);
    }

    public static GUIScreen createGUIScreen() {
        return new GUIScreen(TerminalFacade.createScreen());
    }

    public static GUIScreen createGUIScreen(Terminal terminal) {
        return new GUIScreen(TerminalFacade.createScreen(terminal));
    }

    public static GUIScreen createGUIScreen(Screen screen) {
        return new GUIScreen(screen);
    }
}

