/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.monitoring.system.internal;

import de.rcenvironment.core.monitoring.system.api.model.AverageOfDoubles;
import de.rcenvironment.core.monitoring.system.api.model.FullSystemAndProcessDataSnapshot;
import de.rcenvironment.core.monitoring.system.api.model.ProcessInformation;
import de.rcenvironment.core.monitoring.system.api.model.SystemLoadInformation;
import de.rcenvironment.core.monitoring.system.internal.RingBuffer;
import de.rcenvironment.core.monitoring.system.internal.RingBufferOfDouble;
import de.rcenvironment.core.monitoring.system.internal.SystemDataSnapshot;
import de.rcenvironment.core.monitoring.system.internal.SystemIntegrationAdapter;
import de.rcenvironment.core.utils.common.OSFamily;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import oshi.software.os.OSProcess;

public final class SystemMonitoringDataProcessor {
    private final long totalRam;
    private final RingBuffer<SystemDataSnapshot> ringBuffer;
    private final SystemIntegrationAdapter adapter;
    private final Log log = LogFactory.getLog(this.getClass());
    private FullSystemAndProcessDataSnapshot cachedFullSnapshot;
    private SystemLoadInformation defaultLoadInformation;
    private SystemDataSnapshot cachedDataSnapshot;

    public SystemMonitoringDataProcessor(RingBuffer<SystemDataSnapshot> ringBuffer, SystemIntegrationAdapter adapter) {
        this.ringBuffer = ringBuffer;
        this.adapter = adapter;
        this.totalRam = this.adapter.getTotalRam();
        this.cachedDataSnapshot = new SystemDataSnapshot(0L, null, 0.0, 0L, null, null);
        this.cachedFullSnapshot = new FullSystemAndProcessDataSnapshot(0.0, 0L, this.totalRam, 0.0, Collections.emptyList(), Collections.emptyList());
        this.defaultLoadInformation = new SystemLoadInformation(new AverageOfDoubles(), 0.0, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FullSystemAndProcessDataSnapshot createFullSystemSnapshot() {
        List<SystemDataSnapshot> snapshots = this.ringBuffer.getLastItems(2);
        SystemDataSnapshot systemDataSnapshot = this.cachedDataSnapshot;
        synchronized (systemDataSnapshot) {
            if (snapshots.size() > 1 && this.cachedDataSnapshot != snapshots.get(1)) {
                this.cachedDataSnapshot = snapshots.get(1);
                this.cachedFullSnapshot = this.createFullSystemSnapshot(snapshots.get(1), snapshots.get(0));
            }
        }
        return this.cachedFullSnapshot;
    }

    public SystemLoadInformation getSystemLoadInformation(int maxSamples) {
        List<SystemDataSnapshot> snapshots = this.ringBuffer.getLastItems(maxSamples);
        if (snapshots.size() > 0) {
            return this.getSystemLoadInformation(snapshots);
        }
        return this.defaultLoadInformation;
    }

    private FullSystemAndProcessDataSnapshot createFullSystemSnapshot(SystemDataSnapshot newSnapshot, SystemDataSnapshot oldSnapshot) {
        double cpuUsage = newSnapshot.getTotalCpuUsage();
        double idle = 1.0 - cpuUsage;
        long ramUsage = newSnapshot.getTotalSystemRamUsage();
        if (oldSnapshot.getRceOwnProcess() != null) {
            Set<OSProcess> oldProcesses = oldSnapshot.getRceSubProcesses();
            oldProcesses.add(oldSnapshot.getRceOwnProcess());
            ProcessInformation rceProcess = this.createProcessInformationFromOsProcess(newSnapshot.getRceOwnProcess(), newSnapshot.getRceSubProcesses(), oldProcesses);
            List<ProcessInformation> subProcesses = rceProcess.getChildren();
            ArrayList<ProcessInformation> rceProcesses = new ArrayList<ProcessInformation>();
            rceProcesses.add(rceProcess);
            this.orderOwnAndSubProcesses(rceProcesses, subProcesses);
            return new FullSystemAndProcessDataSnapshot(cpuUsage, ramUsage, this.totalRam, idle, subProcesses, rceProcesses);
        }
        return new FullSystemAndProcessDataSnapshot(cpuUsage, ramUsage, this.totalRam, idle, Collections.emptyList(), Collections.emptyList());
    }

    private SystemLoadInformation getSystemLoadInformation(List<SystemDataSnapshot> snapshots) {
        double latestCpuLoad = snapshots.get(snapshots.size() - 1).getTotalCpuUsage();
        long latestRamUsage = snapshots.get(snapshots.size() - 1).getTotalSystemRamUsage();
        RingBufferOfDouble doubleRingBuffer = new RingBufferOfDouble(snapshots.size());
        snapshots.forEach(element -> doubleRingBuffer.add(element.getTotalCpuUsage()));
        return new SystemLoadInformation(doubleRingBuffer.getAverageOfLatest(snapshots.size()), latestCpuLoad, latestRamUsage);
    }

    private ProcessInformation createProcessInformationFromOsProcess(OSProcess parent, Set<OSProcess> processes, Set<OSProcess> oldProcesses) {
        double cpuUsage = 0.0;
        for (OSProcess oldProcess : oldProcesses) {
            if (parent.getProcessID() != oldProcess.getProcessID()) continue;
            cpuUsage = parent.getProcessCpuLoadBetweenTicks(oldProcess) / (double)this.adapter.getLogicalProcessorsCount();
            break;
        }
        long ramUsage = parent.getResidentSetSize();
        List<OSProcess> directChildren = processes.stream().filter(child -> child.getParentProcessID() == parent.getProcessID()).collect(Collectors.toList());
        ArrayList<ProcessInformation> children = new ArrayList<ProcessInformation>();
        directChildren.forEach(child -> children.add(this.createProcessInformationFromOsProcess((OSProcess)child, processes, oldProcesses)));
        return new ProcessInformation(parent.getProcessID(), parent.getName(), children, cpuUsage, ramUsage);
    }

    private void orderOwnAndSubProcesses(List<ProcessInformation> ownProcesses, List<ProcessInformation> subProcesses) {
        List processesToDelete;
        if (OSFamily.isLinux()) {
            List processesToMove = subProcesses.stream().filter(process -> process.getName().startsWith("WebKit")).collect(Collectors.toList());
            if (!processesToMove.isEmpty()) {
                ownProcesses.addAll(processesToMove);
                subProcesses.removeAll(processesToMove);
            }
        } else if (OSFamily.isWindows() && !(processesToDelete = subProcesses.stream().filter(process -> process.getName().equals("conhost")).collect(Collectors.toList())).isEmpty()) {
            this.log.debug((Object)"Eliminated 'conhost' from the list of sub-processes; this is normal during integration tests, please report any other sightings");
            subProcesses.removeAll(processesToDelete);
        }
    }
}

