/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.component.execution.internal;

import de.rcenvironment.core.communication.api.CommunicationService;
import de.rcenvironment.core.communication.api.PlatformService;
import de.rcenvironment.core.communication.common.NetworkDestination;
import de.rcenvironment.core.communication.common.ResolvableNodeId;
import de.rcenvironment.core.component.execution.api.ComponentControllerRoutingMap;
import de.rcenvironment.core.component.execution.api.ComponentExecutionController;
import de.rcenvironment.core.component.execution.api.EndpointDatumDispatchService;
import de.rcenvironment.core.component.execution.api.EndpointDatumSerializer;
import de.rcenvironment.core.component.execution.api.ExecutionControllerException;
import de.rcenvironment.core.component.execution.api.LocalExecutionControllerUtilsService;
import de.rcenvironment.core.component.execution.api.RemotableComponentExecutionControllerService;
import de.rcenvironment.core.component.execution.api.RemotableEndpointDatumDispatcher;
import de.rcenvironment.core.component.model.endpoint.api.EndpointDatum;
import de.rcenvironment.core.toolkitbridge.transitional.ConcurrencyUtils;
import de.rcenvironment.core.utils.common.StringUtils;
import de.rcenvironment.core.utils.common.rpc.RemoteOperationException;
import de.rcenvironment.core.utils.common.security.AllowRemoteAccess;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncCallbackExceptionPolicy;
import de.rcenvironment.toolkit.modules.concurrency.api.AsyncOrderedExecutionQueue;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.collections4.map.LRUMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.osgi.framework.BundleContext;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Reference;

@Component
public class EndpointDatumDispatcherImpl
implements EndpointDatumDispatchService,
RemotableEndpointDatumDispatcher {
    private static final String FAILED_TO_SEND_ENDPOINT_DATUM = "Failed to send endpoint datum %s";
    private static final Log LOG = LogFactory.getLog(EndpointDatumDispatcherImpl.class);
    private static final int CACHE_SIZE = 20;
    private AsyncOrderedExecutionQueue executionQueue = ConcurrencyUtils.getFactory().createAsyncOrderedExecutionQueue(AsyncCallbackExceptionPolicy.LOG_AND_PROCEED);
    private Map<String, WeakReference<ComponentExecutionController>> compExeCtrls = new LRUMap(20);
    private Map<String, ComponentControllerRoutingMap> componentControllerForwardingMaps = Collections.synchronizedMap(new HashMap());
    private BundleContext bundleContext;
    private CommunicationService communicationService;
    private LocalExecutionControllerUtilsService exeCtrlUtilsService;
    private PlatformService platformService;
    private EndpointDatumSerializer endpointDatumSerializer;

    @Activate
    protected void activate(BundleContext context) {
        this.bundleContext = context;
    }

    @Override
    public void dispatchEndpointDatum(final EndpointDatum endpointDatum) {
        final String executionId = endpointDatum.getInputsComponentExecutionIdentifier();
        this.executionQueue.enqueue(new Runnable(){

            @Override
            public void run() {
                if (EndpointDatumDispatcherImpl.this.platformService.matchesLocalInstance((ResolvableNodeId)endpointDatum.getDestinationNodeId())) {
                    EndpointDatumDispatcherImpl.this.processEndpointDatum(executionId, endpointDatum);
                } else {
                    EndpointDatumDispatcherImpl.this.forwardEndpointDatum(endpointDatum);
                }
            }
        });
    }

    @Override
    @AllowRemoteAccess
    public void dispatchEndpointDatum(String serializedEndpointDatum) {
        this.dispatchEndpointDatum(this.endpointDatumSerializer.deserializeEndpointDatum(serializedEndpointDatum));
    }

    @Override
    public void registerComponentControllerForwardingMap(String workflowExecutionId, ComponentControllerRoutingMap destinationMap) {
        this.componentControllerForwardingMaps.put(workflowExecutionId, destinationMap);
        LOG.debug((Object)("Registered component endpoint forwarding map for workflow " + workflowExecutionId));
    }

    @Override
    public void unregisterComponentControllerForwardingMap(String workflowExecutionId) {
        this.componentControllerForwardingMaps.remove(workflowExecutionId);
        LOG.debug((Object)("Unregistered component endpoint forwarding map for workflow " + workflowExecutionId));
    }

    protected void forwardEndpointDatum(EndpointDatum endpointDatum) {
        try {
            NetworkDestination networkDestination;
            if (endpointDatum.getNetworkDestination() != null) {
                networkDestination = endpointDatum.getNetworkDestination();
            } else {
                String workflowExecutionIdentifier = endpointDatum.getWorkflowExecutionIdentifier();
                String componentExecutionIdentifier = endpointDatum.getInputsComponentExecutionIdentifier();
                ComponentControllerRoutingMap routingMap = this.componentControllerForwardingMaps.get(workflowExecutionIdentifier);
                if (routingMap == null) {
                    throw new RemoteOperationException("A endpoint datum forwarding for target component " + componentExecutionIdentifier + " was requested, but there is no routing information available for workflow " + workflowExecutionIdentifier);
                }
                networkDestination = routingMap.getNetworkDestinationForComponentController(componentExecutionIdentifier);
                if (networkDestination == null) {
                    throw new RemoteOperationException("Found routing information for workflow " + workflowExecutionIdentifier + ", but it did not contain a route for component " + componentExecutionIdentifier);
                }
            }
            RemotableEndpointDatumDispatcher dispatcher = (RemotableEndpointDatumDispatcher)this.communicationService.getRemotableService(RemotableEndpointDatumDispatcher.class, networkDestination);
            dispatcher.dispatchEndpointDatum(this.endpointDatumSerializer.serializeEndpointDatum(endpointDatum));
        }
        catch (RemoteOperationException e) {
            this.callbackComponentExecutionController(endpointDatum, e);
        }
    }

    protected void callbackComponentExecutionController(EndpointDatum endpointDatum, RemoteOperationException e) {
        if (this.platformService.matchesLocalInstance((ResolvableNodeId)endpointDatum.getOutputsNodeId())) {
            this.callbackComponentExecutionControllerLocally(endpointDatum, e);
        } else {
            this.callbackComponentExecutionControllerRemotely(endpointDatum, e);
        }
    }

    private void callbackComponentExecutionControllerLocally(EndpointDatum endpointDatum, RemoteOperationException e) {
        String executionId = endpointDatum.getOutputsComponentExecutionIdentifier();
        ComponentExecutionController compExeCtrl = null;
        try {
            compExeCtrl = this.getComponentExecutionController(executionId);
        }
        catch (ExecutionControllerException e1) {
            LOG.warn((Object)StringUtils.format((String)"Failed to announce that sending endpoint datum '%s'; failed cause: %s", (Object[])new Object[]{endpointDatum.toString(), e1.toString()}));
            return;
        }
        compExeCtrl.onSendingEndointDatumFailed(endpointDatum, e);
    }

    private void callbackComponentExecutionControllerRemotely(EndpointDatum endpointDatum, RemoteOperationException e) {
        String outputCompExeId = endpointDatum.getOutputsComponentExecutionIdentifier();
        RemotableComponentExecutionControllerService compExeCtrlService = (RemotableComponentExecutionControllerService)this.communicationService.getRemotableService(RemotableComponentExecutionControllerService.class, (NetworkDestination)endpointDatum.getOutputsNodeId());
        try {
            compExeCtrlService.onSendingEndointDatumFailed(outputCompExeId, this.endpointDatumSerializer.serializeEndpointDatum(endpointDatum), e);
        }
        catch (ExecutionControllerException | RemoteOperationException e1) {
            LOG.warn((Object)StringUtils.format((String)"Failed to announce that sending endpoint datum '%s' failed; cause: %s", (Object[])new Object[]{endpointDatum, e1.toString()}));
        }
    }

    protected void processEndpointDatum(String executionId, EndpointDatum endpointDatum) {
        ComponentExecutionController compExeCtrl = null;
        try {
            compExeCtrl = this.getComponentExecutionController(executionId);
        }
        catch (ExecutionControllerException e) {
            LOG.warn((Object)StringUtils.format((String)"Endpoint datum '%s' not processed; cause: %s", (Object[])new Object[]{endpointDatum.toString(), e.toString()}));
            return;
        }
        compExeCtrl.onEndpointDatumReceived(endpointDatum);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ComponentExecutionController getComponentExecutionController(String executionId) throws ExecutionControllerException {
        ComponentExecutionController compExeCtrl = null;
        Map<String, WeakReference<ComponentExecutionController>> map = this.compExeCtrls;
        synchronized (map) {
            if (this.compExeCtrls.containsKey(executionId)) {
                compExeCtrl = (ComponentExecutionController)this.compExeCtrls.get(executionId).get();
            }
            if (compExeCtrl == null) {
                compExeCtrl = this.exeCtrlUtilsService.getExecutionController(ComponentExecutionController.class, executionId, this.bundleContext);
                this.compExeCtrls.put(executionId, new WeakReference<ComponentExecutionController>(compExeCtrl));
            }
        }
        return compExeCtrl;
    }

    @Reference
    protected void bindCommunicationService(CommunicationService newService) {
        this.communicationService = newService;
    }

    @Reference
    protected void bindLocalExecutionControllerUtilsService(LocalExecutionControllerUtilsService newService) {
        this.exeCtrlUtilsService = newService;
    }

    @Reference
    protected void bindPlatformService(PlatformService newService) {
        this.platformService = newService;
    }

    @Reference
    protected void bindEndpointDatumSerializer(EndpointDatumSerializer newService) {
        this.endpointDatumSerializer = newService;
    }
}

