/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.communication.transport.jms.common;

import de.rcenvironment.core.communication.channel.MessageChannelState;
import de.rcenvironment.core.communication.channel.ServerContactPoint;
import de.rcenvironment.core.communication.common.InstanceNodeSessionId;
import de.rcenvironment.core.communication.transport.jms.common.AbstractJmsMessageChannel;
import javax.jms.Connection;
import javax.jms.JMSException;

public class RemoteInitiatedJmsMessageChannel
extends AbstractJmsMessageChannel {
    public RemoteInitiatedJmsMessageChannel(InstanceNodeSessionId localNodeId, Connection connection, ServerContactPoint associatedSCP) throws JMSException {
        super(localNodeId);
        this.connection = connection;
        this.associatedSCP = associatedSCP;
    }

    @Override
    protected void onClosedOrBroken() {
        this.log.debug((Object)("Closing remote-initiated channel " + this.getChannelId()));
        super.onClosedOrBroken();
        if (this.getState() == MessageChannelState.CLOSED) {
            this.sendShutdownMessageToRemoteRequestInbox();
        }
        if (this.getShutdownSecurityToken() != null) {
            try {
                this.asyncSendShutdownMessageToB2CJmsQueue();
            }
            catch (JMSException e) {
                this.log.debug((Object)("Error sending shutdown message for queue " + this.getOutgoingRequestQueueName()), (Throwable)e);
            }
        } else {
            this.log.warn((Object)"No shutdown security token set for remote-initiated connection");
        }
    }
}

