/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.log.internal;

import de.rcenvironment.core.log.SerializableLogEntry;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;

public class LogTableColumnSorter
extends ViewerSorter {
    private static final int FIRST_IS_EQUAL = 0;
    private static final int SORT_ASCENDING = 1;
    private static final int SORT_DESCENDING = 2;
    private int myDirection = 2;
    private int myColumnToSort = 3;

    public void setColumn(int column) {
        if (column == this.myColumnToSort) {
            this.myDirection = 1 == this.myDirection ? 2 : 1;
        } else {
            this.myColumnToSort = column;
            this.myDirection = 1;
        }
    }

    public int compare(Viewer viewer, Object object1, Object object2) {
        int returnValue = 0;
        if (object1 instanceof SerializableLogEntry && object2 instanceof SerializableLogEntry) {
            SerializableLogEntry le1 = (SerializableLogEntry)object1;
            SerializableLogEntry le2 = (SerializableLogEntry)object2;
            switch (this.myColumnToSort) {
                case 0: {
                    returnValue = new Integer(le1.getLevel()).compareTo(le2.getLevel());
                    break;
                }
                case 1: {
                    returnValue = le1.getMessage().compareTo(le2.getMessage());
                    break;
                }
                case 2: {
                    returnValue = le1.getBundleName().compareTo(le2.getBundleName());
                    break;
                }
                case 3: {
                    returnValue = le1.getPlatformIdentifer().toString().compareTo(le2.getPlatformIdentifer().toString());
                    break;
                }
                case 4: {
                    returnValue = new Long(le1.getTime()).compareTo(le2.getTime());
                    break;
                }
            }
            if (2 == this.myDirection) {
                returnValue = -returnValue;
            }
        }
        return returnValue;
    }
}

