/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.editor.commands;

import de.rcenvironment.core.component.workflow.model.api.Connection;
import de.rcenvironment.core.component.workflow.model.api.WorkflowNode;
import de.rcenvironment.core.gui.workflow.ConnectionUtils;
import de.rcenvironment.core.gui.workflow.editor.WorkflowEditor;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.ui.PlatformUI;

public class WorkflowNodeMoveCommand
extends Command {
    private WorkflowNode node;
    private ChangeBoundsRequest request;
    private Point newLocation;
    private Point oldLocation;
    private List<Connection> relatedConnections;
    private int deltaX;
    private int deltaY;

    public WorkflowNodeMoveCommand(WorkflowNode node, ChangeBoundsRequest req, Rectangle newBounds, List<Connection> relatedConnections) {
        this.node = node;
        this.request = req;
        this.newLocation = newBounds.getLocation();
        this.relatedConnections = relatedConnections;
    }

    public boolean canExecute() {
        Object type = this.request.getType();
        boolean execute = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor() instanceof WorkflowEditor;
        return execute && ("move".equals(type) || "move children".equals(type));
    }

    public void execute() {
        this.oldLocation = new Point(this.node.getX(), this.node.getY());
        this.deltaX = this.newLocation.x - this.oldLocation.x;
        this.deltaY = this.newLocation.y - this.oldLocation.y;
        this.redo();
    }

    public void redo() {
        this.node.setLocation(this.newLocation.x, this.newLocation.y);
        for (Connection connection : this.relatedConnections) {
            connection.setBendpoints(ConnectionUtils.translateBendpointListByOffset(connection.getBendpoints(), this.deltaX / 2, this.deltaY / 2));
        }
    }

    public void undo() {
        this.node.setLocation(this.oldLocation.x, this.oldLocation.y);
        for (Connection connection : this.relatedConnections) {
            connection.setBendpoints(ConnectionUtils.translateBendpointListByOffset(connection.getBendpoints(), -(this.deltaX / 2), -(this.deltaY / 2)));
        }
    }
}

