/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.utils.scripting;

import de.rcenvironment.core.utils.common.StringUtils;

public final class ScriptableComponentConstants {
    public static final ScriptTime PRE = ScriptTime.PRE;
    public static final ScriptTime POST = ScriptTime.POST;
    public static final ComponentRunMode INIT = ComponentRunMode.INIT;
    public static final ComponentRunMode RUN = ComponentRunMode.RUN;
    public static final String PRE_INIT_SCRIPT = "preInitScript";
    public static final String PRE_INIT_SCRIPT_LANGUAGE = "preInitScriptLanguage";
    public static final String DO_PRE_INIT_SCRIPT = "doPreInitScript";
    public static final String PRE_RUN_SCRIPT = "preRunScript";
    public static final String PRE_RUN_SCRIPT_LANGUAGE = "preRunScriptLanguage";
    public static final String POST_INIT_SCRIPT = "postInitScript";
    public static final String POST_INIT_SCRIPT_LANGUAGE = "postInitScriptLanguage";
    public static final String DO_POST_INIT_SCRIPT = "doPostInitScript";
    public static final String POST_RUN_SCRIPT = "postRunScript";
    public static final String POST_RUN_SCRIPT_LANGUAGE = "postRunScriptLanguage";
    public static final String PY = "py";
    public static final PropertyFactory FACTORY = new PropertyFactory();

    private ScriptableComponentConstants() {
    }

    public static enum ComponentRunMode {
        INIT,
        RUN;


        private String infix() {
            return String.valueOf(this.name().substring(0, 1).toUpperCase()) + this.name().substring(1).toLowerCase();
        }
    }

    public static final class PropertyFactory {
        private PropertyFactory() {
        }

        public String doScript(ScriptTime scriptTime, ComponentRunMode componentRunMode) {
            return StringUtils.format((String)"do%s%sScript", (Object[])new Object[]{scriptTime.infix(), componentRunMode.infix()});
        }

        public String script(ScriptTime scriptTime, ComponentRunMode componentRunMode) {
            return StringUtils.format((String)"%s%sScript", (Object[])new Object[]{scriptTime.prefix(), componentRunMode.infix()});
        }

        public String language(ScriptTime scriptTime, ComponentRunMode componentRunMode) {
            return StringUtils.format((String)"%s%sScriptLanguage", (Object[])new Object[]{scriptTime.prefix(), componentRunMode.infix()});
        }
    }

    public static enum ScriptTime {
        PRE,
        POST;


        private String prefix() {
            return this.name().toLowerCase();
        }

        private String infix() {
            return String.valueOf(this.name().substring(0, 1).toUpperCase()) + this.name().substring(1).toLowerCase();
        }
    }
}

