/*
 * Decompiled with CFR 0.152.
 */
package de.rcenvironment.core.gui.workflow.view.list;

import de.rcenvironment.core.component.workflow.execution.api.WorkflowExecutionInformation;
import de.rcenvironment.core.component.workflow.execution.api.WorkflowState;
import de.rcenvironment.core.gui.workflow.Activator;
import de.rcenvironment.core.gui.workflow.view.list.WorkflowStateModel;
import java.text.SimpleDateFormat;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;

public class WorkflowInformationLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    public String getColumnText(Object element, int column) {
        String text = "";
        if (element instanceof WorkflowExecutionInformation) {
            if (column == 0) {
                text = ((WorkflowExecutionInformation)element).getInstanceName();
            } else if (column == 1) {
                WorkflowState state = WorkflowStateModel.getInstance().getState(((WorkflowExecutionInformation)element).getExecutionIdentifier());
                if (state != null) {
                    text = state.getDisplayName();
                }
            } else {
                if (column == 2) {
                    return ((WorkflowExecutionInformation)element).getWorkflowDescription().getControllerNode().getAssociatedDisplayName();
                }
                if (column == 3) {
                    SimpleDateFormat df = new SimpleDateFormat("yyyy.MM.dd  HH:mm:ss");
                    text = df.format(((WorkflowExecutionInformation)element).getStartTime());
                } else if (column == 4) {
                    text = ((WorkflowExecutionInformation)element).getNodeIdStartedExecution().getAssociatedDisplayName();
                } else if (column == 5) {
                    text = ((WorkflowExecutionInformation)element).getAdditionalInformationProvidedAtStart();
                }
            }
        }
        return text;
    }

    public Image getColumnImage(Object element, int column) {
        if (element instanceof WorkflowExecutionInformation && column == 0) {
            WorkflowState state = WorkflowStateModel.getInstance().getState(((WorkflowExecutionInformation)element).getExecutionIdentifier());
            return Activator.getInstance().getImageRegistry().get(state.name());
        }
        return null;
    }
}

